
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

<div class="col-span-12 lg:col-span-12">

<?php
// Initialize variables


    // JOIN student_analysis to get rank & accuracy

$student_id = $_SESSION['student_id'] ?? 0;

$sql = "
    SELECT s.*, 
           a.student_class_rank, 
           a.student_accuracy
    FROM students s
    LEFT JOIN student_analysis a 
           ON s.student_id = a.student_id
    WHERE s.student_id = ?
    ORDER BY a.student_class_rank ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $student_id);
$stmt->execute();
$result = $stmt->get_result();

?>



<!-- Results -->
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">
<?php
if (isset($result) && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $isBright = ($row['student_class_rank'] !== null && $row['student_class_rank'] <= 5);
?>
<div class="card" style="<?= $isBright ? 'border: 2px solid #4ade80; box-shadow: 0 0 6px rgba(74, 222, 128, 0.4);' : '' ?>">
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
  <div class="avatar size-20">
      <img class="rounded-full" src="<?= $row['student_image'] ?: 'images/200x200.png' ?>" alt="avatar"/>
  </div>
  <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
      <?= $row['student_name']." ".$row['student_surname'] ?>
  </h3>
  <p class="text-xs-plus"><?= $row['student_class']." - ".$row['student_division'] ?></p>

  <?php if ($row['student_class_rank'] !== null): ?>
      <p class="mt-1 text-sm text-slate-500">
          Class Rank: <strong><?= $row['student_class_rank'] ?></strong>
      </p>
      <p class="text-sm text-slate-500">
          Accuracy: <strong><?= $row['student_accuracy'] ?>%</strong>
      </p>
      <?php if ($isBright): ?>
          <span class="tag rounded-full bg-yellow-100 text-yellow-800 mt-1">Bright Student</span>
      <?php endif; ?>
  <?php endif; ?>

  <div class="inline-space mt-3 flex grow flex-wrap items-start">
      <span class="tag rounded-full bg-success/10 text-success">GR: <?= $row['student_gr_no'] ?></span>
      <span class="tag rounded-full bg-success/10 text-success">Mobile: <?= $row['student_phonenumber'] ?></span>
  </div>


        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No students found.</p>";
}
?>
</div>

</div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>
lementById('targetPage<?= $row['student_id'] ?>').value='staff-view-student-main.php';
                   document.getElementById('studentForm<?= $row['student_id'] ?>').submit();">
          View Profile
      </button>           
      <button type="button" class="btn space-x-2 bg-slate-150 px-0 font-medium text-slate-800"
          onclick="document.getElementById('targetPage<?= $row['student_id'] ?>').value='staff-edit-student.php';
                   document.getElementById('studentForm<?= $row['student_id'] ?>').submit();">
          Edit Profile
      </button>
  </div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No students found.</p>";
}
?>
</div>

</div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>
line-space mt-3 flex grow flex-wrap items-start">
      <span class="tag rounded-full bg-success/10 text-success">GR: <?= $row['student_gr_no'] ?></span>
      <span class="tag rounded-full bg-success/10 text-success">Mobile: <?= $row['student_phonenumber'] ?></span>
  </div>

  <!-- Hidden Form -->
  <form action="set-student-id.php" method="POST" id="studentForm<?= $row['student_id'] ?>" style="display:none;">
      <input type="hidden" name="student_id" value="<?= $row['student_id'] ?>">
      <input type="hidden" name="target_page" id="targetPage<?= $row['student_id'] ?>" value="">
  </form>

  <div class="mt-6 grid w-full grid-cols-2 gap-2">
      <button type="button" class="btn space-x-2 bg-primary px-0 font-medium text-white"
          onclick="document.getElementById('targetPage<?= $row['student_id'] ?>').value='staff-view-student-main.php';
                   document.getElementById('studentForm<?= $row['student_id'] ?>').submit();">
          View Profile
      </button>           
      <button type="button" class="btn space-x-2 bg-slate-150 px-0 font-medium text-slate-800"
          onclick="document.getElementById('targetPage<?= $row['student_id'] ?>').value='staff-edit-student.php';
                   document.getElementById('studentForm<?= $row['student_id'] ?>').submit();">
          Edit Profile
      </button>
  </div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No students found.</p>";
}
?>
</div>

</div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>
