<?php
require_once "../core/db-connect91.php";


// Get student_id from session
$student_id = $_SESSION['student_id'] ?? 0;
$class_id = 0;

if ($student_id > 0) {
    // Step 1: fetch student_class and student_division of the student
    $sql = "SELECT student_class, student_division FROM students WHERE student_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $student_id);
    $stmt->execute();
    $stmt->bind_result($student_class, $student_division);
    $stmt->fetch();
    $stmt->close();

    if (!empty($student_class) && !empty($student_division)) {
        // Step 2: fetch class_id from classes table using class_name and division
        $sql2 = "SELECT class_id FROM classes WHERE class_name = ? AND division = ? LIMIT 1";
        $stmt2 = $conn->prepare($sql2);
        $stmt2->bind_param("ss", $student_class, $student_division);
        $stmt2->execute();
        $stmt2->bind_result($class_id);
        $stmt2->fetch();
        $stmt2->close();
    }
}

// Now you can use $class_id anywhere
$subject  = isset($_POST['subject']) ? mysqli_real_escape_string($conn, $_POST['subject']) : '';
$semester = isset($_POST['semester']) ? intval($_POST['semester']) : 0;

if ($class_id && $subject && $semester) {
    $sql = "SELECT syllabus_id, chapter, status 
            FROM syllabus 
            WHERE class_id=$class_id AND subject='$subject' AND semester=$semester
            ORDER BY syllabus_id ASC";
    $result = mysqli_query($conn, $sql);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn));
    }

    $rows = "";
    $count = 1;
while ($row = mysqli_fetch_assoc($result)) {
    $ch = htmlspecialchars($row['chapter']);
    $sid = (int)$row['syllabus_id'];
    $checked = $row['status'] == 1 ? "checked" : "";

    $rows .= "<tr>
        <td class='border px-2 py-1'>$count</td>
        <td class='border px-2 py-1'>$ch</td>
        <td class='border px-2 py-1 text-center'>
            <label class='inline-flex items-center space-x-2'>
     <span style='font-weight:bold; color:" . ($row['status'] == 1 ? "green" : "red") . ";'>" . 
     ($row['status'] == 1 ? "Complete" : "Incomplete") . 
     "</span>
            </label>
        </td>
    </tr>";
    $count++;
}

    if (empty($rows)) {
        $rows = "<tr><td colspan='3' class='text-center border py-2'>No chapters found</td></tr>";
    }

    echo $rows;
}
?>
