
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


  
  
<div class="col-span-12 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div
          class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light"
        >
          <i class="fa-solid fa-layer-group"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
Fee Structure
        </h4>
      </div>
    </div>

    <form method="POST" >
      <!-- Hidden Inputs -->

      <div class="space-y-4 p-4 sm:p-5">
        
        <!-- Months Multiple Select -->
<label class="block">
  <span>Class</span>
  <select
    name="class_id"
    required
    class="form-select mt-1.5 w-full rounded-lg border border-slate-300 bg-white px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
  >
    <option value="">Select Class</option>
    <?php


    $sql = "SELECT class_id, class_name, division FROM classes ORDER BY class_name, division";
    $result = mysqli_query($conn, $sql);

    while ($row = mysqli_fetch_assoc($result)) {
        // Show as "10 A", "10 B" etc.
        $display_name = $row['class_name'] . ' ' . strtoupper($row['division']);
        echo '<option value="' . $row['class_id'] . '">' . htmlspecialchars($display_name) . '</option>';
    }
    ?>
  </select>
</label>

        <!-- Batch Select -->
        <?php
        $sql = "SELECT batch_id, batch_name FROM batch WHERE status = 'Active' ORDER BY batch_id DESC";
        $result = mysqli_query($conn, $sql);
        ?>
        <label class="block">
          <span>Select Batch</span>
          <select
            name="batch"
            required
            class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
          >
            <option value="">Select Batch</option>
            <?php while ($row = mysqli_fetch_assoc($result)) : ?>
              <option value="<?= $row['batch_name'] ?>"><?= htmlspecialchars($row['batch_name']) ?></option>
            <?php endwhile; ?>
          </select>
        </label>

        <!-- Enable Custom Colors Checkbox -->
<label class="block">
  <span>Semester</span>
  <select name="semester" required             class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent">
    <option value="0">All</option>
    <option value="1">Semester 1</option>
    <option value="2">Semester 2</option>
  </select>
</label>

        <!-- Submit Button -->
        <div class="flex justify-center space-x-2 pt-4">
          <button
            type="submit"
            class="btn space-x-2 bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
          >
            <span>Submit</span>
          </button>
        </div>
      </div>
    </form>
  </div>
</div>

  
<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    include 'db_connect.php'; // Your DB connection

    $class_id = intval($_POST['class_id']);
    $batch = mysqli_real_escape_string($conn, $_POST['batch']);

    // Fetch fees for given class & batch
    $sql = "SELECT * FROM fee_structure 
            WHERE class_id = $class_id 
            AND batch = '$batch'
            ORDER BY semester, gender, fee_type";

    $fees = mysqli_query($conn, $sql);

    // Group fees by semester & gender
    $fee_data = [];
    while ($row = mysqli_fetch_assoc($fees)) {
        $sem = $row['semester'];
        $gender = strtolower($row['gender']);
        $fee_data[$sem][$gender][] = $row;
    }

    // Helper function to render table
    function renderFeeCard($title, $fees) {
        echo '<div class="card px-4 pb-4 sm:px-5">';
        echo '<div class="my-3 flex h-8 items-center justify-between">';
        echo "<h2 class='font-medium tracking-wide text-slate-700 dark:text-navy-100 lg:text-base'>$title</h2>";
        echo '</div>';
        echo '<div class="mt-5">';
        echo '<div class="is-scrollbar-hidden min-w-full overflow-x-auto">';
        echo '<table class="is-zebra w-full text-left">';
        echo '<thead>
                <tr>
                    <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800">#</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Fee Type</th>
                    <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Amount</th>
                </tr>
              </thead>';
        echo '<tbody>';
        $count = 1;
        $total_amount = 0;
        foreach ($fees as $fee) {
            echo '<tr>';
            echo "<td class='whitespace-nowrap rounded-l-lg px-4 py-3'>$count</td>";
            echo "<td class='whitespace-nowrap px-4 py-3'>{$fee['fee_type']}</td>";
            echo "<td class='whitespace-nowrap px-4 py-3'>{$fee['amount']}</td>";
            echo '</tr>';
            $total_amount += $fee['amount'];
            $count++;
        }
        // Total row
        echo "<tr>
                <td colspan='2' class='whitespace-nowrap rounded-l-lg px-4 py-3 font-semibold'>Total</td>
                <td class='whitespace-nowrap px-4 py-3 font-semibold'>$total_amount</td>
              </tr>";
        echo '</tbody></table></div></div></div><br>';
    }

    // Loop through semesters
    foreach ($fee_data as $semester => $gender_groups) {
        echo "<h2 class='text-xl font-bold mb-3'>Semester $semester</h2>";

        if (!empty($gender_groups['common'])) {
            renderFeeCard("Common Fees - Semester $semester", $gender_groups['common']);
        }
        if (!empty($gender_groups['male'])) {
            renderFeeCard("Male Fees - Semester $semester", $gender_groups['male']);
        }
        if (!empty($gender_groups['female'])) {
            renderFeeCard("Female Fees - Semester $semester", $gender_groups['female']);
        }
    }
}
?>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>/html>>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>