<div
  x-show="$store.breakpoints.isXs && $store.global.isSearchbarActive"
  x-transition:enter="easy-out transition-all"
  x-transition:enter-start="opacity-0 scale-105"
  x-transition:enter-end="opacity-100 scale-100"
  x-transition:leave="easy-in transition-all"
  x-transition:leave-start="opacity-100 scale-100"
  x-transition:leave-end="opacity-0 scale-95"
  class="fixed inset-0 z-[100] flex flex-col bg-white dark:bg-navy-700 sm:hidden"
>
  <div
    class="flex items-center space-x-2 bg-slate-100 px-3 pt-2 dark:bg-navy-800"
  >
    <button
      class="btn -ml-1.5 size-7 shrink-0 rounded-full p-0 text-slate-600 hover:bg-slate-300/20 active:bg-slate-300/25 dark:text-navy-100 dark:hover:bg-navy-300/20 dark:active:bg-navy-300/25"
      @click="$store.global.isSearchbarActive = false"
    >
      <svg
        xmlns="http://www.w3.org/2000/svg"
        class="size-5"
        fill="none"
        stroke-width="1.5"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M15 19l-7-7 7-7"
        />
      </svg>
    </button>
    <input
      x-effect="$store.global.isSearchbarActive && $nextTick(() => $el.focus() );"
      class="form-input h-8 w-full bg-transparent placeholder-slate-400 dark:placeholder-navy-300"
      type="text"
      placeholder="Search here..."
    />
  </div>
<div x-data="{activeTab:'Student'}">
  <!-- TAB BUTTONS -->
  <div
    class="is-scrollbar-hidden flex shrink-0 overflow-x-auto bg-slate-100 px-2 text-slate-600 dark:bg-navy-800 dark:text-navy-200"
  >
    <button
      @click="activeTab = 'Student'"
      :class="activeTab === 'Student' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >
Student
    </button>
    <button
      @click="activeTab = 'Staff'"
      :class="activeTab === 'Staff' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >
Staff
    </button>
    <button
      @click="activeTab = 'Accountant'"
      :class="activeTab === 'Accountant' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >
Accountant
    </button>
    <button
      @click="activeTab = 'Exam'"
      :class="activeTab === 'Exam' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >
Exam
    </button>
    <button
      @click="activeTab = 'Syllabus'"
      :class="activeTab === 'Syllabus' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >
Syllabus
    </button>
    <button
      @click="activeTab = 'Transportation'"
      :class="activeTab === 'Transportation' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >Transportation
    </button>
    
    <button
      @click="activeTab = 'Timetable'"
      :class="activeTab === 'Timetable' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >Time Table
    </button>
    <button
      @click="activeTab = 'Export'"
      :class="activeTab === 'Export' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
      class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
    >Export
    </button>
<button
  @click="activeTab = 'Class'"
  :class="activeTab === 'Class' ? 'border-primary dark:border-accent text-primary dark:text-accent-light' : 'border-transparent hover:text-slate-800 focus:text-slate-800 dark:hover:text-navy-100 dark:focus:text-navy-100'"
  class="btn shrink-0 rounded-none border-b-2 px-3.5 py-2.5"
>Class
</button>
  </div>

  <!-- TAB CONTENT -->
  <div class="p-4">
    

    
    
    <div x-show="activeTab === 'Student'">
    
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Add Student -->
  <a href="staff-add-student.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Add Student
    </p>
  </a>

  <!-- View Students -->
  <a href="staff-view-student.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M5.121 17.804A9.956 9.956 0 0112 15c2.21 0 4.21.72 5.879 1.929M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">View Students</p>
  </a>

  <!-- Edit Students -->
  <a href="staff-edit-student.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M11 5h2M12 7v10m9 2H3a2 2 0 01-2-2V7a2 2 0 012-2h6l2-2h4l2 2h6a2 2 0 012 2v10a2 2 0 01-2 2z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Edit Students</p>
  </a>

  <!-- Student Attendance -->
  <a href="staff-student-view-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M8 7V3m8 4V3M3 11h18M5 19h14a2 2 0 002-2V7H3v10a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Attendance</p>
  </a>

  <!-- Print Attendance -->
  <a href="staff-student-print-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-error text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M17 9V2H7v7M17 9H7v13h10V9z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Print</p>
  </a>

  <!-- Student Analysis -->
  <a href="staff-student-view-analysis.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-secondary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M11 19V6m4 13V10m4 9V4M7 19v-4"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Analysis</p>
  </a>

  <!-- Student Complaint -->
  <a href="staff-view-student-complaint.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 9v2m0 4h.01m-6.938 4h13.856L12 5.13 5.062 19z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Complaint</p>
  </a>

  <!-- Bright Student -->
  <a href="staff-bright-student.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Bright</p>
  </a>

  <!-- Leave Request -->
  <a href="staff-student-view-leave-request.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M8 7h8m-4-4v8m5 4H7a2 2 0 00-2 2v2h14v-2a2 2 0 00-2-2z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Leave</p>
  </a>

  <!-- Student Result -->
  <a href="staff-view-student-scorecard.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M9 17v-2a4 4 0 018 0v2M7 7h10M5 11h14"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Result</p>
  </a>

  <!-- Student Data Export -->
  <a href="staff-student-data-export.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-secondary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 4v16m8-8H4"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Export</p>
  </a>
</div>
    
    
    </div>
    <div x-show="activeTab === 'Staff'">



<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Add Staff -->
  <a href="staff-add-staff.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Add Staff</p>
  </a>

  <!-- View Staff -->
  <a href="staff-view-staff.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M17 20h5V4H2v16h5m10 0v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6h10z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">View Staff</p>
  </a>

  <!-- Staff Attendance -->
  <a href="staff-view-staff-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M8 7V3m8 4V3M3 11h18M5 19h14a2 2 0 002-2V7H3v10a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Attendance</p>
  </a>

  <!-- Print Attendance -->
  <a href="staff-staff-print-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-error text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M17 9V2H7v7M17 9H7v13h10V9z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Print</p>
  </a>

  <!-- Leave Request -->
  <a href="staff-view-staff-leave-request.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M8 7h8m-4-4v8m5 4H7a2 2 0 00-2 2v2h14v-2a2 2 0 00-2-2z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Leave</p>
  </a>

  <!-- Allot Class -->
  <a href="staff-teacher-allot-class.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-secondary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 20h9M3 20h9m0-8h9M3 12h9m0-8h9M3 4h9"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Allot Class</p>
  </a>

  <!-- Allot Subject -->
  <a href="staff-teacher-allot-subject.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 6v12m6-6H6"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Allot Subject</p>
  </a>

  <!-- Staff Complaints -->
  <a href="staff-view-staff-complaint.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 9v2m0 4h.01m-6.938 4h13.856L12 5.13 5.062 19z"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Complaints</p>
  </a>

  <!-- Data Export -->
  <a href="staff-staff-data-export.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 4v16m8-8H4"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Export</p>
  </a>
</div>


    </div>
    <div x-show="activeTab === 'Accountant'">
    
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Student Fee Payment -->
  <a href="staff-pay-student-fees.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 8c-1.5 0-2.5.5-2.5 1.5S10.5 11 12 11s2.5.5 2.5 1.5S13.5 14 12 14m0-10v2m0 12v2"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Fee Pay</p>
  </a>

  <!-- Fee Payment History -->
  <a href="staff-student-fee-payment-list.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M9 17v-6h13M5 7h14"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Fee History</p>
  </a>

  <!-- Paid / Unpaid Fees -->
  <a href="staff-student-fee-payment-data.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M5 13l4 4L19 7"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Paid/Unpaid</p>
  </a>

  <!-- Staff Salary Payment -->
  <a href="staff-pay-salary.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-error text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 8c-1.5 0-2.5.5-2.5 1.5S10.5 11 12 11s2.5.5 2.5 1.5S13.5 14 12 14m0-10v2m0 12v2"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Salary Pay</p>
  </a>

  <!-- Salary Payment History -->
  <a href="staff-pay-salary-history.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-secondary text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M3 7h18M9 3v4m6-4v4m-7 8h8"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Salary History</p>
  </a>

  <!-- Add Fee Structure -->
  <a href="staff-add-fee-structure.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 4v16m8-8H4"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Add Fees</p>
  </a>

  <!-- View Fee Structure -->
  <a href="staff-view-fee-structure.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M4 6h16M4 10h16M4 14h16M4 18h16"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">View Fees</p>
  </a>

  <!-- Send Fees Reminder -->
  <a href="staff-send-fee-reminder.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-error text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M15 17h5l-1.405-1.405M19 13V6a2 2 0 00-2-2H7a2 2 0 00-2 2v7a2 2 0 002 2h2"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Reminder</p>
  </a>

  <!-- Income & Expenditure -->
  <a href="staff-income-expenditure.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
          viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round"
            d="M12 8c-2.21 0-4 1.79-4 4m8 0c0-2.21-1.79-4-4-4m0 0V4m0 8v8"/>
        </svg>
      </div>
    </div>
    <p     class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">Accounts</p>
  </a>
</div>
    
    
    </div>
    <div x-show="activeTab === 'Exam'">
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
<!-- Schedule Exam -->
<a href="staff-schedule-exam.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-success text-white">
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10m-12 8h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Schedule Exam
  </p>
</a>

<!-- Edit Exam Schedule -->
<a href="staff-edit-exam-schedule.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-warning text-white">
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M11 5h10M11 9h7M11 13h10M4 7h.01M4 11h.01M4 15h.01"/>
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Edit Exam Schedule
  </p>
</a>

<!-- Add Exam Result -->
<a href="staff-add-exam-result.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-info text-white">
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4"/>
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Add Exam Result
  </p>
</a>

<!-- Edit Exam Result -->
<a href="staff-edit-exam-result.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-error text-white">
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M15.232 5.232l3.536 3.536M9 13l3 3L22 6M3 17h4v4H3z"/>
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Edit Exam Result
  </p>
</a>

<!-- View Exam Result -->
<a href="staff-view-exam-result.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-secondary text-white">
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
        <path stroke-linecap="round" stroke-linejoin="round" d="M2.458 12C3.732 7.943 7.523 5 12 5s8.268 2.943 9.542 7c-1.274 4.057-5.065 7-9.542 7s-8.268-2.943-9.542-7z"/>
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    View Exam Result
  </p>
</a>
    
</div>    
    </div>
    <div x-show="activeTab === 'Syllabus'">
    
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
    
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Add Syllabus -->
  <a href="staff-add-syllabus.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <!-- Book / Plus Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Add Syllabus
    </p>
  </a>

  <!-- Syllabus Status -->
  <a href="staff-syllabus-status.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <!-- Clipboard Check Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m-7 8h8a2 2 0 002-2V6a2 2 0-2-2H7a2 2 0-2 2v12a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Status
    </p>
  </a>
</div>

</div>   
    
    </div>
    <div x-show="activeTab === 'Transportation'">
    <div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
<!-- Track Vehicle -->

<a href="staff-track-bus.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-info text-white">
      <!-- Location/Map Pin Icon -->
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M12 11c1.657 0 3-1.343 3-3S13.657 5 12 5 9 6.343 9 8s1.343 3 3 3z" />
        <path stroke-linecap="round" stroke-linejoin="round" d="M19.5 8c0 7.5-7.5 13.5-7.5 13.5S4.5 15.5 4.5 8a7.5 7.5 0 1115 0z" />
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Track Bus
  </p>
</a>

<!-- Add Vehicle -->
<a href="staff-add-bus.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-success text-white">
      <!-- Bus Icon -->
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M4 16V7a2 2 0 012-2h12a2 2 0 012 2v9M4 16h16M4 16l-1 2m17-2l1 2M7 20h.01M17 20h.01" />
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
    Add Bus
  </p>
</a>

<!-- Allot Vehicle To Driver -->
<a href="staff-allot-driver.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-warning text-white">
      <!-- Steering Wheel Icon -->
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M12 2a10 10 0 100 20 10 10 0 000-20zm0 0v4m0 10v4m8-8h-4M6 12H2m13.657-5.657l-2.829 2.829M8.172 15.828l-2.829 2.829" />
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
   Allot Driver
  </p>
</a>

<!-- Allot Student To Vehicle -->
<a href="staff-allot-student-bus.php" class="w-14 text-center">
  <div class="avatar size-12">
    <div class="is-initial rounded-full bg-secondary text-white">
      <!-- Users Icon -->
      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
        <path stroke-linecap="round" stroke-linejoin="round" d="M17 20h5v-2a3 3 0 00-3-3h-4m-4 5v-2a3 3 0 013-3h2m-6 5H4v-2a3 3 0 013-3h4m-1-4a3 3 0 100-6 3 3 0 000 6zm7-3a3 3 0 11-6 0 3 3 0 016 0z" />
      </svg>
    </div>
  </div>
  <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
   Allot Students
  </p>
</a>
</div>
  
</div>

    
    
    <div x-show="activeTab === 'Timetable'">

<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Add Timetable -->
  <a href="staff-add-timetable.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <!-- Calendar Plus Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0-2-2H5a2 2 0-2 2v12a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Add Timetable
    </p>
  </a>

  <!-- View Timetable -->
  <a href="staff-view-timetable.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <!-- Calendar View Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M3 7h18M3 12h18M3 17h18M4 6h16a1 1 0 011 1v10a1 1 0 01-1 1H4a1 1 0 01-1-1V7a1 1 0 011-1z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      View Timetable
    </p>
  </a>
</div>
    </div>
    <div x-show="activeTab === 'Export'">
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Student Data -->
  <a href="staff-student-data-export.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <!-- User Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M5.121 17.804A5 5 0 0112 15a5 5 0 016.879 2.804M12 12a5 5 0 100-10 5 5 0 000 10z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Student Data
    </p>
  </a>

  <!-- Student Attendance -->
  <a href="staff-data-export-student-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <!-- Clipboard Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m-7 8h8a2 2 0 002-2V6a2 2 0-2-2H7a2 2 0-2 2v12a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Attendance
    </p>
  </a>

  <!-- Staff Data -->
  <a href="staff-data-export-staff-data.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <!-- User Group Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M17 20h5v-2a3 3 0 00-3-3h-4M7 20H2v-2a3 3 0 013-3h4M12 12a5 5 0 100-10 5 5 0 000 10z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Staff Data
    </p>
  </a>

  <!-- Staff Attendance -->
  <a href="staff-data-export-staff-attendance.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-info text-white">
        <!-- Clipboard Check Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 12l2 2 4-4m-7 8h8a2 2 0 002-2V6a2 2 0-2-2H7a2 2 0-2 2v12a2 2 0 002 2z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Staff Attendance
    </p>
  </a>

  <!-- Student Result -->
  <a href="staff-data-export-student-result.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-secondary text-white">
        <!-- Document Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 12h6m-6 4h6M4 6h16v12H4V6z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Student Result
    </p>
  </a>

  <!-- Fees Payments -->
  <a href="staff-data-export-fees-payment.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <!-- Currency / Cash Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 8c-4 0-8 1-8 4s4 4 8 4 8-1 8-4-4-4-8-4z"/>
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 12v4m0-8v2"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Fees
    </p>
  </a>

  <!-- Salary Payments -->
  <a href="staff-data-export-salary-payment.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-warning text-white">
        <!-- Wallet / Money Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-2"/>
          <path stroke-linecap="round" stroke-linejoin="round" d="M7 12h4"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Salary
    </p>
  </a>
</div>
    </div>
    <div x-show="activeTab === 'Class'">
<div class="is-scrollbar-hidden mt-3 flex space-x-4 overflow-x-auto px-3">
  <!-- Add Class -->
  <a href="staff-add-class.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-primary text-white">
        <!-- School / Class Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M3 7l9-4 9 4v10a2 2 0 01-2 2H5a2 2 0 01-2-2V7z"/>
          <path stroke-linecap="round" stroke-linejoin="round" d="M9 22V12h6v10"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Add Class
    </p>
  </a>

  <!-- Add Subject To Class -->
  <a href="staff-add-subject.php" class="w-14 text-center">
    <div class="avatar size-12">
      <div class="is-initial rounded-full bg-success text-white">
        <!-- Book / Subject Icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
          <path stroke-linecap="round" stroke-linejoin="round" d="M12 20h9M12 4h9M3 6h9v12H3V6z"/>
        </svg>
      </div>
    </div>
    <p class="mt-1.5 overflow-hidden text-ellipsis whitespace-nowrap text-xs text-slate-700 dark:text-navy-100">
      Add Subject
    </p>
  </a>
</div>
    </div>

  </div>
</div>

<!-- TAB CONTENT -->


  <div
    class="is-scrollbar-hidden overflow-y-auto overscroll-contain pb-2"
  >


    <div
      class="mt-3 flex items-center justify-between bg-slate-100 py-1.5 px-3 dark:bg-navy-800"
    >
      <p class="text-xs uppercase text-slate-400 dark:text-navy-300">
        Recent
      </p>

    </div>




    <div class="mt-1 font-inter font-medium">
<?php
if (!empty($_SESSION['page_history'])): ?>
    <ul>
        <?php foreach ($_SESSION['page_history'] as $page):
            // Get only the file name
            $fileName0 = basename($page); // e.g., staff-add-class.php

            // Remove .php extension
            $fileName = preg_replace('/\.php$/', '', $fileName0);

            // Replace hyphens with spaces
            $fileName = str_replace('-', ' ', $fileName);

            // Capitalize first letter of each word
            $fileName = ucwords($fileName);
        ?>
<a
  class="group flex items-center space-x-2 px-2.5 py-2 tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
  href="<?php echo htmlspecialchars($fileName0); ?>"
>
<svg
  xmlns="http://www.w3.org/2000/svg"
  class="size-4.5 text-slate-400 transition-colors group-hover:text-slate-500 group-focus:text-slate-500 dark:text-navy-300 dark:group-hover:text-navy-200 dark:group-focus:text-navy-200"
  fill="none"
  viewBox="0 0 24 24"
  stroke="currentColor"
  stroke-width="1.5"
>
  <path
    stroke-linecap="round"
    stroke-linejoin="round"
    d="M12 8v4l3 3m6-3a9 9 0 11-9-9"
  />
</svg>
  <span><?php echo htmlspecialchars($fileName); ?></span>
</a>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>
      



    </div>
  </div>
</div>