<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$host = "localhost";       // Database host
$user = "samruddh_sch";    // Database username
$pass = "Patel@2002";      // Database password
$dbname = "samruddh_sch";  // Your database name

// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

session_start();

$website = "https://samruddhichemicals.com/schbee/";

$school_name = "Xyz School";
$school_logo = "school.jpg";

$batch = "2025";

/*
//-----------------------------------------
// STEP 0: Ensure all students exist in student_analysis
//-----------------------------------------
$studentsQuery = $conn->query("
    SELECT student_id, student_gr_no, student_class AS class_id 
    FROM students
");

while($student = $studentsQuery->fetch_assoc()) {
    $studentId = $student['student_id'];
    $studentGrNo = $student['student_gr_no'];

    // Check if student exists in student_analysis
    $checkQuery = $conn->query("
        SELECT analysis_id FROM student_analysis 
        WHERE student_id = '$studentId' AND batch = '$batch'
    ");

    if($checkQuery->num_rows == 0) {
        // Insert new record for the student
        $conn->query("
            INSERT INTO student_analysis 
            (student_id, student_gr_no, student_school_rank, student_class_rank, 
             student_attendance, total_attendance, student_accuracy, 
             student_behavior, student_analysis, batch, analysis_date)
            VALUES
            ('$studentId', '$studentGrNo', NULL, NULL, 0, 0, 0, NULL, NULL, '$batch', CURDATE())
        ");
    }
}

echo "Step 0: All students ensured in student_analysis.<br>";

//-----------------------------------------
// STEP 1: Calculate and Update Student Accuracy
//-----------------------------------------

$studentsAnalysis = $conn->query("
    SELECT student_id, analysis_id 
    FROM student_analysis
    WHERE batch = '$batch'
");

while($row = $studentsAnalysis->fetch_assoc()) {
    $studentId = $row['student_id'];
    $analysisId = $row['analysis_id'];

    $marksQuery = $conn->query("
        SELECT 
            SUM(marks_obtained) AS total_marks,
            SUM(max_marks) AS total_max
        FROM exam_results
        WHERE student_id = '$studentId'
    ");

    $marks = $marksQuery->fetch_assoc();
    $totalMarks = $marks['total_marks'] ?? 0;
    $totalMaxMarks = $marks['total_max'] ?? 0;

    $studentAccuracy = 0;
    if ($totalMaxMarks > 0) {
        $studentAccuracy = round(($totalMarks / $totalMaxMarks) * 100, 2);
    }

    $conn->query("
        UPDATE student_analysis 
        SET student_accuracy = '$studentAccuracy'
        WHERE analysis_id = '$analysisId'
    ");
}

echo "Step 1: Student accuracy updated successfully!<br>";
*/
//-----------------------------------------
// STEP 2: Calculate and Update Class Rank
//-----------------------------------------

$classRankQuery = "
    SELECT 
        sa.analysis_id,
        sa.student_id,
        s.student_class,
        sa.student_accuracy
    FROM student_analysis sa
    INNER JOIN students s ON sa.student_id = s.student_id
    WHERE sa.batch = '$batch'
    ORDER BY s.student_class, sa.student_accuracy DESC
";

$classRanks = $conn->query($classRankQuery);

if (!$classRanks) {
    die("SQL Error in class rank query: " . $conn->error);
}

$currentClass = null;
$rank = 0;

while($row = $classRanks->fetch_assoc()) {
    $analysisId = $row['analysis_id'];
    $classId = $row['student_class'];

    // Reset rank when class changes
    if ($currentClass !== $classId) {
        $currentClass = $classId;
        $rank = 1;
    } else {
        $rank++;
    }

    $conn->query("
        UPDATE student_analysis 
        SET student_class_rank = '$rank'
        WHERE analysis_id = '$analysisId'
    ");
}

echo "Step 2: Class ranks updated successfully!<br>";

//-----------------------------------------
// STEP 3: Calculate and Update School Rank
//-----------------------------------------

$schoolRankQuery = "
    SELECT 
        sa.analysis_id,
        sa.student_accuracy
    FROM student_analysis sa
    WHERE sa.batch = '$batch'
    ORDER BY sa.student_accuracy DESC
";

$schoolRanks = $conn->query($schoolRankQuery);

if (!$schoolRanks) {
    die("SQL Error in school rank query: " . $conn->error);
}

$rank = 0;

while($row = $schoolRanks->fetch_assoc()) {
    $analysisId = $row['analysis_id'];
    $rank++;

    $conn->query("
        UPDATE student_analysis 
        SET student_school_rank = '$rank'
        WHERE analysis_id = '$analysisId'
    ");
}

echo "Step 3: School ranks updated successfully!<br><br>";
echo "✅ All updates completed!";


//-----------------------------------------
// SUBJECT-WISE ACCURACY
//-----------------------------------------

$studentsQuery = $conn->query("
    SELECT student_id, student_gr_no, student_class AS class_id 
    FROM students
");

while($student = $studentsQuery->fetch_assoc()) {
    $studentId = $student['student_id'];
    $studentGrNo = $student['student_gr_no'];
    $classId = $student['class_id'];

    $subjectMarksQuery = $conn->query("
        SELECT 
            esub.subject_name,
            SUM(er.marks_obtained) AS total_marks,
            SUM(er.max_marks) AS total_max
        FROM exam_results er
        INNER JOIN exam_subjects esub 
            ON esub.exam_subject_id = er.exam_subject_id
        INNER JOIN exam_schedule es
            ON es.exam_id = esub.exam_id
        WHERE er.student_id = '$studentId'
          AND es.class_id = '$classId'
        GROUP BY esub.subject_name
    ");

    while($row = $subjectMarksQuery->fetch_assoc()) {
        $subjectName = $row['subject_name'];
        $totalMarks = $row['total_marks'] ?? 0;
        $totalMax = $row['total_max'] ?? 0;

        $subjectAccuracy = 0;
        if ($totalMax > 0) {
            $subjectAccuracy = round(($totalMarks / $totalMax) * 100, 2);
        }

        $conn->query("
            INSERT INTO student_analysis_subject
            (student_id, student_gr_no, class_id, batch, subject_name, subject_accuracy)
            VALUES
            ('$studentId', '$studentGrNo', '$classId', '$batch', '$subjectName', '$subjectAccuracy')
            ON DUPLICATE KEY UPDATE subject_accuracy = '$subjectAccuracy'
        ");
    }
}

echo "Step 1: Student subject accuracy calculated and saved.<br>";


//-----------------------------------------
// SUBJECT-WISE CLASS RANK
//-----------------------------------------

$subjectListQuery = $conn->query("
    SELECT DISTINCT subject_name 
    FROM student_analysis_subject 
    WHERE batch = '$batch'
");

while($subject = $subjectListQuery->fetch_assoc()) {
    $subjectName = $subject['subject_name'];

    $rankQuery = $conn->query("
        SELECT analysis_subject_id, subject_accuracy, class_id
        FROM student_analysis_subject
        WHERE batch = '$batch' AND subject_name = '$subjectName'
        ORDER BY class_id, subject_accuracy DESC
    ");

    $currentClass = null;
    $rank = 0;

    while($row = $rankQuery->fetch_assoc()) {
        $analysisSubjectId = $row['analysis_subject_id'];
        $classId = $row['class_id'];

        if ($currentClass !== $classId) {
            $currentClass = $classId;
            $rank = 1;
        } else {
            $rank++;
        }

        $conn->query("
            UPDATE student_analysis_subject
            SET subject_class_rank = '$rank'
            WHERE analysis_subject_id = '$analysisSubjectId'
        ");
    }
}

echo "Step 2: Subject-wise class ranks updated successfully!";
?>