<?php
include '../core/db-connect91.php';
session_start();

$staff_id = $_SESSION['staff_id'] ?? 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $new_status = mysqli_real_escape_string($conn, $_POST['new_status']);

    if ($new_status !== 'select') {
        // Restrict update after 8:00 PM
        $currentTime = date("H:i:s");
        if ($currentTime > "20:00:00") {
            die("❌ Attendance can only be changed until 8:00 PM.");
        }

        // Restrict update only for today's records
        $todayDay   = date("j");   // Day without leading zero
        $todayMonth = date("n");   // Month without leading zero
        $todayYear  = date("Y");   // Year 4-digit

        $sql = "SELECT status, day, month, year 
                FROM student_attendance 
                WHERE attendance_id='$id' LIMIT 1";
        $res = mysqli_query($conn, $sql);

        if (!$res || mysqli_num_rows($res) == 0) {
            die("❌ Attendance record not found.");
        }

        $row = mysqli_fetch_assoc($res);
        $old_status = $row['status'];

        // Check if this record belongs to today
        if ($row['day'] != $todayDay || $row['month'] != $todayMonth || $row['year'] != $todayYear) {
            die("❌ You can only update today's attendance.");
        }

        // Prepare remark
        $remark = "Attendance changed from $old_status to $new_status by Staff ID $staff_id";

        // Update record
        $update = "
            UPDATE student_attendance 
            SET status     = '$new_status', 
                remarks    = '$remark', 
                updated_at = NOW(), 
                updated_by = '$staff_id'
            WHERE attendance_id = '$id'
        ";

        if (mysqli_query($conn, $update)) {
            echo "✅ Attendance updated successfully!";
        } else {
            echo "❌ Error updating: " . mysqli_error($conn);
        }
    } else {
        echo "⚠️ Please select attendance status!";
    }
}
?>