<?php


include '../core/db-connect91.php';

$class_id = intval($_GET['class_id'] ?? 0);
$batch    = $conn->real_escape_string($_GET['batch'] ?? '');
$gender   = strtolower($conn->real_escape_string($_GET['gender'] ?? ''));
$semester = intval($_GET['semester'] ?? 0);

// Base SQL
$sql = "SELECT fee_type, amount, semester, month, gender 
        FROM fee_structure
        WHERE class_id = $class_id
        AND batch = '$batch'
        AND (gender = 'common' OR gender = '$gender')";

// Semester filter
if ($semester > 0) {
    $sql .= " AND semester = $semester";
}

$sql .= " ORDER BY semester, month, fee_type";

$res = $conn->query($sql);

if ($res && $res->num_rows > 0) {
    $total_amount = 0;
    $row_number = 1;

    echo '<div class="card px-4 pb-4 sm:px-5">';
    echo '  <div class="my-3 flex h-8 items-center justify-between">
                <h2 class="font-medium tracking-wide text-slate-700 dark:text-navy-100 lg:text-base">
                    Fee Structure
                </h2>
            </div>';
    echo '  <div class="mt-5">
                <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
                    <table class="is-zebra w-full text-left">
                        <thead>
                            <tr>
                                <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">#</th>
                                <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Semester</th>
                                <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Fee Type</th>
                                <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Amount (₹)</th>
                            </tr>
                        </thead>
                        <tbody>';

    while ($row = $res->fetch_assoc()) {
        $total_amount += $row['amount'];

        echo '<tr>
                <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">'.$row_number++.'</td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">'.$row['semester'].'</td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">'.$row['fee_type'].'</td>
                <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">'.number_format($row['amount'], 2).'</td>
              </tr>';
    }

    // Total row
    echo '<tr class="font-bold bg-slate-100 dark:bg-navy-700">
            <td colspan="3" class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5 text-right">Total</td>
            <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">'.number_format($total_amount, 2).'</td>
          </tr>';

    echo '          </tbody>
                    </table>
                </div>
            </div>
        </div>';

    // ✅ store numeric value in session, not formatted
    $_SESSION['total_amount'] = $total_amount;








    $student_id = $_SESSION['student_id'] ?? 0;
    $batch = $_SESSION['selected_batch'] ?? '';

    // Calculate previously paid amount
    if ($semester == 0) {
        $sql_sum = "SELECT COALESCE(SUM(paid_amount), 0) AS total_paid 
                    FROM student_fees 
                    WHERE student_id = '$student_id' 
                      AND batch = '$batch' 
                      AND semester IN (1, 2)";
    } else {
        $sql_sum = "SELECT COALESCE(SUM(paid_amount), 0) AS total_paid 
                    FROM student_fees 
                    WHERE student_id = '$student_id' 
                      AND batch = '$batch' 
                      AND semester = '$semester'";
    }

    $result_sum = mysqli_query($conn, $sql_sum);
    $row_sum = mysqli_fetch_assoc($result_sum);
    $paid_amount = $row_sum['total_paid'];

    // ✅ store numeric value
    $_SESSION['paid_amount'] = $paid_amount;



// Calculate payable amount





// Prepare data
$total_amount  = $_SESSION['total_amount'] ?? 0;
$paid_amount   = $_SESSION['paid_amount'] ?? 0;
$payable_amount = $total_amount - $paid_amount;
$_SESSION['payable_amount'] = $payable_amount;

// Output table
echo '
<div class="card mt-4">
    <div class="p-2 text-lg font-bold">Payment Summary</div>
    <div class="px-4 pb-5 sm:px-1 w-full">
        <table class="table-auto w-full border border-slate-300 text-lg font-bold">
            <tbody>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Total Amount (₹)</td>
                    <td class="px-3 py-2 text-right">'.number_format($total_amount, 2).'</td>
                </tr>
                <tr class="border-b border-slate-300">
                    <td class="px-3 py-2">Paid Amount (₹)</td>
                    <td class="px-3 py-2 text-right">'.number_format($paid_amount, 2).'</td>
                </tr>
                <tr>
                    <td class="px-3 py-2">Amount To Pay (₹)</td>
                    <td class="px-3 py-2 text-right">'.number_format($payable_amount, 2).'</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>';


if ($semester === 0) {
    echo '<div class="card mt-4">
<div class="p-2 text-right"></div>
<div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
    <label class="relative flex">
        <span class="font-bold text-lg">Amount To Pay (₹)</span>   
        <input 
            name="payable_amount"
            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 
                   placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary 
                   dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent 
                   font-bold text-lg"
            disabled
            type="text"
            value="'.number_format($_SESSION['payable_amount'], 2, ".", "").'"
        />
    </label>
</div>
</div>';
} else {
    echo '<div class="card mt-4">
<div class="p-2 text-right"></div>
<div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
    <label class="relative flex">
        <span class="font-bold text-lg">Amount To Pay (₹)</span>   
        <input 
            name="payable_amount"
            class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 
                   placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary 
                   dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent 
                   font-bold text-lg"
            type="text"
            value="'.number_format($_SESSION['payable_amount'], 2, ".", "").'"
        />
    </label>
</div>
</div>';
}



} else {
    echo "<p>No fee structure found for this selection.</p>";
}
?> 