
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">








<?php
// fee_reminder.php
// Requirements:
// - $conn: existing mysqli connection (procedural)
// - session/admin auth already handled elsewhere

// Escape helper
function e($s){ return htmlspecialchars($s ?? '', ENT_QUOTES); }

// Receive filter inputs
$class     = $_POST['class']     ?? '';
$gr_no     = $_POST['gr_no']     ?? '';
$name      = $_POST['name']      ?? '';
$batch     = $_POST['batch']     ?? '';
$status    = $_POST['status']    ?? 'all'; // all/unpaid/partially_paid/paid

// If this POST contains reminder send action:
if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'send_reminders') {
    $selected = $_POST['selected_students'] ?? [];

    if(!is_array($selected) || count($selected) === 0) {
        $flash = "No students selected.";
    } else {
        $insert_stmt = $conn->prepare("INSERT INTO fee_reminders (student_id, student_gr_no, batch, sent_via, message) VALUES (?, ?, ?, ?, ?)");
        if(!$insert_stmt) {
            $flash = "DB prepare error: " . $conn->error;
        } else {
            $sent_count = 0;
            foreach($selected as $sid) {
                $sid = (int)$sid;
                // fetch student contact & latest fee for batch (if any)
                $sres = $conn->prepare("SELECT student_gr_no, student_name, student_surname, student_phonenumber, student_email, student_class, student_division FROM students WHERE student_id = ?");
                $sres->bind_param("i", $sid);
                $sres->execute();
                $sresData = $sres->get_result()->fetch_assoc();
                $sres->close();

                if(!$sresData) continue;

                // latest fee for this student and selected batch (if $batch specified), else latest overall
                if($batch !== '') {
                    $fstmt = $conn->prepare("SELECT total_fee, paid_amount, balance_amount, payment_status FROM student_fees WHERE student_id = ? AND batch = ? ORDER BY timestamp DESC LIMIT 1");
                    $fstmt->bind_param("is", $sid, $batch);
                } else {
                    $fstmt = $conn->prepare("SELECT total_fee, paid_amount, balance_amount, payment_status FROM student_fees WHERE student_id = ? ORDER BY timestamp DESC LIMIT 1");
                    $fstmt->bind_param("i", $sid);
                }
                $fstmt->execute();
                $feeData = $fstmt->get_result()->fetch_assoc();
                $fstmt->close();

                // Compose message if blank

                    $bal = $feeData ? number_format($feeData['balance_amount'],2) : '0.00';
                    $status_cur = $feeData ? $feeData['payment_status'] : 'unpaid';
                    $message = "Dear {$sresData['student_name']}, your fee for batch ".($batch?:'N/A')." is ₹{$bal}. Payment status: {$status_cur}. Please pay at earliest.";


                // Try to send email (if exists) - example via PHP mail()
                $sent_via = 'none';
                if(!empty($sresData['student_email']) && filter_var($sresData['student_email'], FILTER_VALIDATE_EMAIL)) {
                    $to = $sresData['student_email'];
                    $sub = "Fee Payment Reminder";
                    $headers = "From: admin@yourschool.com\r\n";
                    $headers .= "Content-type: text/plain; charset=utf-8\r\n";
                    @mail($to, $sub, $message, $headers); // @ to suppress warnings — replace with robust mailer in production
                    $sent_via = 'email';
                }

                // Example for SMS (commented). Replace with your SMS API provider
                /*
                if(!empty($sresData['student_phonenumber'])) {
                    $mobile = preg_replace('/\D+/', '', $sresData['student_phonenumber']);
                    // Example cURL to send SMS (pseudo)
                    $api_url = "https://sms-gateway.example/send";
                    $payload = http_build_query([
                        'api_key' => 'YOUR_API_KEY',
                        'to' => $mobile,
                        'message' => $message
                    ]);
                    $ch = curl_init($api_url);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                    $resp = curl_exec($ch);
                    curl_close($ch);
                    $sent_via = ($sent_via === 'email') ? 'both' : 'sms';
                }
                */

                // record reminder
                $gno = $sresData['student_gr_no'] ?? '';
                $bval = $batch ?: null;
                $insert_stmt->bind_param("issss", $sid, $gno, $bval, $sent_via, $message);
                $insert_stmt->execute();
                $sent_count++;
            }
            $insert_stmt->close();
            $flash = "Processed {$sent_count} reminders.";
        }
    }
}

// Fetch classes for select box (distinct class + division)
$classResult = $conn->query("SELECT DISTINCT class_name, division FROM classes ORDER BY class_name ASC, division ASC");

// Fetch batches
$batchRes = $conn->query("SELECT batch_name FROM batch WHERE status='Active' ORDER BY batch_id DESC");

// If filter form submitted (or default show none) -- we'll show results when submit filter (submit name 'filter_submit')
$students = [];
if($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['action'])) {
    // Build base student query with optional filters (class stored as "Class|Division")
    $params = [];
    $types = '';
    $where = " WHERE 1=1 ";

    if($class !== '') {
        // split class|division
        $parts = explode('|', $class);
        $cname = $parts[0];
        $cdiv  = $parts[1] ?? '';
        $where .= " AND student_class = ? AND student_division = ?";
        $types .= "ss";
        $params[] = $cname;
        $params[] = $cdiv;
    }

    if($gr_no !== '') {
        $where .= " AND student_gr_no LIKE ?";
        $types .= "s";
        $params[] = "%$gr_no%";
    }
    if($name !== '') {
        $where .= " AND (student_name LIKE ? OR student_surname LIKE ?)";
        $types .= "ss";
        $params[] = "%$name%";
        $params[] = "%$name%";
    }
    if($batch !== '') {
        // we'll later fetch fee for this batch only; students filter not restricted by batch
    }

    // fetch matching students
    $sql = "SELECT student_id, student_gr_no, student_name, student_surname, student_class, student_division, student_phonenumber, student_email, student_image FROM students " . $where . " ORDER BY student_name ASC";
    $stmt = $conn->prepare($sql);
    if($types !== '') {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $res = $stmt->get_result();
    while($r = $res->fetch_assoc()) {
        // For each student fetch latest fee (for batch if provided)
        if($batch !== '') {
            $fstmt = $conn->prepare("SELECT total_fee, paid_amount, balance_amount, payment_status, month FROM student_fees WHERE student_id = ? AND batch = ? ORDER BY timestamp DESC LIMIT 1");
            $fstmt->bind_param("is", $r['student_id'], $batch);
        } else {
            $fstmt = $conn->prepare("SELECT total_fee, paid_amount, balance_amount, payment_status, month, batch FROM student_fees WHERE student_id = ? ORDER BY timestamp DESC LIMIT 1");
            $fstmt->bind_param("i", $r['student_id']);
        }
        $fstmt->execute();
        $fee = $fstmt->get_result()->fetch_assoc();
        $fstmt->close();

        // apply payment status filter if required
        if($status !== 'all') {
            if(!$fee) {
                // treat no fee as unpaid
                $cur_status = 'unpaid';
            } else {
                $cur_status = $fee['payment_status'];
            }
            if($status !== $cur_status) {
                continue; // skip this student
            }
        }

        $r['fee'] = $fee;
        $students[] = $r;
    }
    $stmt->close();
}

?>



<div style="max-width:1200px;margin:20px auto">


  <?php if(!empty($flash)): ?>
    <div style="padding:8px;border:1px solid #cfc;color:#064;"><?php echo e($flash); ?></div>
  <?php endif; ?>

  <form method="POST" class="card" style="padding:12px;margin-bottom:16px;">
<div class="grid grid-cols-1 gap-4 md:grid-cols-2 lg:grid-cols-3">
  <!-- Class -->
  <label class="block">
    <span class="font-medium text-slate-600 dark:text-navy-100">Class</span>
    <select name="class"
      class="mt-1.5 w-full"
      x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
    >
      <option value="">All Classes</option>
      <?php 
      while($cRow = $classResult->fetch_assoc()) {
          $classDisplay = $cRow['class_name']." ".$cRow['division']; 
          $classValue = $cRow['class_name']."|".$cRow['division']; 
          $selected = ($class == $classValue) ? "selected" : "";
          echo "<option value='$classValue' $selected>$classDisplay</option>";
      }
      ?>
    </select>
  </label>

  <!-- GR No -->
  <label class="relative flex">
    <input name="gr_no"
      class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
      placeholder="Search By GR No"
      type="text"
      value="<?= htmlspecialchars($gr_no) ?>"
    />
    <span
      class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
    >
      <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="currentColor" viewBox="0 0 24 24"><path d="M3.316 13.781l.73-.171-.73.171zm0-5.457l.73.171-.73-.171zm15.473 0l.73-.171-.73.171zm0 5.457l.73.171-.73-.171zm-5.008 5.008l-.171-.73.171.73zm-5.457 0l-.171.73.171-.73zm0-15.473l-.171-.73.171.73zm5.457 0l.171-.73-.171.73zM20.47 21.53a.75.75 0 101.06-1.06l-1.06 1.06zM4.046 13.61a11.198 11.198 0 010-5.115l-1.46-.342a12.698 12.698 0 000 5.8l1.46-.343zm14.013-5.115a11.196 11.196 0 010 5.115l1.46.342a12.698 12.698 0 000-5.8l-1.46.343zm-4.45 9.564a11.196 11.196 0 01-5.114 0l-.342 1.46c1.907.448 3.892.448 5.8 0l-.343-1.46zM8.496 4.046a11.198 11.198 0 015.115 0l.342-1.46a12.698 12.698 0 00-5.8 0l.343 1.46zm0 14.013a5.97 5.97 0 01-4.45-4.45l-1.46.343a7.47 7.47 0 005.568 5.568l.342-1.46zm5.457 1.46a7.47 7.47 0 005.568-5.567l-1.46-.342a5.97 5.97 0 01-4.45 4.45l.342 1.46zM13.61 4.046a5.97 5.97 0 014.45 4.45l1.46-.343a7.47 7.47 0 00-5.568-5.567l-.342 1.46zm-5.457-1.46a7.47 7.47 0 00-5.567 5.567l1.46.342a5.97 5.97 0 014.45-4.45l-.343-1.46zm8.652 15.28l3.665 3.664 1.06-1.06-3.665-3.665-1.06 1.06z"/></svg>
    </span>
  </label>

  <!-- Name -->
  <label class="relative flex">
    <input name="name"
      class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
      placeholder="Search By Name"
      type="text"
      value="<?= htmlspecialchars($name) ?>"
    />
    <span
      class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
    >
      <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="currentColor" viewBox="0 0 24 24"><path d="M3.316 13.781l.73-.171-.73.171zm0-5.457l.73.171-.73-.171zm15.473 0l.73-.171-.73.171zm0 5.457l.73.171-.73-.171zm-5.008 5.008l-.171-.73.171.73zm-5.457 0l-.171.73.171-.73zm0-15.473l-.171-.73.171.73zm5.457 0l.171-.73-.171.73zM20.47 21.53a.75.75 0 101.06-1.06l-1.06 1.06zM4.046 13.61a11.198 11.198 0 010-5.115l-1.46-.342a12.698 12.698 0 000 5.8l1.46-.343zm14.013-5.115a11.196 11.196 0 010 5.115l1.46.342a12.698 12.698 0 000-5.8l-1.46.343zm-4.45 9.564a11.196 11.196 0 01-5.114 0l-.342 1.46c1.907.448 3.892.448 5.8 0l-.343-1.46zM8.496 4.046a11.198 11.198 0 015.115 0l.342-1.46a12.698 12.698 0 00-5.8 0l.343 1.46zm0 14.013a5.97 5.97 0 01-4.45-4.45l-1.46.343a7.47 7.47 0 005.568 5.568l.342-1.46zm5.457 1.46a7.47 7.47 0 005.568-5.567l-1.46-.342a5.97 5.97 0 01-4.45 4.45l.342 1.46zM13.61 4.046a5.97 5.97 0 014.45 4.45l1.46-.343a7.47 7.47 0 00-5.568-5.567l-.342 1.46zm-5.457-1.46a7.47 7.47 0 00-5.567 5.567l1.46.342a5.97 5.97 0 014.45-4.45l-.343-1.46zm8.652 15.28l3.665 3.664 1.06-1.06-3.665-3.665-1.06 1.06z"/></svg>
    </span>
  </label>

  <!-- Batch -->
  <label class="block">
    <span class="font-medium text-slate-600 dark:text-navy-100">Batch</span>
    <select name="batch"
      class="mt-1.5 w-full"
      x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
   required >
      <option value="">All Batches</option>
      <?php while($b = $batchRes->fetch_assoc()): ?>
        <option value="<?= htmlspecialchars($b['batch_name']) ?>" <?= $batch == $b['batch_name'] ? 'selected' : '' ?>>
          <?= htmlspecialchars($b['batch_name']) ?>
        </option>
      <?php endwhile; ?>
    </select>
  </label>

  <!-- Payment Status -->
  <label class="block">
    <span class="font-medium text-slate-600 dark:text-navy-100">Payment Status</span>
    <select name="status"
      class="mt-1.5 w-full"
      x-init="$el._x_tom = new Tom($el,{create: false})"
    >
      <option value="all" <?= $status==='all' ? 'selected' : '' ?>>All</option>
      <option value="unpaid" <?= $status==='unpaid' ? 'selected' : '' ?>>Unpaid</option>
      <option value="partially_paid" <?= $status==='partially_paid' ? 'selected' : '' ?>>Partially Paid</option>
      <option value="paid" <?= $status==='paid' ? 'selected' : '' ?>>Paid</option>
    </select>
  </label>
</div>

<!-- Submit button -->
<div class="mt-4">
  <button type="submit"
    class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
    Load Data
  </button>
</div>
  </form>

  <!-- Results / selection form -->
  <form method="POST" id="reminderForm">
    <input type="hidden" name="action" value="send_reminders">


    <div class="card" style="padding:8px;">
      <div style="overflow:auto;">
<table class="is-hoverable w-full text-left">
  <thead>
    <tr>
      <th
        class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100"
      >
        <input type="checkbox" id="select_all" />
      </th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">#</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Avatar</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Name</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Class / Div</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">GR No</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Total</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Paid</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Balance</th>
      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100">Status</th>
      <th
        class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100"
      >
        Phone / Email
      </th>
    </tr>
  </thead>
  <tbody>
    <?php if(count($students) === 0): ?>
      <tr>
        <td colspan="11" class="px-4 py-3 text-center text-slate-500 dark:text-navy-200">No records found. Use filters above and click Load.</td>
      </tr>
    <?php else:
      $i=1;
      foreach($students as $st): 
        $fee = $st['fee'];
        $total = $fee ? number_format($fee['total_fee'],2) : '-';
        $paid  = $fee ? number_format($fee['paid_amount'],2) : '-';
        $bal   = $fee ? number_format($fee['balance_amount'],2) : '-';
        $pstatus = $fee ? $fee['payment_status'] : 'unpaid';
    ?>
      <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
        <td class="whitespace-nowrap px-4 py-3">
          <input type="checkbox" class="selc" name="selected_students[]" value="<?php echo (int)$st['student_id']; ?>" />
        </td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo $i++; ?></td>
        <td class="whitespace-nowrap px-4 py-3">
          <div class="avatar flex size-10">
            <?php if(!empty($st['student_image'])): ?>
              <img class="mask is-squircle" src="<?php echo e($st['student_image']); ?>" alt="avatar" />
            <?php else: ?>
              <div class="size-10 rounded bg-slate-300 dark:bg-navy-600"></div>
            <?php endif; ?>
          </div>
        </td>
        <td class="whitespace-nowrap px-4 py-3 font-medium text-slate-700 dark:text-navy-100">
          <?php echo e($st['student_name'].' '.$st['student_surname']); ?>
        </td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo e($st['student_class'].' / '.$st['student_division']); ?></td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo e($st['student_gr_no']); ?></td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo $total; ?></td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo $paid; ?></td>
        <td class="whitespace-nowrap px-4 py-3"><?php echo $bal; ?></td>
        <td class="whitespace-nowrap px-4 py-3">
          <span class="badge rounded-full px-3 py-1 text-xs font-medium 
            <?php echo $pstatus === 'paid' ? 'bg-green-200 text-green-700 dark:bg-green-600 dark:text-green-100' : 'bg-red-200 text-red-700 dark:bg-red-600 dark:text-red-100'; ?>">
            <?php echo e(ucfirst(str_replace('_',' ',$pstatus))); ?>
          </span>
        </td>
        <td class="whitespace-nowrap px-4 py-3">
          <div class="text-slate-600 dark:text-navy-200"><?php echo e($st['student_phonenumber']); ?></div>
          <div class="text-slate-500 text-sm dark:text-navy-300"><?php echo e($st['student_email']); ?></div>
        </td>
      </tr>
    <?php endforeach; endif; ?>
  </tbody>
</table>
      </div>

      <div style="margin-top:12px; display:flex; gap:8px; align-items:center;">
        
        <div class="mt-4">
        <button type="submit"
        class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Send Reminder
        </button>
        </div>
        <div class="mt-4">
        <button id="selectNone" type="button"
        class="btn bg-error font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Deselct All
        </button>
        </div>


        <div style="margin-left:auto;" id="selectedCount">Selected: 0</div>
      </div>
    </div>
  </form>
</div>

<script>
  const selectAll = document.getElementById('select_all');
  const checkboxes = document.querySelectorAll('.selc');
  const selectedCountEl = document.getElementById('selectedCount');
  const selectNoneBtn = document.getElementById('selectNone');

  function updateCount(){
    const n = document.querySelectorAll('.selc:checked').length;
    selectedCountEl.textContent = 'Selected: ' + n;
    selectAll.checked = (n > 0 && n === document.querySelectorAll('.selc').length);
  }

  selectAll && selectAll.addEventListener('change', function(){
    document.querySelectorAll('.selc').forEach(ch => ch.checked = this.checked);
    updateCount();
  });

  document.querySelectorAll('.selc').forEach(ch => ch.addEventListener('change', updateCount));

  selectNoneBtn && selectNoneBtn.addEventListener('click', function(){
    document.querySelectorAll('.selc').forEach(ch => ch.checked = false);
    updateCount();
  });

  // init
  updateCount();
</script>









  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>  