
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">


<?php
$class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
$examId =  (int)$_SESSION['exam_id'];
$sql = "SELECT class_name, division FROM classes WHERE class_id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $class_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($row = mysqli_fetch_assoc($result)) {




$class = htmlspecialchars($row['class_name']);
$division = htmlspecialchars($row['division']);
} 
?>

<?php
// Fetch students
$studentsSql = "
  SELECT student_id, student_image,
         CONCAT_WS(' ', student_surname, student_name, student_fathername) AS fullname,
         student_gr_no
  FROM   students
  WHERE  student_class   = '$class'
    AND  student_division = '$division'
    AND  student_status   = 'Active'
";
$studentsResult = mysqli_query($conn, $studentsSql);

// Fetch grade ranges
$gradeRanges = [];
$gradeQuery  = "SELECT grade_name, min_percentage, max_percentage FROM exam_grades";
$gradeResult = mysqli_query($conn, $gradeQuery);
while ($g = mysqli_fetch_assoc($gradeResult)) {
    $gradeRanges[] = $g;
}

$sr   = 1;
$rows = [];

while ($stu = mysqli_fetch_assoc($studentsResult)) {

    // Subject-wise marks for the chosen exam
    $marksSql = "
      SELECT marks_obtained, max_marks, status
      FROM   exam_results
      WHERE  student_id = '".$stu['student_id']."'
        AND  exam_id    = '".$examId."'
    ";
    $marksResult = mysqli_query($conn, $marksSql);

    $results = [];
    while ($row = mysqli_fetch_assoc($marksResult)) {
        $results[] = $row;
    }

    if (!$results) continue;   // no entries yet → skip

    // Totals & percentage
    $totMax = 0;
    $totObt = 0;
    foreach ($results as $res) {
        $totMax += $res['max_marks'];
        $totObt += $res['marks_obtained'];
    }
    $percent = $totMax ? ($totObt / $totMax) * 100 : 0;

    // Overall status: if any subject marked ‘fail’, student = fail
    $overallStatus = 'pass';
    foreach ($results as $res) {
        if (strtolower($res['status']) == 'fail') {
            $overallStatus = 'fail';
            break;
        }
    }

    // Map percentage → grade
    $grade = 'N/A';
    foreach ($gradeRanges as $g) {
        if ($percent >= $g['min_percentage'] && $percent <= $g['max_percentage']) {
            $grade = $g['grade_name'];
            break;
        }
    }

    // Push row
    $rows[] = [
        'sr'       => $sr++,
        'student_id' => $stu['student_id'],        
        'fullname' => $stu['fullname'],
        'image' => $stu['student_image'],      
        'gr'       => $stu['student_gr_no'],
        'totals'   => sprintf('%.2f / %d', $totObt, $totMax),
        'percent'  => number_format($percent, 2),
        'status'   => $overallStatus,
        'grade'    => $grade
    ];
}
?>

<?php
// Render table
/*echo '<table class="table table-bordered">';
echo '<thead>
        <tr>
          <th>Sr No</th>
          <th>Action</th>
          <th>Student Name</th>
          <th>GR No</th>
          <th>Obtained / Total</th>
          <th>%</th>
          <th>Status</th>
          <th>Grade</th>
        </tr>
      </thead><tbody>';

foreach ($rows as $r) {
    echo '<tr>
            <td>'.$r['sr'].'</td>
            <td><button class="btn btn-info btn-sm view" data-id="'.$r['sr'].'">View</button></td>
            <td>'.$r['fullname'].'</td>
            <td>'.$r['gr'].'</td>
            <td>'.$r['totals'].'</td>
            <td>'.$r['percent'].'</td>
            <td>'.ucfirst($r['status']).'</td>
            <td>'.$r['grade'].'</td>
          </tr>';
}
echo '</tbody></table>';*/
?>



<div
  class="is-scrollbar-hidden min-w-full overflow-x-auto"
  x-data="pages.tables.initExample1"
>
  <table class="is-hoverable w-full text-left">
    <thead>
      <tr>
        <th
          class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          #
        </th>
        <!-- Table Header -->
        <th
        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
        dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
        Action
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          Avatar
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          Student Name
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          GR No
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          Obtained / Total
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          %
        </th>
        <th
          class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          Status
        </th>
        <th
          class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 
                 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          Grade
        </th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
      <tr class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
        <!-- Sr No -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= $r['sr'] ?>
        </td>
<!-- Table Data -->
<td class="whitespace-nowrap px-4 py-3 sm:px-5">
  <a 
    href="staff-view-student-scorecard-main.php?exam_id=<?= $examId ?>&student_id=<?= $r['student_id'] ?>" 
    class="btn bg-primary text-white px-3 py-1 rounded-lg"
  >
    View Full Result
  </a>
</td>
        <!-- Avatar -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <div class="avatar flex size-10">
            <img
              class="mask is-squircle"
              src="<?= htmlspecialchars($r['student_image']) ?>"

              alt="avatar"
            />
          </div>
        </td>
<!--              src="https://ui-avatars.com/api/?name=<?= urlencode($r['fullname']) ?>&background=random"-->
        <!-- Student Name -->
        <td
          class="whitespace-nowrap px-3 py-3 font-medium text-slate-700 dark:text-navy-100 lg:px-5"
        >
          <?= htmlspecialchars($r['fullname']) ?>
        </td>

        <!-- GR No -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= htmlspecialchars($r['gr']) ?>
        </td>

        <!-- Obtained / Total -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= $r['totals'] ?>
        </td>

        <!-- Percentage -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= $r['percent'] ?>%
        </td>

<!-- Status -->
<td class="whitespace-nowrap px-4 py-3 sm:px-5">
  <div
    class="badge rounded-full px-3 py-1 text-white"
    style="background-color: <?= ($r['status'] == 'pass') ? '#16a34a' : '#dc2626' ?>;"
  >
    <?= ucfirst($r['status']) ?>
  </div>
</td>

        <!-- Grade -->
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <div class="badge rounded-full bg-slate-200 dark:bg-navy-700 px-3 py-1">
            <?= $r['grade'] ?>
          </div>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>



  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>