<?php
require('../../library/tcpdf/tcpdf.php');
require_once "../core/db-connect91.php";

// POST data
$staffid    = $_POST['staffid'];   // single staff ID
$months     = $_POST['months'];    // array of month numbers
$postbatch  = $_POST['batch'];

$presentc   = $_POST['presentc'];  // green
$absentc    = $_POST['absentc'];   // red
$holidayc   = $_POST['holidayc'];  // grey
$halfdayc   = $_POST['halfdayc'];  // orange
$colored    = isset($_POST['colored']) ? true : false;

$academicMonths = [
    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
    5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
    9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
];

// 🔹 Fetch staff details
$staffInfo = [];
$query = "SELECT * FROM staff WHERE staff_id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $staffid);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $staffInfo = $row;
}

// 🔹 Fetch attendance data
$attendanceData = [];
foreach ($months as $month) {
    $query = "SELECT day, status
              FROM staff_attendance
              WHERE staff_id = ? AND month = ? AND batch = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "iis", $staffid, $month, $postbatch);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    while ($row = mysqli_fetch_assoc($result)) {
        $attendanceData[$month][$row['day']] = $row['status'];
    }
}

// 🔹 Initialize PDF
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('School Evolution');
$pdf->SetTitle('Staff Attendance Report');
$pdf->SetHeaderData('', 0, 'Staff Attendance Report', 'Generated by School Evolution');
$pdf->setHeaderFont(['helvetica', '', 10]);
$pdf->setFooterFont(['helvetica', '', 8]);
$pdf->AddPage();

// 🔹 Main title
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'Attendance Report - Staff', 0, 1, 'C');
$pdf->Ln(5);

// 🔹 Staff Information
$pdf->SetFont('helvetica', '', 11);
$staffHTML = '<h3>Staff Information</h3>
<table border="1" cellpadding="5">
<tr><td><b>Name</b></td><td>' . htmlspecialchars($staffInfo['staff_surname'] . ' ' . $staffInfo['staff_name'] . ' ' . $staffInfo['staff_fathername']) . '</td></tr>
<tr><td><b>Username</b></td><td>' . htmlspecialchars($staffInfo['staff_username']) . '</td></tr>
<tr><td><b>Role</b></td><td>' . htmlspecialchars($staffInfo['staff_role']) . '</td></tr>
<tr><td><b>Gender</b></td><td>' . htmlspecialchars($staffInfo['staff_gender']) . '</td></tr>
<tr><td><b>Birthdate</b></td><td>' . htmlspecialchars($staffInfo['staff_birthdate']) . '</td></tr>
<tr><td><b>Phone</b></td><td>' . htmlspecialchars($staffInfo['staff_phonenumber']) . '</td></tr>
<tr><td><b>Email</b></td><td>' . htmlspecialchars($staffInfo['staff_email']) . '</td></tr>
<tr><td><b>Address</b></td><td>' . htmlspecialchars($staffInfo['staff_address']) . '</td></tr>
</table><br>';
$pdf->writeHTML($staffHTML, true, false, true, false, '');

// 🔹 Attendance tables
foreach ($months as $month) {
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, $academicMonths[$month] . ' ' . date('Y'), 0, 1, 'C');
    $pdf->Ln(3);

    $html = '<table border="1" cellspacing="0" cellpadding="5">';
    $html .= '<tr><th>Day</th><th>Status</th></tr>';

    for ($day = 1; $day <= 31; $day++) {
        $status = $attendanceData[$month][$day] ?? 'leave'; // default: leave
        if ($status == 'present') {
            $cellContent = 'P'; $color = $presentc;
        } elseif ($status == 'absent') {
            $cellContent = 'A'; $color = $absentc;
        } elseif ($status == 'half_day') {
            $cellContent = 'HD'; $color = $halfdayc;
        } elseif ($status == 'leave') {
            $cellContent = 'L'; $color = $holidayc;
        } else {
            $cellContent = '-'; $color = '#FFFFFF';
        }

        if ($colored) {
            $html .= '<tr><td>' . $day . '</td><td style="background-color:' . $color . '; text-align:center;">' . $cellContent . '</td></tr>';
        } else {
            $html .= '<tr><td>' . $day . '</td><td style="text-align:center;">' . $cellContent . '</td></tr>';
        }
    }
    $html .= '</table><br>';

    $pdf->SetFont('helvetica', '', 10);
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Ln(5);
}

$pdf->Output('staff_attendance_report.pdf', 'D');
exit();
?>