
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




<?php


//$student_id = $_SESSION['student_id'] ?? ($_GET['student_id'] ?? null);
$student_id = $_GET['student_id'];
$exam_id    = $_GET['exam_id'] ?? null;

if (!$student_id || !$exam_id) {
    echo "Missing student_id or exam_id.";
    exit;
}

// Fetch exam name
$sqlExam = "SELECT exam_name FROM exam_schedule WHERE exam_id = ?";
$stmtExam = mysqli_prepare($conn, $sqlExam);
mysqli_stmt_bind_param($stmtExam, 'i', $exam_id);
mysqli_stmt_execute($stmtExam);
$resExam = mysqli_stmt_get_result($stmtExam);
$examData = mysqli_fetch_assoc($resExam);
mysqli_stmt_close($stmtExam);
$exam_name = $examData['exam_name'] ?? 'Unknown Exam';

// Fetch results for this exam & student
$sql = "SELECT er.exam_subject_id, er.marks_obtained, er.max_marks, er.status, er.remarks,
               es.subject_name
        FROM exam_results er
        LEFT JOIN exam_subjects es ON er.exam_subject_id = es.exam_subject_id
        WHERE er.exam_id = ? AND er.student_id = ?
        ORDER BY es.subject_name ASC";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'ii', $exam_id, $student_id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$rows = [];
$totalObt = 0;
$totalMax = 0;
while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = $r;
    $totalObt += floatval($r['marks_obtained']);
    $totalMax += intval($r['max_marks']);
}
mysqli_stmt_close($stmt);

?>



<h1 class="text-lg font-semibold mb-4">
    <?= htmlspecialchars($exam_name) ?> - Result
</h1>


<?php if (empty($rows)): ?>
    <p>No results found for this exam.</p>
<?php else: ?>
<div class="card px-4 pb-4 sm:px-5">
    <div class="mt-5">
        <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
            <table class="is-zebra w-full text-left border border-slate-300 dark:border-navy-500">
                <thead>
                    <tr>
                        <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">#</th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">Subject</th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">Marks Obtained</th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">Max Marks</th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">Status</th>
                        <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase 
                                   text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5 border border-slate-300">Remarks</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; foreach ($rows as $r): ?>
                    <tr>
                        <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5 border border-slate-300"><?= $i++ ?></td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300"><?= htmlspecialchars($r['subject_name'] ?? 'Unknown') ?></td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300"><?= htmlspecialchars($r['marks_obtained']) ?></td>
                        <td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300"><?= htmlspecialchars($r['max_marks']) ?></td>
<td class="whitespace-nowrap px-4 py-3 sm:px-5 border border-slate-300"
    style="background-color: <?= strtolower($r['status']) === 'fail' ? '#FEE2E2' : '#DCFCE7' ?>;
           color: <?= strtolower($r['status']) === 'fail' ? '#B91C1C' : '#166534' ?>;
           font-weight: bold;">
    <?= ucfirst($r['status']) ?>
</td>
                        <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5 border border-slate-300"><?= htmlspecialchars($r['remarks'] ?? '-') ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
                <tfoot>
                    <tr class="bg-slate-100 dark:bg-navy-700">
                        <th colspan="2" class="px-4 py-3 sm:px-5 border border-slate-300 text-left">Total</th>
                        <th class="px-4 py-3 sm:px-5 border border-slate-300"><?= $totalObt ?></th>
                        <th class="px-4 py-3 sm:px-5 border border-slate-300"><?= $totalMax ?></th>
                        <th colspan="2" class="px-4 py-3 sm:px-5 border border-slate-300">
                            <?= $totalMax > 0 ? round($totalObt / $totalMax * 100, 2) . '%' : '-' ?>
                        </th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php endif; ?>
  


  
  
 
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>ntentLoaded", () => Alpine.start());
    </script>
  </body>
</html>