
<?php
require_once "core/db-connect91.php";

if (!isset($_SESSION['student_id'])) {
    die("Error: Student not logged in.");
}



?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




<!-- Student Form (Keep your original styling) -->
<?php



$student_id = $_SESSION['student_id'];

// Fetch student data
$sql = "SELECT * FROM students WHERE student_id = '$student_id' LIMIT 1";
$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Error: Student data not found.");
}

$student = mysqli_fetch_assoc($result);
?>


<div class="col-span-12 grid lg:col-span-8 mx-auto max-w-3xl">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-user"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Student Profile
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">


      <div class="flex justify-center pt-4">
        <img src="<?= htmlspecialchars($student['student_image']) ?>" 
             alt="Student Image" 
             class="h-32 w-32 rounded-lg border border-slate-300 object-cover">
      </div>

      <label class="block">
        <span>Username</span>
        <input value="<?= htmlspecialchars($student['student_username']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Password</span>
        <input value="<?= htmlspecialchars($student['student_password']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Full Name</span>
        <input value="<?= htmlspecialchars($student['student_name'].' '.$student['student_surname']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Father Name</span>
        <input value="<?= htmlspecialchars($student['student_fathername']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Gender</span>
          <input value="<?= htmlspecialchars($student['student_gender']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>

        <label class="block">
          <span>Minority</span>
          <input value="<?= htmlspecialchars($student['student_minority']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Caste</span>
          <input value="<?= htmlspecialchars($student['student_caste']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>

        <label class="block">
          <span>Subcaste</span>
          <input value="<?= htmlspecialchars($student['student_subcaste']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>
      </div>

      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Class</span>
          <input value="<?= htmlspecialchars($student['student_class']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>

        <label class="block">
          <span>Division</span>
          <input value="<?= htmlspecialchars($student['student_division']) ?>" disabled
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
        </label>
      </div>

      <label class="block">
        <span>Birthdate</span>
        <input value="<?= htmlspecialchars($student['student_birthdate']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>GR Number</span>
        <input value="<?= htmlspecialchars($student['student_gr_no']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Admission Number</span>
        <input value="<?= htmlspecialchars($student['student_admission_no']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Email</span>
        <input value="<?= htmlspecialchars($student['student_email']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Phone Number</span>
        <input value="<?= htmlspecialchars($student['student_phonenumber']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Alternative Number</span>
        <input value="<?= htmlspecialchars($student['student_alternativenumber']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>

      <label class="block">
        <span>Address</span>
        <input value="<?= htmlspecialchars($student['student_address']) ?>" disabled
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-slate-100 px-3 py-2"/>
      </label>


    </div>
  </div>
</div>

  
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html> <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>