
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


<?php
// Fetch all complaints (latest first)
$sql = "SELECT * FROM student_complaints ORDER BY complaint_id DESC";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

while ($complaint = mysqli_fetch_assoc($result)) {

    // Fetch student details
    $student = [];
    $sql2 = "SELECT * FROM students WHERE student_id = ?";
    $stmt2 = mysqli_prepare($conn, $sql2);
    mysqli_stmt_bind_param($stmt2, "i", $complaint['student_id']);
    mysqli_stmt_execute($stmt2);
    $result2 = mysqli_stmt_get_result($stmt2);
    $student = mysqli_fetch_assoc($result2);
?>
    <div class="col-span-12 mt-5 grid lg:col-span-8 mb-6">
        <div class="card">
            <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
                <div class="flex items-center space-x-2">
                    <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
                        <i class="fa-solid fa-layer-group"></i>
                    </div>
                    <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
                        Complaint & Student Details
                    </h4>
                </div>
            </div>
            <div class="space-y-4 p-4 sm:p-5">

                <!-- Complaint Title -->
                <label class="block">
                    <span>Complaint Title</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        value="<?= htmlspecialchars($complaint['title']) ?>" disabled />
                </label>

                <!-- Complaint Description -->
                <label class="block">
                    <span>Description</span>
                    <textarea 
                    class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                    rows="3" disabled><?= htmlspecialchars($complaint['description']) ?></textarea>
                </label>

                <!-- Filed Date / Resolved Date -->
                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Filed Date</span>
                            <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($complaint['filed_date']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Resolved Date</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($complaint['resolved_date']) ?>" disabled />
                    </label>
                </div>

                <!-- Complaint Status -->
                <label class="block">
                    <span>Status</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        type="text"
                        value="<?= htmlspecialchars($complaint['status']) ?>" disabled />
                </label>

                <!-- Complaint Audio -->
                <?php if (!empty($complaint['staff_audio'])): ?>
                    <div>
                        <span>Complaint Audio</span>
                        <audio controls class="mt-2 w-full">
                            <source src="<?= htmlspecialchars($complaint['staff_audio']) ?>" type="audio/mpeg">
                            Your browser does not support the audio element.
                        </audio>
                    </div>
                <?php endif; ?>

                <!-- Student Details -->
                <label class="block">
                    <span>Student Full Name</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        type="text"
                        value="<?= htmlspecialchars($student['student_surname'] . ' ' . $student['student_name'] . ' ' . $student['student_fathername']) ?>"
                        disabled />
                </label>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Gender</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_gender']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Birthdate</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_birthdate']) ?>" disabled />
                    </label>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Phone Number</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_phonenumber']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Email</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_email']) ?>" disabled />
                    </label>
                </div>

                <label class="block">
                    <span>Address</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        type="text" value="<?= htmlspecialchars($student['student_address']) ?>" disabled />
                </label>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Class</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($student['student_class']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Division</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($student['student_division']) ?>" disabled />
                    </label>
                </div>
<?php
$staff = [];
if (!empty($complaint['staff_id'])) {
    $sqlStaff = "SELECT staff_surname, staff_name, staff_fathername FROM staff WHERE staff_id = ?";
    $stmtStaff = mysqli_prepare($conn, $sqlStaff);
    mysqli_stmt_bind_param($stmtStaff, "i", $complaint['staff_id']);
    mysqli_stmt_execute($stmtStaff);
    $resultStaff = mysqli_stmt_get_result($stmtStaff);
    $staff = mysqli_fetch_assoc($resultStaff);
}
?>

<label class="block">
    <span>Complaint By</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
        type="text"
        value="<?= htmlspecialchars(trim(($staff['staff_surname'] ?? '') . ' ' . ($staff['staff_name'] ?? '') . ' ' . ($staff['staff_fathername'] ?? ''))) ?>"
        disabled />
</label>
            </div>
        </div>
    </div>
<?php
} // end while
?>
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>