<?php
require_once "core/db-connect91.php";
require_once '../library/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;


$student_id = $_GET['student_id'];
$exam_id    = $_GET['exam_id'] ?? null;

// --- Fetch Student Info ---
$sqlStudent = "SELECT * FROM students WHERE student_id = $student_id";
$student = $conn->query($sqlStudent)->fetch_assoc();
$studentFullName = $student['student_name'] . " " . $student['student_surname'];

// --- Fetch Exam Info ---
$sqlExam = "SELECT * FROM exam_schedule WHERE exam_id = $exam_id";
$exam = $conn->query($sqlExam)->fetch_assoc();

// --- Fetch Results with Subjects ---
$sqlResults = "SELECT r.*, es.subject_name, es.max_marks AS subject_max, es.passing_marks
               FROM exam_results r
               JOIN exam_subjects es ON r.exam_subject_id = es.exam_subject_id
               WHERE r.student_id = $student_id AND r.exam_id = $exam_id";
$resultSet = $conn->query($sqlResults);

// Calculate totals
$totalObtained = 0;
$totalMax = 0;
$subjectsHtml = '';
while($row = $resultSet->fetch_assoc()){
    $subjectsHtml .= "<tr>
        <td class='center'>{$exam['batch']}</td>
        <td>{$row['subject_name']}</td>
        <td class='center'>{$row['subject_max']}</td>
        <td class='center'>{$row['passing_marks']}</td>
        <td class='center'>{$row['marks_obtained']}</td>
    </tr>";
    $totalObtained += $row['marks_obtained'];
    $totalMax += $row['subject_max'];
}

// --- Fetch Grade ---
$percentage = ($totalMax > 0) ? ($totalObtained / $totalMax) * 100 : 0;
$sqlGrade = "SELECT * FROM exam_grades 
             WHERE $percentage BETWEEN min_percentage AND max_percentage LIMIT 1";
$grade = $conn->query($sqlGrade)->fetch_assoc();

$gradeName = $grade['grade_name'] ?? 'N/A';

// --- Build HTML ---

$html = '
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Tritriangle Report Card</title>
<style>
:root{ --brand:#00a7a5; --brand-dark:#078d8b; --text:#222; --muted:#6b6b6b; --border:#d8d8d8; --table-head:#ebf6f6; --watermark:#f4f4f4; --accent:#14b8b6; }
*{box-sizing:border-box}
html,body{margin:0;font-family:Arial,Helvetica,sans-serif;color:var(--text);background:#fff}
.page{ width: 794px; margin: 24px auto; padding: 26px 28px 32px; border:1px solid #e5e5e5; box-shadow:0 2px 16px rgba(0,0,0,.06); position:relative; background:#fff; }
.page::after{ content:"www.resulthosting.net"; position:absolute; inset:0; display:block; color:#d9d9d9; font-size:42px; font-weight:700; transform:rotate(-25deg); letter-spacing:1px; text-align:center; opacity:.26; top:40%; pointer-events:none; }
.header{ display:flex; align-items:center; gap:18px; border-bottom:2px solid var(--border); padding-bottom:14px; margin-bottom:12px; }
.logo{ width:78px; height:78px; display:grid; place-items:center; }
.logo svg{width:78px;height:78px}
.title{ flex:1; }
.title h1{ margin:0; font-size:34px; letter-spacing:1px; font-weight:700; }
.title h1 .tri{color:var(--brand)}
.subtitle{ margin-top:4px; font-size:12px; letter-spacing:3px; color:var(--brand-dark); }
.website-note{ text-align:right; margin-left:auto; color:#c9c9c9; font-size:12px; margin-top:6px; }
.info{ display:grid; grid-template-columns: 170px 12px 1fr 170px 12px 1fr; row-gap:10px; column-gap:8px; margin:6px 0 8px; }
.label{color:#666}
.value{font-weight:600}
.sep{color:#666}
table{ width:100%; border-collapse:collapse; font-size:14px; margin-top:8px; }
thead th{ background:var(--table-head); border:1px solid var(--border); text-align:left; padding:10px 8px; font-weight:700; }
tbody td{ border:1px solid var(--border); padding:10px 8px; }
tbody tr:nth-child(even){background:#fafafa}
.col-year{width:70px}
.col-max,.col-min,.col-obt{width:110px; text-align:center}
.right{text-align:right}
.totals{margin-top:14px;}
.totals th,.totals td{border:1px solid var(--border); padding:10px 8px;}
.totals thead th{background:var(--table-head)}
.center{text-align:center}
.result{ display:grid; grid-template-columns: 1.4fr 1fr 1fr 0.8fr; border:1px solid var(--border); margin-top:16px; }
.result > div{ padding:12px 10px; border-right:1px solid var(--border); }
.result > div:last-child{border-right:none}
.result .h{font-weight:700; color:#555; margin-bottom:4px}
.grade{ font-weight:800; color:#0b8; font-size:18px; }
.disclaimer{ margin-top:10px; font-size:11px; color:#a23; line-height:1.45; border-top:1px dashed #e6bcbc; padding-top:8px; }
.footer{ display:flex; align-items:center; gap:12px; justify-content:space-between; margin-top:14px; font-size:13px; }
.footer .powered{color:#777}
.footer .whatsapp{color:#0a0}
.cta{ margin-top:8px; background:#eaf6ff; color:#0b66c2; padding:10px; text-align:center; font-weight:700; border:1px solid #cfe8ff; }
@media print{ .page{margin:0; box-shadow:none; border:none} .page::after{opacity:.18} .cta,.footer{display:none} }
</style>
</head>
<body>
<div class="page">
  <div class="header">
    <div class="logo" aria-hidden="true">
      <svg viewBox="0 0 100 100">
        <defs><linearGradient id="g" x1="0" y1="0" x2="0" y2="1"><stop offset="0" stop-color="#14b8b6"/><stop offset="1" stop-color="#0aa"/></linearGradient></defs>
        <path d="M10 82 L50 10 L90 82" fill="none" stroke="url(#g)" stroke-width="10" stroke-linejoin="round"/>
        <path d="M28 82 L50 42 L72 82" fill="none" stroke="#14b8b6" stroke-width="10" stroke-linejoin="round"/>
      </svg>
    </div>
    <div class="title">
      <h1><span class="tri">TRITRIANGLE</span></h1>
      <div class="subtitle">INSTITUTE OF MANAGEMENT</div>
    </div>
    <div class="website-note">www.resulthosting.net</div>
  </div>

  <!-- info grid -->
  <div class="info">
    <div class="label">STUDENT\'S NAME</div><div class="sep">:</div><div class="value">'.$studentFullName.'</div>
    <div class="label">DATE OF BIRTH</div><div class="sep">:</div><div class="value">'.date("d-m-Y", strtotime($student['student_birthdate'])).'</div>
    <div class="label">FATHER NAME</div><div class="sep">:</div><div class="value">'.$student['student_fathername'].'</div>
    <div class="label">PROGRAM</div><div class="sep">:</div><div class="value">'.$student['student_class'].' - '.$student['student_division'].'</div>
    <div class="label">ADMISSION NO</div><div class="sep">:</div><div class="value">'.$student['student_admission_no'].'</div>
    <div class="label">GR NO</div><div class="sep">:</div><div class="value">'.$student['student_gr_no'].'</div>
  </div>

  <!-- subjects table -->
  <table>
    <thead>
      <tr>
        <th class="col-year">YEAR</th>
        <th>SUBJECT</th>
        <th class="col-max">MAX MARKS</th>
        <th class="col-min">MIN MARKS</th>
        <th class="col-obt">MARKS OBTAINED</th>
      </tr>
    </thead>
    <tbody>'.$subjectsHtml.'</tbody>
  </table>

  <!-- totals -->
  <table class="totals">
    <thead>
      <tr>
        <th class="center" style="width:70px">YEAR</th>
        <th class="center">TOTAL OBTAINED MARKS</th>
        <th class="center">MAX TOTAL MARKS</th>
        <th class="center">RESULT</th>
      </tr>
    </thead>
    <tbody>'.$totalsHtml.'</tbody>
  </table>

  <!-- result summary -->
  <div class="result">
    <div><div class="h">RESULT</div>'.($percentage >= 40 ? "COURSE COMPLETED" : "FAILED").'</div>
    <div><div class="h">MARKS OBTAINED</div>'.$totalObtained.'</div>
    <div><div class="h">MAX MARKS</div>'.$totalMax.'</div>
    <div><div class="h">GRADE</div><span class="grade">'.$gradeName.'</span></div>
  </div>

  <div class="disclaimer">
    DISCLAIMER (NOT OFFICIAL COPY): Neither webmaster nor Result Hosting is responsible for any inadvertent error that may creep in the results being published on NET. 
    The results published on net are immediate information for Students. This cannot be treated as original mark sheet. Original mark sheets will be issued by the Controller Of Examination office separately.
  </div>

  <div class="footer">
    <div class="powered">resulthosting.net - Powered By Result Hosting</div>
    <div class="whatsapp">Whatsapp: +91 8808498469</div>
  </div>

  <div class="cta">Get This Software For Your Educational Institute</div>
</div>
</body>
</html>
';

// --- Generate PDF ---
$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("scorecard.pdf", ["Attachment" => 1]); // 1 = download, 0 = inline
?>