
<?php
require_once "core/db-connect91.php";


// Check if staff ID exists in session
if (empty($_SESSION['selected_staff_id'])) {
    // Redirect to another page (e.g. login.php or staff_select.php)
    header("Location: staff-pay-salary.php");
    exit();
}

$selected_staff_id = (int)($_SESSION['selected_staff_id'] ?? $selected_staff_id ?? 0);
$staff_id = (int)($_SESSION['selected_staff_id'] ?? 0);
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">


<?php
// -------------------------------------------------------------------------
// 1) Fetch staff (preserves card/grid layout and classes)
$staff_stmt = $conn->prepare("SELECT * FROM staff WHERE staff_id = ?");
$staff_stmt->bind_param("i", $selected_staff_id);
$staff_stmt->execute();
$staff_result = $staff_stmt->get_result();


?>



<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">
<?php
if ($staff_result && $staff_result->num_rows > 0) {
    while ($row = $staff_result->fetch_assoc()) {
        // explicit image src fallback (preserve behavior)
        $imgSrc = $website . ($row['staff_image'] ?: 'default.png');
?>
    <div class="card">
        <div class="p-2 text-right"></div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= htmlspecialchars($imgSrc) ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= htmlspecialchars($row['staff_name'] . " " . $row['staff_surname']) ?>
            </h3>
            <p class="text-xs-plus"><?= ucfirst(htmlspecialchars($row['staff_role'])) ?></p>
            
            <div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
                <span class="tag rounded-full bg-success/10 text-success m-1">
                    Phone: <?= htmlspecialchars($row['staff_phonenumber']) ?>
                </span>
            </div>
            <div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
                <span class="tag rounded-full bg-success/10 text-success m-1">
                    Email: <?= htmlspecialchars($row['staff_email']) ?>
                </span>
            </div>

            <!-- Hidden Form -->
            <form action="set-staff-id.php" method="POST" id="staffForm<?= (int)$row['staff_id'] ?>" style="display:none;">
                <input type="hidden" name="staff_id" value="<?= (int)$row['staff_id'] ?>">
                <input type="hidden" name="target_page" id="targetPage<?= (int)$row['staff_id'] ?>" value="">
            </form>

            <!-- Buttons -->
            <div class="mt-6 grid w-full grid-cols-2 gap-2">                
                <button type="button" 
                    class="btn space-x-2 bg-primary px-0 font-medium text-white hover:bg-primary-focus"
                    onclick="
                        document.getElementById('targetPage<?= (int)$row['staff_id'] ?>').value='staff-salary-payment-history.php';
                        document.getElementById('staffForm<?= (int)$row['staff_id'] ?>').submit();
                    ">
                 Salary Payment History
                </button>           
                <button type="button" 
                    class="btn space-x-2 bg-slate-150 px-0 font-medium text-slate-800 hover:bg-slate-200"
                    onclick="
                        document.getElementById('targetPage<?= (int)$row['staff_id'] ?>').value='staff-view-staff-attendance-main.php';
                        document.getElementById('staffForm<?= (int)$row['staff_id'] ?>').submit();
                    ">
                  View  Attendance
                </button>
            </div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No staff found.</p>";
}
$staff_stmt->close();
?>
</div>


<form method="POST">
<div class="card mt-4">
    <div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
        
        <label class="block w-full">
<span class="font-medium text-slate-600 dark:text-navy-100">Month</span>
<select name="month" required
  class="mt-1.5 w-full"
  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
>
<option value="1" <?= $month===1 ? 'selected' : '' ?>>January</option>
<option value="2" <?= $month===2 ? 'selected' : '' ?>>February</option>
<option value="3" <?= $month===3 ? 'selected' : '' ?>>March</option>
<option value="4" <?= $month===4 ? 'selected' : '' ?>>April</option>
<option value="5" <?= $month===5 ? 'selected' : '' ?>>May</option>
<option value="6" <?= $month===6 ? 'selected' : '' ?>>June</option>
<option value="7" <?= $month===7 ? 'selected' : '' ?>>July</option>
<option value="8" <?= $month===8 ? 'selected' : '' ?>>August</option>
<option value="9" <?= $month===9 ? 'selected' : '' ?>>September</option>
<option value="10" <?= $month===10 ? 'selected' : '' ?>>October</option>
<option value="11" <?= $month===11 ? 'selected' : '' ?>>November</option>
<option value="12" <?= $month===12 ? 'selected' : '' ?>>December</option>
            </select>
        </label>

        <label class="block w-full">

<span class="font-medium text-slate-600 dark:text-navy-100">Year</span>
<select name="year" required
  class="mt-1.5 w-full"
  x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
>
                <option value="2024" <?= $year===2024 ? 'selected' : '' ?>>2024</option>              
                <option value="2025" <?= $year===2025 ? 'selected' : '' ?>>2025</option>
                <option value="2026" <?= $year===2026 ? 'selected' : '' ?>>2026</option>
            </select>
        </label>

<label class="block w-full">
  <span class="font-medium text-slate-600 dark:text-navy-100">Batch</span>
  <select name="batch" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Batch</option>
    <?php
    $bres = mysqli_query($conn, "SELECT batch_name FROM batch WHERE status='Active' ORDER BY batch_id DESC");
    while ($b = mysqli_fetch_assoc($bres)) : ?>
      <option value="<?= htmlspecialchars($b['batch_name']) ?>" <?= ($batch == $b['batch_name']) ? 'selected' : '' ?>>
        <?= htmlspecialchars($b['batch_name']) ?>
      </option>
    <?php endwhile; ?>
  </select>
</label>
    <input type="hidden" name="form_type_data" value="staff_salary_payment_get_data">
        <div class="mt-4 w-full">
            <button type="submit" 
                class="btn bg-primary text-white w-full py-2 rounded-lg">
                Load Payment
            </button>
        </div>
    </div>
</div>
</form>

<?php
session_start();


if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['form_type_data']) && $_POST['form_type_data'] === 'staff_salary_payment_get_data') {
    
    // Store values in session
    $_SESSION['selected_month'] = (int)$_POST['month'];
    $_SESSION['selected_year']  = (int)$_POST['year'];
    $_SESSION['selected_batch'] = trim($_POST['batch']);

    // Use JS to redirect
    echo '<script>window.location.href = "staff-pay-salary-main-2.php";</script>';

}


?>



<?php
// Example: $staff_id comes from session or request


$sql = "
    SELECT 
        p.month,
        p.year,
        p.batch,
        p.salary_to_pay,
        p.paid_amount,
        p.due_amount,
        p.payment_status,
        p.payment_date,
        p.remarks
    FROM staff_salary_payments p
    LEFT JOIN staff s ON p.staff_id = s.staff_id
    WHERE p.staff_id = ?
    ORDER BY p.payment_date DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $staff_id);
$stmt->execute();
$result = $stmt->get_result();

?>
<div class="mt-5">
  <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
    <table class="is-zebra w-full text-left">
      <thead>
        <tr>
          <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">#</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Month</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Year</th>

          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Salary To Pay</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Paid</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Due</th>
          <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Status</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result && $result->num_rows > 0): 
          $i = 1;
          while ($row = $result->fetch_assoc()): ?>
            <tr>
              <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5"><?= $i++; ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= htmlspecialchars($row['month']); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= htmlspecialchars($row['year']); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['salary_to_pay'], 2); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['paid_amount'], 2); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['due_amount'], 2); ?></td>
              <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">
                <?php if ($row['payment_status'] === 'paid'): ?>
                  <span class="text-green-600 font-semibold">Paid</span>
                <?php elseif ($row['payment_status'] === 'partial'): ?>
                  <span class="text-yellow-600 font-semibold">Partial</span>
                <?php else: ?>
                  <span class="text-red-600 font-semibold">Unpaid</span>
                <?php endif; ?>
              </td>
            </tr>
        <?php endwhile; else: ?>
            <tr>
              <td colspan="8" class="text-center py-4 text-slate-500">No salary payments found.</td>
            </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>


  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>