
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">







<?php


// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_timetable'])) {
    $class_id     = intval($_POST['class_id']);
    $day_of_week  = mysqli_real_escape_string($conn, $_POST['day_of_week']);
    $updated_by   = 1; // Example user id, replace with logged-in user id

    // First delete existing data for that class/day/batch → then insert fresh
    $delete_sql = "DELETE FROM school_timetable WHERE class_id='$class_id' AND day_of_week='$day_of_week' AND batch='$batch'";
    mysqli_query($conn, $delete_sql);

    if (!empty($_POST['period_number'])) {
        foreach ($_POST['period_number'] as $index => $period_number) {
            $period_number = intval($period_number);
            $subject_id    = intval($_POST['subject_id'][$index]);
            $staff_id      = intval($_POST['staff_id'][$index]);
            $start_time    = mysqli_real_escape_string($conn, $_POST['start_time'][$index]);
            $end_time      = mysqli_real_escape_string($conn, $_POST['end_time'][$index]);

            if ($period_number && $subject_id && $staff_id) {
                $sql = "INSERT INTO school_timetable 
                        (class_id, day_of_week, period_number, subject_id, staff_id, start_time, end_time, batch, updated_by) 
                        VALUES 
                        ('$class_id', '$day_of_week', '$period_number', '$subject_id', '$staff_id', '$start_time', '$end_time', '$batch', '$updated_by')";
                mysqli_query($conn, $sql);
            }
        }
        echo "<p style='color:green'>Timetable saved successfully!</p>";
    } else {
        echo "<p style='color:red'>Please add at least one row.</p>";
    }
}

// Load existing timetable data if class/day is selected
$prefill_data = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['load_timetable'])) {
    $class_id    = intval($_POST['class_id']);
    $day_of_week = mysqli_real_escape_string($conn, $_POST['day_of_week']);

    $sql = "SELECT * FROM school_timetable WHERE class_id='$class_id' AND day_of_week='$day_of_week' AND batch='$batch' ORDER BY period_number ASC";
    $result = mysqli_query($conn, $sql);
    while ($row = mysqli_fetch_assoc($result)) {
        $prefill_data[] = $row;
    }
$staffOptions = [];
if (isset($class_id) && $class_id > 0) {
    $sqlStaff = "
        SELECT s.staff_id, CONCAT(s.staff_surname, ' ', s.staff_name, ' ', s.staff_fathername) AS fullname
        FROM teacher_allotment ta
        INNER JOIN staff s ON ta.staff_id = s.staff_id
        WHERE ta.class_id = '$class_id'
    ";
    $resStaff = mysqli_query($conn, $sqlStaff);
    while ($row = mysqli_fetch_assoc($resStaff)) {
        $staffOptions[] = $row;
    }


// Fetch staff for class
$classId = $class_id;
$staffResult = $conn->query("SELECT s.staff_id, CONCAT(s.staff_name, ' ', s.staff_surname) AS fullname 
                             FROM staff s 
                             JOIN teacher_allotment t ON s.staff_id = t.staff_id 
                             WHERE t.class_id = $classId");
$staffOptions = [];
while ($row = $staffResult->fetch_assoc()) {
    $staffOptions[] = $row;
}

// Fetch subjects for class
$subjectResult = $conn->query("SELECT id, subject_name FROM class_subjects WHERE class_id = $classId ORDER BY subject_name");
$subjectOptions = [];
while ($row = $subjectResult->fetch_assoc()) {
    $subjectOptions[] = $row;
}

}
}
?>


    <script>




// These arrays should be echoed from PHP when page loads
let staffOptions = <?php echo json_encode($staffOptions); ?>;  
let subjectOptions = <?php echo json_encode($subjectOptions); ?>;  

function addRow(prefill = null) {
    let table = document.getElementById("timetable-rows");
    let row = document.createElement("tr");

    // Build subject dropdown
    let subjectSelect = `<select name="subject_id[]" class="form-select w-40 rounded-lg border border-slate-300 px-2 py-1" required>`;
    subjectSelect += `<option value="">-- Select Subject --</option>`;
    subjectOptions.forEach(subject => {
        let selected = (prefill && prefill.subject_id == subject.id) ? "selected" : "";
        subjectSelect += `<option value="${subject.id}" ${selected}>${subject.subject_name}</option>`;
    });
    subjectSelect += `</select>`;

    // Build staff dropdown
    let staffSelect = `<select name="staff_id[]" class="form-select w-48 rounded-lg border border-slate-300 px-2 py-1" required>`;
    staffSelect += `<option value="">Select Staff</option>`;
    staffOptions.forEach(staff => {
        let selected = (prefill && prefill.staff_id == staff.staff_id) ? "selected" : "";
        staffSelect += `<option value="${staff.staff_id}" ${selected}>${staff.fullname}</option>`;
    });
    staffSelect += `</select>`;

    row.innerHTML = `
        <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">
            <input type="number" class="form-input w-24 rounded-lg border border-slate-300 px-2 py-1"
                   name="period_number[]" value="${prefill ? prefill.period_number : ''}" required>
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            ${subjectSelect}
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            ${staffSelect}
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <input type="time" class="form-input w-32 rounded-lg border border-slate-300 px-2 py-1"
                   name="start_time[]" value="${prefill ? prefill.start_time : ''}" required>
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
            <input type="time" class="form-input w-32 rounded-lg border border-slate-300 px-2 py-1"
                   name="end_time[]" value="${prefill ? prefill.end_time : ''}" required>
        </td>
        <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">
<button onclick="removeRow(this)"
    class="btn bg-error font-medium text-white hover:bg-error-focus hover:shadow-lg hover:shadow-error/50 focus:bg-error-focus focus:shadow-lg focus:shadow-error/50 active:bg-error-focus/90"
  >
X
  </button>
        </td>
    `;
    table.appendChild(row);
}


        function removeRow(btn) {
            btn.closest("tr").remove();
        }
    </script>
</head>
<body>

<div class="col-span-12 lg:col-span-13">
  <form method="POST" class="card space-y-5 p-4 sm:p-5">

<?php
// Fetch classes from DB
$classResult = $conn->query("SELECT class_name, division FROM classes ORDER BY class_name ASC, division ASC");
?>

<label class="block">
  <span class="font-medium text-slate-600 dark:text-navy-100">Select Class</span>
  <select name="class_id"
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  required
  >
    <option value="">Select Class</option>
    <?php 
    while($cRow = $classResult->fetch_assoc()) {
        $classDisplay = $cRow['class_name']." ".$cRow['division']; 
        $classValue = $cRow['class_name']."|".$cRow['division']; // store both
        $selected = ($class== $classValue) ? "selected" : "";
        echo "<option value='$classValue' $selected>$classDisplay</option>";
    }
    ?>
  </select>
</label>
    
    

<label class="block">
  <span class="font-medium text-slate-600 dark:text-navy-100">Select Class</span>
  <select name="day_of_week"
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  required
  >
    <option value="">Select Day</option>
<?php
$days = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
foreach ($days as $day) {
    $sel = (isset($day_of_week) && $day_of_week == $day) ? "selected" : "";
    echo "<option $sel>$day</option>";
}
?>
  </select>
</label>
    
    
    
    


    
    <button type="submit" name="load_timetable"
    class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Load
    </button>
  </form>
</div>
    <!-- STEP 1: Select Class & Day -->


    <!-- STEP 2: Show Rows -->
    <?php if (isset($class_id) && isset($day_of_week)): ?>
<div class="card mt-5 space-y-5 p-4 sm:p-5">    
    <form method="post">
        <input type="hidden" name="class_id" value="<?php echo $class_id; ?>">
        <input type="hidden" name="day_of_week" value="<?php echo $day_of_week; ?>">

<div class="is-scrollbar-hidden min-w-full overflow-x-auto">
  <table class="is-zebra w-full text-left">
    <thead>
      <tr>
        <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          Period
        </th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          Subject ID
        </th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          Staff ID
        </th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          Start Time
        </th>
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          End Time
        </th>
        <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
          Action
        </th>
      </tr>
    </thead>
    <tbody id="timetable-rows">
      <?php  
      if (!empty($prefill_data)) {  
          foreach ($prefill_data as $row) {  
              echo "<script>  
                      addRow({  
                          period_number: '{$row['period_number']}',  
                          subject_id: '{$row['subject_id']}',  
                          staff_id: '{$row['staff_id']}',  
                          start_time: '{$row['start_time']}',  
                          end_time: '{$row['end_time']}'  
                      });  
                    </script>";  
          }  
      }  
      ?>
    </tbody>
  </table>
</div>
        <button type="button" class="btn bg-success mt-5 font-medium text-white hover:bg-primary-focus focus:bg-success-focus active:bg-success-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
         onclick="addRow()">+ Add Row</button><br><br>
</div>


<div class="card mt-5 space-y-5 p-4 sm:p-5">
<button type="submit" name="save_timetable"
class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Save Timetable
</button>

</div>

        

    </form>
    <?php endif; ?>











  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>