
<?php
require_once "core/db-connect91.php";
error_reporting(E_ALL);
ini_set('display_errors', 1);
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">











<?php


if (isset($_POST['submit_syllabus'])) {
    $class_id = intval($_POST['class_id']);
    $subject  = $conn->real_escape_string($_POST['subject']);
    $semester = intval($_POST['semester']);
    $chapters = $_POST['chapter'] ?? [];

    $errors = [];

    if (empty($class_id) || empty($subject) || empty($semester)) {
        $errors[] = "Class, Subject, and Semester are required!";
    }

    if (empty($chapters)) {
        $errors[] = "Please add at least one chapter.";
    }

    if (empty($errors)) {
        // Delete old syllabus
        $conn->query("DELETE FROM syllabus WHERE class_id=$class_id AND subject='$subject' AND semester=$semester");

        foreach ($chapters as $ch) {
            $ch = trim($conn->real_escape_string($ch));
            if (!empty($ch)) {
                $sql = "INSERT INTO syllabus (class_id, class_name, subject, chapter, semester, created_by)
                        VALUES ($class_id,
                        (SELECT class_name FROM classes WHERE class_id=$class_id LIMIT 1),
                        '$subject', '$ch', $semester, 1)";
                if (!$conn->query($sql)) {
                    $errors[] = $conn->error;
                }
            }
        }

        if (empty($errors)) {
            echo "<script>alert('✅ Syllabus saved successfully!');</script>";
        } else {
            foreach ($errors as $err) {
                echo "<script>alert('❌ $err');</script>";
            }
        }
    } else {
        foreach ($errors as $err) {
            echo "<script>alert('❌ $err');</script>";
        }
    }
}

// Fetch classes for dropdown
$classResult = $conn->query("SELECT class_id, class_name, division FROM classes ORDER BY class_name, division");
?>

<!-- FORM HTML -->
<div class="col-span-12 grid lg:col-span-8">
    <div class="card rounded-2xl shadow-lg border border-slate-200 dark:border-navy-500 bg-white dark:bg-navy-800">
        <div class="border-b border-slate-200 p-4 flex items-center space-x-3">
            <i class="fa-solid fa-layer-group text-lg text-primary"></i>
            <h4 class="text-xl font-semibold text-slate-700 dark:text-navy-100">Add Syllabus</h4>
        </div>

        <form method="POST" id="syllabusForm" class="p-6 space-y-5">

            <!-- Class -->
            <label class="block">
                <span>Select Class</span>
                <select id="classSelect" name="class_id" class="w-full border rounded-lg px-3 py-2">
                    <option value="">-- Select Class --</option>
                    <?php while ($c = $classResult->fetch_assoc()): ?>
                        <option value="<?= $c['class_id'] ?>"><?= $c['class_name'] . " " . $c['division'] ?></option>
                    <?php endwhile; ?>
                </select>
            </label>

            <!-- Subject -->
            <label class="block">
                <span>Select Subject</span>
                <select id="subjectSelect" name="subject" class="w-full border rounded-lg px-3 py-2"></select>
            </label>

            <!-- Semester -->
            <label class="block">
                <span>Select Semester</span>
                <select name="semester" id="semester" class="w-full border rounded-lg px-3 py-2">
                    <option value="1">Semester 1</option>
                    <option value="2">Semester 2</option>
                </select>
            </label>

            <!-- Chapters Table -->
            <table id="chaptersTable" class="w-full border mt-4">
                <thead>
                    <tr>
                        <th class="border px-2 py-1">#</th>
                        <th class="border px-2 py-1">Chapter</th>
                        <th class="border px-2 py-1">Action</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>

<button type="button" id="addRow"
class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Add Row
</button>

<button type="submit" name="submit_syllabus"
class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
    Submit
</button>
        

        </form>
    </div>
</div>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
function loadSyllabus(){
    let classId = $("#classSelect").val();
    let subject = $("#subjectSelect").val();
    let semester = $("#semester").val();

    if(classId && subject && semester){
        $.post("supporting/add-syllabus-get-syllabus.php", {
            class_id: classId,
            subject: subject,
            semester: semester
        }, function(data){
            $("#chaptersTable tbody").html(data);
        });
    } else {
        $("#chaptersTable tbody").html("");
    }
}

// Load syllabus when class, subject, or semester changes
$("#classSelect, #subjectSelect, #semester").change(loadSyllabus);

// Load subjects first if class changes
$("#classSelect").change(function(){
    let classId = $(this).val();
    if(classId){
        $.post("supporting/add-syllabus-get-subject.php", {class_id: classId}, function(data){
            $("#subjectSelect").html(data);
            loadSyllabus(); // Load syllabus after subjects are populated
        });
    } else {
        $("#subjectSelect").html("");
        $("#chaptersTable tbody").html("");
    }
});


    // Add new chapter row
    $("#addRow").click(function(){
        let rowCount = $("#chaptersTable tbody tr").length + 1;
        let row = `<tr>
            <td class="border px-2 py-1">${rowCount}</td>
            <td class="border px-2 py-1"><input type="text" name="chapter[]" class="w-full border rounded px-2 py-1" required></td>
            <td class="border px-2 py-1">
            <button type="button"
            class="removeRow btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
Remove Row
            </button></td>
        </tr>`;
        $("#chaptersTable tbody").append(row);
    });

    // Delete chapter row
    $("#chaptersTable").on("click", ".removeRow", function(){
        $(this).closest("tr").remove();
        // Re-number rows
        $("#chaptersTable tbody tr").each(function(i){
            $(this).find("td:first").text(i + 1);
        });
    });

});
</script>



















  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>