
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  
<div class="col-span-12 grid lg:col-span-8 mb-6">
    <div class="card">
        <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
            <div class="flex items-center space-x-2">
                <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
                    <i class="fa-solid fa-layer-group"></i>
                </div>
                <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
                    Complaint & Student Details
                </h4>
            </div>
        </div>
        <div class="space-y-4 p-4 sm:p-5">

            <form method="POST" enctype="multipart/form-data">

                <!-- Complaint Title -->
                <label class="block">
                    <span>Complaint Title</span>
                    <input name="title"
                        class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        required />
                </label>

                <!-- Complaint Description -->
                <label class="block">
                    <span>Description</span>
                    <textarea name="description"
                        class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        rows="3" required></textarea>
                </label>

                <!-- Recording Buttons -->
                <button type="button" id="startBtn"
                    class="btn bg-success text-white">
                    Start Recording
                </button>
                <button type="button" id="stopBtn"
                    class="btn bg-error text-white" disabled>
                    End Recording
                </button>

                <!-- Audio Playback -->
                <audio id="audioPlayback" controls class="mt-3 hidden"></audio>

                <!-- Hidden Input for Audio File -->
                <input type="file" name="staff_audio" id="audioFile" accept="audio/*" class="hidden">

                <?php
                $student = [];
                $sql2 = "SELECT * FROM students WHERE student_id = ?";
                $stmt2 = mysqli_prepare($conn, $sql2);
                mysqli_stmt_bind_param($stmt2, "i", $_SESSION['student_id']);
                mysqli_stmt_execute($stmt2);
                $result2 = mysqli_stmt_get_result($stmt2);
                $student = mysqli_fetch_assoc($result2);
                ?>

                <!-- Student Details -->
                <label class="block">
                    <span>Student Full Name</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        type="text"
                        value="<?= htmlspecialchars($student['student_surname'] . ' ' . $student['student_name'] . ' ' . $student['student_fathername']) ?>"
                        disabled />
                </label>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Gender</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_gender']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Birthdate</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_birthdate']) ?>" disabled />
                    </label>
                </div>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Phone Number</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_phonenumber']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Email</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            type="text" value="<?= htmlspecialchars($student['student_email']) ?>" disabled />
                    </label>
                </div>

                <label class="block">
                    <span>Address</span>
                    <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                        type="text" value="<?= htmlspecialchars($student['student_address']) ?>" disabled />
                </label>

                <div class="grid grid-cols-2 gap-4">
                    <label class="block">
                        <span>Class</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($student['student_class']) ?>" disabled />
                    </label>
                    <label class="block">
                        <span>Division</span>
                        <input class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
                            value="<?= htmlspecialchars($student['student_division']) ?>" disabled />
                    </label>
                </div>

                <!-- Hidden values -->
                <input type="hidden" name="student_id" value="<?= $_SESSION['student_id'] ?>">
                <input type="hidden" name="student_gr_no" value="<?= htmlspecialchars($student['student_gr_no']) ?>">

                <button type="submit"
                    class="mt-5 btn bg-primary text-white">
                    Submit
                </button>
            </form>
        </div>
    </div>
</div>

<script>
let mediaRecorder, audioChunks = [];
const startBtn = document.getElementById("startBtn");
const stopBtn = document.getElementById("stopBtn");
const audioPlayback = document.getElementById("audioPlayback");
const audioFile = document.getElementById("audioFile");

startBtn.addEventListener("click", async () => {
    const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
    mediaRecorder = new MediaRecorder(stream);
    audioChunks = [];

    mediaRecorder.ondataavailable = e => audioChunks.push(e.data);

    mediaRecorder.onstop = () => {
        const audioBlob = new Blob(audioChunks, { type: "audio/webm" });
        const audioUrl = URL.createObjectURL(audioBlob);

        audioPlayback.src = audioUrl;
        audioPlayback.classList.remove("hidden");

        const file = new File([audioBlob], "complaint_audio.webm", { type: "audio/webm" });
        const dt = new DataTransfer();
        dt.items.add(file);
        audioFile.files = dt.files;
    };

    mediaRecorder.start();
    startBtn.disabled = true;
    stopBtn.disabled = false;
});

stopBtn.addEventListener("click", () => {
    mediaRecorder.stop();
    startBtn.disabled = false;
    stopBtn.disabled = true;
});
</script>

  <?php

  if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $student_id = $_POST['student_id'];
  $student_gr_no = $_POST['student_gr_no'];
  $staff_id = $_SESSION['staff_id'] ?? 0; // who is filing/assigned
  $title = $_POST['title'];
  $description = $_POST['description'];
  $audioPath = null;
  
  if (isset($_FILES['staff_audio']) && $_FILES['staff_audio']['error'] === UPLOAD_ERR_OK) {
  $uploadDir = "../studentcomplaintaudio";
  $uploadDir2 = "studentcomplaintaudio";
  if (!is_dir($uploadDir)) {
  mkdir($uploadDir, 0777, true);
  }
  $fileName = time() . "_" . basename($_FILES['staff_audio']['name']);
  $targetFile = $uploadDir . $fileName;
  $targetFile2 = $uploadDir2 . $fileName;  
  if (move_uploaded_file($_FILES['staff_audio']['tmp_name'], $targetFile)) {
  $audioPath = $website . $targetFile2;
  }
  }
  
  $sql = "INSERT INTO student_complaints 
  (student_id, student_gr_no, staff_id, title, description, staff_audio, status, filed_date) 
  VALUES (?, ?, ?, ?, ?, ?, 'pending', NOW())";
  
  $stmt = $conn->prepare($sql);
  $stmt->bind_param("isisss", $student_id, $student_gr_no, $staff_id, $title, $description, $audioPath);
  
  if ($stmt->execute()) {


$message = "The student complaint has been successfully recorded.";
$messageType = "success";
  
  } else {
$message = "An error occurred while processing your request. Please try again.";
$messageType = "error";
  }
  }
  ?>
  
  
  
<?php include 'layout/footer.php'; ?>
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>