
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">





<?php
/* -------------------------------------------------
   PRE-REQUISITES
   -------------------------------------------------
   – $conn  : already-opened mysqli connection
   – $exam_id : integer (e.g. via GET ?exam_id=123)
   -------------------------------------------------*/
$exam_id = (int)($_SESSION['exam_id'] ?? 0);
if (!$exam_id) { die('Missing exam_id'); }

/* 1 ─── Subjects for this exam */
$sql = "SELECT exam_subject_id, subject_name, max_marks, passing_marks
        FROM exam_subjects
        WHERE exam_id = $exam_id";
$result = mysqli_query($conn, $sql);
$subjects = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $subjects[] = $row;
    }
}
mysqli_free_result($result);

/* 2 ─── Class id from exam_schedule */
$sql = "SELECT class_id FROM exam_schedule WHERE exam_id = $exam_id LIMIT 1";
$result = mysqli_query($conn, $sql);
$class_id = 0;
if ($row = mysqli_fetch_assoc($result)) {
    $class_id = $row['class_id'];
}
mysqli_free_result($result);
if (!$class_id) { die('Exam not linked to any class'); }

/* 3 ─── Class name + division */
$sql = "SELECT class_name, division FROM classes WHERE class_id = $class_id LIMIT 1";
$result = mysqli_query($conn, $sql);
$class_name = $division = '';
if ($row = mysqli_fetch_assoc($result)) {
    $class_name = $row['class_name'];
    $division   = $row['division'];
}
mysqli_free_result($result);

/* 4 ─── Active students in that class/division */
$sql = "SELECT student_id, student_gr_no,
               CONCAT(student_surname, ' ', student_name, ' ', student_fathername) AS full_name
        FROM students
        WHERE student_class   = '".mysqli_real_escape_string($conn, $class_name)."'
          AND student_division = '".mysqli_real_escape_string($conn, $division)."'
          AND student_status   = 'Active'
        ORDER BY student_surname, student_name";
$result = mysqli_query($conn, $sql);
$students = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $students[] = $row;
    }
}
mysqli_free_result($result);

/* 5 ─── Existing marks for pre-fill */
$sql = "SELECT result_id, exam_subject_id, student_id,
               marks_obtained, status, remarks
        FROM exam_results
        WHERE exam_id = $exam_id";
$result = mysqli_query($conn, $sql);
$prefill = [];
if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        $prefill[$row['student_id']][$row['exam_subject_id']] = $row;
    }
}
mysqli_free_result($result);
?>
<!-- 6 ─── HTML grid -->
<div class="overflow-auto">
<form method="post">
    <input type="hidden" name="exam_id" value="<?= $exam_id ?>">
<table class="is-zebra w-full text-left">
  <thead>
    <tr>
      <th
        class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
      >
        #
      </th>
      <th
        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
      >
        Student Name
      </th>
      <th
        class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
      >
       Gr Number
      </th>
      <?php foreach ($subjects as $index => $s): ?>
        <th
          class="<?= $index === array_key_last($subjects) 
                      ? 'whitespace-nowrap rounded-r-lg' 
                      : 'whitespace-nowrap' ?> 
                 bg-slate-200 px-4 py-3 font-semibold uppercase 
                 text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
        >
          <?= htmlspecialchars($s['subject_name']) . ' (' . htmlspecialchars($s['passing_marks']) . '/' . htmlspecialchars($s['max_marks']) . ')' ?>
        </th>
      <?php endforeach; ?>
    </tr>
  </thead>
  <tbody>
    <?php 
    $rowIndex = 1;
    foreach ($students as $stu): ?>
      <tr>
        <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5">
          <?= $rowIndex++ ?>
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= htmlspecialchars($stu['full_name']) ?>
        </td>
        <td class="whitespace-nowrap px-4 py-3 sm:px-5">
          <?= htmlspecialchars($stu['student_gr_no']) ?>
        </td>
        <?php foreach ($subjects as $index => $s):
          $sid   = $s['exam_subject_id'];
          $uid   = $stu['student_id'];
          $cell  = $prefill[$uid][$sid] ?? [];
        ?>
        <td
          class="<?= $index === array_key_last($subjects) 
                      ? 'whitespace-nowrap rounded-r-lg' 
                      : 'whitespace-nowrap' ?> 
                 px-4 py-3 sm:px-5 text-center"
        >
          <!-- hidden id (for UPDATE) -->
          <input type="hidden"
                 name="results[<?= $uid ?>][<?= $sid ?>][result_id]"
                 value="<?= $cell['result_id'] ?? '' ?>">

          <!-- marks input -->
          <input type="number" step="0.01" min="0"
                 name="results[<?= $uid ?>][<?= $sid ?>][marks]"
                 value="<?= $cell['marks_obtained'] ?? '' ?>"
                 class="w-20 rounded-md border border-slate-300 px-2 py-1 text-center focus:border-blue-500 focus:ring focus:ring-blue-200 dark:border-navy-600 dark:bg-navy-700 dark:text-white">
        </td>
        <?php endforeach; ?>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
    <br>

  <div class="card mt-5">

  <button
    type="submit"
    class="btn space-x-2 bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
  >
    <span>Submit</span>
  </button>

</div>
</form>







<?php
/* ------------------------------------------------------------------
   save_results.php  (PROCEDURAL VERSION)
   ------------------------------------------------------------------
   – Expects POST with:
       • exam_id                       (int)
       • results[STUDENT_ID][SUBJECT_ID]
           └─ result_id   (may be empty → INSERT)
           └─ marks       (decimal)     (blank → ignore cell)
   – Uses $conn  (mysqli) from your config
   ------------------------------------------------------------------*/


// 1 ─── Basic validation
if ($_SERVER['REQUEST_METHOD'] == 'POST') {


$exam_id = (int)($_POST['exam_id'] ?? 0);
$results = $_POST['results'] ?? [];
if (!$exam_id || !$results) {
    exit('Missing payload');
}

// 2 ─── Loop through every cell
foreach ($results as $student_id => $subjects) {
    $student_id = (int)$student_id;

    foreach ($subjects as $subject_id => $payload) {
        $subject_id = (int)$subject_id;
        $marks      = trim($payload['marks'] ?? '');

        // Skip empty marks
        if ($marks === '') { continue; }

        $marks     = (float)$marks;
        $result_id = (int)($payload['result_id'] ?? 0);

        /* 2a ── Get subject details */
        $sql = "SELECT passing_marks, max_marks 
                  FROM exam_subjects 
                 WHERE exam_subject_id = $subject_id 
                 LIMIT 1";
        $res = mysqli_query($conn, $sql);
        $passing = $max_marks = 0;
        if ($row = mysqli_fetch_assoc($res)) {
            $passing   = (float)$row['passing_marks'];
            $max_marks = (float)$row['max_marks'];
        }
        mysqli_free_result($res);

        /* 2b ── Decide status */
        if ($marks === 0.0) {
            $status = 'absent';
        } elseif ($marks >= $passing) {
            $status = 'pass';
        } else {
            $status = 'fail';
        }

        /* 2c ── UPDATE or INSERT */
        if ($result_id) {
            // -- UPDATE existing result
            $sql = "UPDATE exam_results
                       SET marks_obtained = $marks,
                           max_marks = $max_marks,
                           status = '".mysqli_real_escape_string($conn, $status)."',
                           timestamp = NOW()
                     WHERE result_id = $result_id";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));

        } else {
            // -- INSERT new result
            // Fetch student GR number
            $sql_gr = "SELECT student_gr_no FROM students WHERE student_id = $student_id LIMIT 1";
            $res_gr = mysqli_query($conn, $sql_gr);
            $student_gr_no = '';
            if ($row = mysqli_fetch_assoc($res_gr)) {
                $student_gr_no = $row['student_gr_no'];
            }
            mysqli_free_result($res_gr);

            $sql = "INSERT INTO exam_results
                        (exam_id, exam_subject_id, student_id, student_gr_no,
                         marks_obtained, max_marks, status, timestamp)
                    VALUES
                        ($exam_id, $subject_id, $student_id, '".mysqli_real_escape_string($conn, $student_gr_no)."',
                         $marks, $max_marks, '".mysqli_real_escape_string($conn, $status)."', NOW())";
            mysqli_query($conn, $sql) or die(mysqli_error($conn));
        }
    }
}
}
// 3 ─── Redirect back

?>




  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>