<?php

require_once "core/db-connect91.php";



if (!isset($_SESSION['invoice_data'])) {
    die("No invoice data found.");
}

$invoice = $_SESSION['invoice_data'];

// Optional: clear invoice data after printing to avoid reprints
unset($_SESSION['invoice_data']);

$student_id = $invoice['student_id'];
$semester = $invoice['semester'];
$batch = $invoice['batch'];
$payment_id = $invoice['payment_id'];


// Assuming you already have $conn (mysqli connection)

// Inputs

if ($student_id && $semester && $batch && $payment_id) {

    // 1. Get student details
    $student_sql = "SELECT * FROM students WHERE student_id = ?";
    $stmt = $conn->prepare($student_sql);
    $stmt->bind_param("i", $student_id);
    $stmt->execute();
    $student_result = $stmt->get_result();
    $student_data = $student_result->fetch_assoc();

    if ($student_data) {
        $student_class    = $student_data['student_class'];
        $student_division = $student_data['student_division'];

        // 2. Get class_id from classes
        $class_sql = "SELECT class_id FROM classes WHERE class_name = ? AND division = ?";
        $stmt = $conn->prepare($class_sql);
        $stmt->bind_param("ss", $student_class, $student_division);
        $stmt->execute();
        $class_result = $stmt->get_result();
        $class_row = $class_result->fetch_assoc();
        $class_id = $class_row['class_id'] ?? null;

        // 3. Get fee structure

$fee_structure_data = [];
if ($class_id) {
    $fee_structure_sql = "SELECT * FROM fee_structure WHERE class_id = ? AND semester = ? AND batch = ?";
    $stmt = $conn->prepare($fee_structure_sql);
    $stmt->bind_param("iss", $class_id, $semester, $batch);
    $stmt->execute();
    $fee_structure_data = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}




        // 4. Get fee payment history by payment_id
        $payment_history_sql = "SELECT * FROM fee_payment_history WHERE payment_number = ?";
        $stmt = $conn->prepare($payment_history_sql);
        $stmt->bind_param("s", $payment_id);
        $stmt->execute();
        $payment_history_data = $stmt->get_result()->fetch_assoc();

        // 5. Get student fees
        $student_fees_sql = "SELECT * FROM student_fees WHERE student_id = ? AND semester = ? AND batch = ?";
        $stmt = $conn->prepare($student_fees_sql);
        $stmt->bind_param("iss", $student_id, $semester, $batch);
        $stmt->execute();
        $student_fees_data = $stmt->get_result()->fetch_assoc();

        // Now you have:
        // $student_data        -> Student details
        // $class_id            -> Class ID
        // $fee_structure_data  -> Fee structure array
        // $payment_history_data-> Payment history row
        // $student_fees_data   -> Student fees row

    } else {
        echo "Student not found.";
    }
} else {
    echo "Missing required parameters.";
}



?>

    
<style>
    @media print {
        body, html {
            margin: 0 !important;
            padding: 0 !important;
            font-size: 12px;
            -webkit-print-color-adjust: exact;
        }

        @page {
            size: A4 portrait;
            margin: 10mm;
        }

        .no-print, button {
            display: none !important;
        }

        .invoice-container,
        .header,
        .invoice-info,
        .client-info,
        .payment-info,
        .total-section,
        .terms,
        table,
        tr,
        td,
        th {
            page-break-inside: avoid !important;
            break-inside: avoid !important;
        }
    }

    body {
        font-family: 'Arial', sans-serif;
        background-color: #f8f9fa;
        margin: 0;
        padding: 5px;
    }

    .invoice-container {
        max-width: 800px;
        background: #fff;
        padding: 25px;
        border-radius: 10px;
        box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        margin: auto;
        border-top: 5px solid #007bff;
    }

    .header {
        text-align: center;
        padding-bottom: 20px;
        border-bottom: 3px solid #ddd;
    }

    .header h2 {
        margin: 0;
        color: #007bff;
        font-size: 30px;
    }

    .invoice-info, .client-info {
        display: flex;
        justify-content: space-between;
        padding: 15px 0;
        border-bottom: 2px solid #ddd;
    }

    .invoice-info div, .client-info div {
        width: 48%;
    }

    .invoice-info p, .client-info p {
        margin: 5px 0;
        color: #333;
        font-size: 18px;
    }

    .table-container {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }

    .table-container th {
        background: #007bff;
        color: white;
        padding: 10px;
        text-align: center;
    }

    .table-container td {
        border: 1px solid #ddd;
        padding: 10px;
        text-align: center;
        font-size: 18px;
    }

    .table-container tbody tr:nth-child(even) {
        background: #f8f9fa;
    }

    .payment-info {
        margin-top: 20px;
        padding: 12px;
        background: #eef4ff;
        border-radius: 8px;
        font-weight: bold;
        color: #333;
    }

    .total-section {
        display: flex;
        justify-content: space-between;
        margin-top: 20px;
        padding: 12px;
        background: #007bff;
        color: white;
        font-weight: bold;
        border-radius: 8px;
    }

    .terms {
        margin-top: 20px;
        font-size: 10px;
        color: #666;
    }

    .terms strong {
        color: #333;
    }

    .no-print {
        text-align: right;
        margin-bottom: 20px;
    }

    .no-print button {
        padding: 10px 20px;
        font-size: 18px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }
</style>
</head>
<body>

    <div class="invoice-container">
        <div class="header">
            <h2>INVOICE</h2>
            <p>Invoice No: #<?php echo $payment_id; ?></p>
            <p>Date: <?php echo $payment_history_data['payment_received_date']; ?></p>
        </div>

        <div class="invoice-info">
            <div>
                <h3>Invoice To:</h3>
                <p><strong><?php echo $student_data['student_surname'] . $student_data['student_name'] . $student_data['student_fathername']; ?></strong></p>
                <p><?php echo $student_data['student_class'] . $student_data['student_division']; ?></p>
                <p><?php echo $student_data['student_phonenumber']; ?></p>
                <p><?php echo $student_data['student_address']; ?></p>
            </div>
            <div>
                <h3>Seller Info:</h3>
                <p><strong>School Evolution</strong></p>
                <p>86- ram nagar station</p>
                <p>Phone: +91 93923 82834</p>
                <p>Email: demo@gmail.com</p>
            </div>
        </div>

<?php
// Print table
if (!empty($fee_structure_data)) {
    echo "<table class='table-container'>";
    echo "<thead><tr>
            <th>Sr No</th>
            <th>Fee Type</th>
            <th>Fee Amount</th>
          </tr></thead><tbody>";
    $srno = 1;
    foreach ($fee_structure_data as $row) {
        echo "<tr>
                <td>{$srno}</td>
                <td>{$row['fee_type']}</td>
                <td>" . number_format($row['amount'], 2) . "</td>
              </tr>";
        $srno++;
    }
    echo "</tbody></table>";
} else {
    echo "No fee structure found for this class.";
}

// Fetch fee structure for given class_id
if($switchstatus['print_fee_history_invoice'] == 1){
// Print table
// Fetch payment history for this student & batch, grouped by semester
$payment_history_sql2 = "
    SELECT payment_number, semester, payment_amount, due_amount, total_amount
    FROM fee_payment_history
    WHERE batch = ? AND student_id = ?
    ORDER BY semester ASC, payment_received_date ASC
";
$stmt2 = $conn->prepare($payment_history_sql2);
$stmt2->bind_param("si", $batch, $student_id);
$stmt2->execute();
$result2 = $stmt2->get_result();
$payment_history_data2 = $result2->fetch_all(MYSQLI_ASSOC);

if (!empty($payment_history_data2)) {
    $current_semester = null;
    $srno = 1;
    $semester_total = 0;

    foreach ($payment_history_data2 as $index => $row2) {
        // Start a new table when semester changes
        if ($current_semester !== $row2['semester']) {
            // Close previous semester table if not first
            if ($current_semester !== null) {
                echo "<tr style='font-weight:bold; background:#eef4ff;'>
                        <td colspan='3' style='text-align:right;'>Total Paid (Semester {$current_semester}):</td>
                        <td>" . number_format($semester_total, 2) . "</td>
                        <td colspan='2'></td>
                      </tr>";
                echo "</tbody></table><br>";
            }

            // Reset counters for new semester
            $current_semester = $row2['semester'];
            $srno = 1;
            $semester_total = 0;

            // Table header
            echo "<h3>Semester {$current_semester}</h3>";
            echo "<table class='table-container'>";
            echo "<thead>
                    <tr>
                        <th>Sr No</th>
                        <th>Payment Number</th>
                        <th>Semester</th>
                        <th>Payment Amount</th>
                        <th>Due Amount</th>
                        <th>Total Amount</th>
                    </tr>
                  </thead>
                  <tbody>";
        }

        // Table row
        echo "<tr>
                <td>{$srno}</td>
                <td>{$row2['payment_number']}</td>
                <td>{$row2['semester']}</td>
                <td>" . number_format($row2['payment_amount'], 2) . "</td>
                <td>" . number_format($row2['due_amount'], 2) . "</td>
                <td>" . number_format($row2['total_amount'], 2) . "</td>
              </tr>";

        $srno++;
        $semester_total += $row2['payment_amount'];

        // Close the last semester table at the end
        if ($index === array_key_last($payment_history_data2)) {
            echo "<tr style='font-weight:bold; background:#eef4ff;'>
                    <td colspan='3' style='text-align:right;'>Total Paid (Semester {$current_semester}):</td>
                    <td>" . number_format($semester_total, 2) . "</td>
                    <td colspan='2'></td>
                  </tr>";
            echo "</tbody></table>";
        }
    }

}else {


}
}
// Fetch fee structure for given class_id

?>


        <div class="payment-info">
            <p>Payment Method: <strong><?php echo $payment_history_data['payment_method']; ?></strong></p>
            <p>Paid Amount: <strong><?php echo $payment_history_data['payment_amount']; ?></strong></p>
        </div>

        <div class="total-section">
            <div>Total: <strong><?php echo $payment_history_data['total_amount']; ?></strong></div>
            <div>Due: <strong><?php echo $student_fees_data['balance_amount']; ?></strong></div>
        </div>

        <div class="terms">
            <p><strong>Terms & Conditions:</strong></p>
            <p>School Evolution T&C Apply Visit T&C Page</p>

        </div>
    </div><br>
    <center>
<div style="text-align: center; margin-bottom: 20px;" class="no-print">
    <button onclick="window.print()" style="width:80%; font-size: 14px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
        Print Invoice
    </button>
</div>
<br><br>
<div style="text-align: center; margin-bottom: 20px;" class="no-print">
    <a href="../admin-dashboard.php" ><button style="width:80%; font-size: 14px; background-color: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
        Go To HomePage
    </button></a>
</div>
</center>
