<?php
require('../../library/tcpdf/tcpdf.php');
require_once "../core/db-connect91.php";
$studentid = $_POST['studentid'];
$class     = $_POST['class'];
$division  = $_POST['division'];
$months    = $_POST['months']; // Make sure this is sent as an array from the form
$postbatch      = $_POST['batch'];

$presentc  = $_POST['presentc']; // green
$absentc   = $_POST['absentc'];  // red
$holidayc  = $_POST['holidayc']; // grey
$halfdayc  = $_POST['halfdayc']; // orange
$colored = isset($_POST['colored']) ? true : false;

$academicMonths = [
    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
    5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
    9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
];

// Fetch attendance data & student list
$attendanceData = [];
$students = [];



foreach ($months as $month) {


$query = "SELECT student_id, student_gr_no, day, status
          FROM student_attendance
          WHERE student_id = ? AND class = ? AND division = ? AND month = ? AND batch = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "issii", $studentid, $class, $division, $month, $postbatch);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    while ($row = mysqli_fetch_assoc($result)) {
        $attendanceData[$month][$row['day']][$row['student_id']] = $row['status'];

        // Save student details if not already added
        if (!isset($students[$row['student_id']])) {
            $students[$row['student_id']] = [
                'id' => $row['student_id'],
                'gr_no' => $row['student_gr_no']
            ];
        }
    }
}

// Sort by student ID (or you can use GR No if needed)
usort($students, function ($a, $b) {
    return $a['id'] - $b['id'];
});

// Initialize TCPDF
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('School Evolution');
$pdf->SetTitle('Attendance Report');
$pdf->SetHeaderData('', 0, 'Attendance Report', 'Generated by School Evolution');
$pdf->setHeaderFont(['helvetica', '', 10]);
$pdf->setFooterFont(['helvetica', '', 8]);

// ===== PAGE 1: Student Details =====
$pdf->AddPage();
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'Student Details - Class ' . $class . ' - Division ' . $division, 0, 1, 'C');
$pdf->Ln(5);

// Table header
$html = '<table border="1" cellspacing="0" cellpadding="5">
<tr style="background-color:#f2f2f2; text-align:center;">
    <th>GR No</th>
    <th>Admission No</th>
    <th>Surname</th>
    <th>Name</th>
    <th>Father\'s Name</th>
    <th>Gender</th>
    <th>Phone</th>
    <th>Birthdate</th>
</tr>';

// Loop through students array
foreach ($students as $stu) {
    $html .= '<tr>
        <td>' . htmlspecialchars($stu['student_gr_no']) . '</td>
        <td>' . htmlspecialchars($stu['student_admission_no']) . '</td>
        <td>' . htmlspecialchars($stu['student_surname']) . '</td>
        <td>' . htmlspecialchars($stu['student_name']) . '</td>
        <td>' . htmlspecialchars($stu['student_fathername']) . '</td>
        <td>' . htmlspecialchars($stu['student_gender']) . '</td>
        <td>' . htmlspecialchars($stu['student_phonenumber']) . '</td>
        <td>' . htmlspecialchars($stu['student_birthdate']) . '</td>
    </tr>';
}

$html .= '</table>';

// Print student table
$pdf->SetFont('helvetica', '', 10);
$pdf->writeHTML($html, true, false, true, false, '');

// ===== PAGE 2 onwards: Attendance =====
$pdf->AddPage();
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'Attendance Report for Class ' . $class . ' - Division ' . $division, 0, 1, 'C');
$pdf->Ln(5);

foreach ($months as $month) {
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, $academicMonths[$month] . ' ' . $year, 0, 1, 'C');
    $pdf->Ln(3);

    $html = '<table border="1" cellspacing="0" cellpadding="5">';
    $html .= '<tr><th>Day</th>';

    // Table headers
    foreach ($students as $student) {
        $html .= '<th>ID: ' . htmlspecialchars($student['student_id']) . '<br>GR: ' . htmlspecialchars($student['student_gr_no']) . '</th>';
    }
    $html .= '</tr>';

    for ($day = 1; $day <= 31; $day++) {
        $html .= '<tr><td>' . $day . '</td>';
        foreach ($students as $student) {
            $status = $attendanceData[$month][$day][$student['student_id']] ?? 'holiday';

            if ($status == 'present') {
                $cellContent = 'P';
                $color = $presentc;
            } elseif ($status == 'absent') {
                $cellContent = 'F';
                $color = $absentc;
            } elseif ($status == 'half_day') {
                $cellContent = 'HD';
                $color = $halfdayc;
            } else {
                $cellContent = 'H';
                $color = $holidayc;
            }

            if ($colored) {
                $html .= '<td style="background-color:' . $color . '; text-align:center;">' . $cellContent . '</td>';
            } else {
                $html .= '<td style="text-align:center;">' . $cellContent . '</td>';
            }
        }
        $html .= '</tr>';
    }

    $html .= '</table><br>';

    $pdf->SetFont('helvetica', '', 10);
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Ln(5);
}



$pdf->Output('attendance_report.pdf', 'D');
exit();
?>
