<?php
// generate_pdf.php
require_once "core/db-connect91.php";
require_once '../library/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

function safe_int($v){ return (int)$v; }

/*$post = [
    "class_id" => 1,
    "subject_id" => 1,
    "language_code" => "gu",
    "include_answers" => 1,
    "marks_count" => ["1" => 5, "2" => 10, "3" => 15],
    "syllabus_ids" => [1, 1, 1]
];*/
$post = $_POST;
// required fields
$class_id = safe_int($post['class_id'] ?? 0);
$subject_id = safe_int($post['subject_id'] ?? 0);
$language_code = trim($post['language_code'] ?? 'gu');
$include_answers = isset($post['include_answers']) ? 1 : 0;
$marks_count = $post['marks_count'] ?? [];
$syllabus_ids = $post['syllabus_ids'] ?? [];

if ($class_id <= 0 || $subject_id <= 0) {
    error_log("generate_pdf: missing class or subject");
    die("Missing class or subject selection.");
}

// compute total marks expected
$total_expected = 0;
foreach ($marks_count as $mark => $count) {
    $m = safe_int($mark);
    $c = safe_int($count);
    $total_expected += $m * $c;
}
if ($total_expected !== 100) {
    error_log("generate_pdf: total_expected != 100 (got {$total_expected}) for class {$class_id} subject {$subject_id}");
}

// build WHERE clause for syllabus
$syllabus_where = '';
if (!empty($syllabus_ids) && is_array($syllabus_ids)) {
    $ids = array_map('intval', $syllabus_ids);
    $ids = array_filter($ids, function($v){ return $v>0; });
    if (!empty($ids)) {
        $in = implode(',', $ids);
        $syllabus_where = " AND syllabus_id IN ($in) ";
    }
}

// fetch questions
$final_questions = [];
foreach ($marks_count as $mark => $count) {
    $mark = safe_int($mark);
    $count = safe_int($count);
    if ($count <= 0) continue;

    $sql = "SELECT id, question, answer, marks FROM questions_answers 
            WHERE class_name = " . (int)$class_id . " 
            AND subject_id = " . (int)$subject_id . " 
            AND marks = " . (int)$mark . " 
            AND language_code = '" . mysqli_real_escape_string($conn, $language_code) . "' $syllabus_where
            ORDER BY RAND() LIMIT " . (int)$count;

    $res = mysqli_query($conn, $sql);
    if (!$res) {
        error_log("query error: " . mysqli_error($conn) . " SQL: $sql");
        continue;
    }
    while ($row = mysqli_fetch_assoc($res)) {
        $final_questions[] = $row;
    }
}

if (empty($final_questions)) {
    error_log("generate_pdf: no questions found for class {$class_id}, subject {$subject_id}, language {$language_code}");
    die("No questions found for the selected options. Check your data.");
}

// header & body HTML
$school_name = htmlspecialchars(trim($post['school_name'] ?? ''));
$school_address = htmlspecialchars(trim($post['school_address'] ?? ''));
$instructions = htmlspecialchars(trim($post['instructions'] ?? ''));

// absolute font path
$fontPath = realpath(__DIR__ . '/../fonts/NotoSansGujarati-Regular.ttf');

$header_html = '
<style>
@font-face {
    font-family: "NotoSansGujarati";
    src: url("file://'.$fontPath.'") format("truetype");
}
body { font-family: "NotoSansGujarati", sans-serif; font-size:14px; }
</style>

<div class="header" style="text-align:center; margin-bottom:10px;">
  <div style="display:flex;align-items:center;justify-content:space-between;">
    <div style="width:120px;"><img src="" alt="" style="height:70px;"/></div>
    <div style="flex:1;">
      <h2 style="margin:0;">' . ($school_name ?: 'SCHOOL NAME') . '</h2>
      <div style="font-size:12px;">' . ($school_address ?: '') . '</div>
    </div>
    <div style="width:120px;text-align:right;"> <div style="font-size:12px;">Date: ' . date('d-m-Y') . '</div></div>
  </div>
  <hr style="margin-top:12px;border:none;border-top:1px solid #000;" />
  <div style="text-align:left;margin-top:8px;font-weight:700;">Instructions: ' . ($instructions ?: '') . '</div>
</div>
';

$body_html = '<div class="paper">';
$qno = 1;
foreach ($final_questions as $q) {
    $question_html = nl2br($q['question']); // removed htmlspecialchars
    $answer_html = nl2br($q['answer']);     // removed htmlspecialchars
    $marks = (int)$q['marks'];
    $body_html .= '<div class="question" style="margin-top:12px;">';
    $body_html .= '<div style="float:right;font-weight:600;margin-left:8px;">(' . $marks . ')</div>';
    $body_html .= '<div style="clear:both;padding-right:60px;"><strong>' . $qno . '.</strong> ' . $question_html . '</div>';
    if ($include_answers) {
        $body_html .= '<div style="margin-top:6px;padding-left:18px;color:#222;"><em>Answer:</em><div style="margin-top:4px;">' . $answer_html . '</div></div>';
    } else {
        $spaceLines = $marks <= 2 ? 2 : ($marks == 3 ? 4 : 8);
        $body_html .= '<div style="margin-top:8px;">';
        for ($i=0;$i<$spaceLines;$i++){
            $body_html .= '<div style="height:18px;border-bottom:1px dotted #ddd;margin-bottom:6px;"></div>';
        }
        $body_html .= '</div>';
    }
    $body_html .= '</div>';
    $qno++;
}
$body_html .= '</div>';

$header_html = '
<div style="text-align:center; margin-bottom:10px;">
    <h2>' . $school_name . '</h2>
    <div style="font-size:12px;">' . $school_address . '</div>
    <hr style="margin:10px 0;" />
    <div><strong>Instructions:</strong> ' . $instructions . '</div>
</div>
';

$body_html = '<div class="paper">';
$qno = 1;
foreach ($final_questions as $q) {
    $body_html .= '<div style="margin-top:12px;">';
    $body_html .= '<strong>' . $qno . '.</strong> ' . nl2br($q['question']);
    if ($include_answers) {
        $body_html .= '<div style="margin-left:20px; color:#222;"><em>Answer:</em> ' . nl2br($q['answer']) . '</div>';
    }
    $body_html .= '</div>';
    $qno++;
}
$body_html .= '</div>';

$html = '
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<style>
@font-face {
    font-family: "NotoSansGujarati";
    src: url("' . $fontUrl . '") format("truetype");
}
body { font-family: "NotoSansGujarati", sans-serif; font-size:14px; }
.paper { padding:10px 20px; }
</style>
</head>
<body>
' . $header_html . $body_html . '
</body>
</html>
';
// Generate PDF
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('defaultFont', 'NotoSansGujarati'); 
$options->set('isHtml5ParserEnabled', true);

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// Stream PDF
$filename = 'question_paper_' . time() . '.pdf';
$dompdf->stream($filename, ["Attachment" => false]); 
exit;
?>