<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once '../library/dompdf/vendor/autoload.php'; // Required for PDF (dompdf) and XLSX (PhpSpreadsheet)
use Dompdf\Dompdf;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

require_once "core/db-connect91.php";


// Example: Exporting results with student info
$columns = $_POST['columns'] ?? [];
$format = $_POST['format'] ?? '';
$table = $_POST['table'] ?? '';
$joinTable = $_POST['join_table'] ?? ''; // e.g., 'students'
$joinColumn = $_POST['join_column'] ?? ''; // e.g., 'student_id'
$mainColumn = $_POST['main_column'] ?? ''; // column in $table to join on

if (empty($columns) || empty($format)) {
    die("Please select columns and format.");
}

$columnsList = implode(",", array_map(function($col) {
    if (strpos($col, '.') !== false) {
        // Split table.column
        list($tableName, $columnName) = explode('.', $col);
        return "`$tableName`.`$columnName`";
    }
    return "`$col`";
}, $columns));


$from = isset($_POST['from_id']) && is_numeric($_POST['from_id']) ? (int)$_POST['from_id'] : null;
$to   = isset($_POST['to_id']) && is_numeric($_POST['to_id']) ? (int)$_POST['to_id'] : null;

// Build JOIN query if join table is provided
if (!empty($joinTable) && !empty($joinColumn) && !empty($mainColumn)) {
    $query = "SELECT $columnsList 
              FROM `$table` 
              LEFT JOIN `$joinTable` 
              ON `$table`.`$mainColumn` = `$joinTable`.`$joinColumn`";
} else {
    $query = "SELECT $columnsList FROM `$table`";
}

// Add WHERE clause if from/to is set
if ($from !== null && $to !== null) {
    $query .= " WHERE `$table`.`$mainColumn` BETWEEN $from AND $to";
} elseif ($from !== null) {
    $query .= " WHERE `$table`.`$mainColumn` >= $from";
} elseif ($to !== null) {
    $query .= " WHERE `$table`.`$mainColumn` <= $to";
}

// Now $query is ready to execute
$result = $conn->query($query);
if (!$result) {
    die("Query failed: " . $conn->error . "<br>SQL: " . $query);
}



// Fetch results
$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}



// -------- Export according to format -------- //
switch ($format) {
    case 'csv':
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="export.csv"');
        $f = fopen('php://output', 'w');
        fputcsv($f, $columns); // headers
        foreach ($data as $row) {
            fputcsv($f, $row);
        }
        fclose($f);
        break;

    case 'txt':
        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename="export.txt"');
        echo implode("\t", $columns) . "\n";
        foreach ($data as $row) {
            echo implode("\t", $row) . "\n";
        }
        break;

    case 'xlsx':
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->fromArray([$columns], NULL, 'A1');
        $sheet->fromArray($data, NULL, 'A2');
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="export.xlsx"');
        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        break;

case 'pdf':
    $html = "
    <html>
    <head>
        <style>
            @page {
                margin: 20px;
            }
            body {
                font-family: DejaVu Sans, sans-serif;
                font-size: 10pt;
            }
            h2 {
                text-align: center;
                margin-bottom: 10px;
            }
            table {
                border-collapse: collapse;
                width: 100%;
                table-layout: fixed;
                word-wrap: break-word;
            }
            th, td {
                border: 1px solid #000;
                padding: 5px;
                text-align: left;
                font-size: 9pt;
            }
            th {
                background-color: #f2f2f2;
                font-weight: bold;
            }
            thead {
                display: table-header-group; /* repeat header on each page */
            }
            tr:nth-child(even) {
                background-color: #f9f9f9;
            }
        </style>
    </head>
    <body>
        <h2>Exported Data</h2>
        <table>
            <thead>
                <tr>";

    foreach ($columns as $col) {
        $html .= "<th>" . htmlspecialchars($col) . "</th>";
    }

    $html .= "</tr></thead><tbody>";

    foreach ($data as $row) {
        $html .= "<tr>";
        foreach ($row as $cell) {
            $html .= "<td>" . htmlspecialchars($cell) . "</td>";
        }
        $html .= "</tr>";
    }

    $html .= "</tbody></table></body></html>";

    $dompdf = new Dompdf();
    $dompdf->setPaper('A4', 'landscape'); // landscape for wide tables
    $dompdf->loadHtml($html);
    $dompdf->render();
    $dompdf->stream("export.pdf", ["Attachment" => true]);
    break;

    default:
        echo "Unsupported format.";
}
?>