<?php
require_once '../core/db-connect91.php'; // adjust path as needed
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

$staff_id = $_POST['staff_id'] ?? '';
$subject_name = $_POST['subject_name'] ?? '';
$action = $_POST['action'] ?? '';

if (!$staff_id || !$subject_name || !in_array($action, ['add', 'remove'])) {
    echo json_encode(['success' => false, 'message' => 'Missing or invalid parameters.']);
    exit;
}

// Sanitize inputs
$staff_id = (int)$staff_id;
$subject_name = $conn->real_escape_string($subject_name);

// Set allotter ID — replace this with actual logged-in user id
$alloted_by = 1;

if ($action === 'add') {
    // Insert allotment if not exists
    $stmt = $conn->prepare("INSERT INTO teacher_subject_allotment (staff_id, subject_name, alloted_by) VALUES (?, ?, ?)");
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Prepare failed: ' . $conn->error]);
        exit;
    }
    $stmt->bind_param("isi", $staff_id, $subject_name, $alloted_by);
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        // Check if duplicate entry error (ignore if already exists)
        if ($conn->errno === 1062) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Insert failed: ' . $conn->error]);
        }
    }
    $stmt->close();
} else {
    // Remove allotment
    $stmt = $conn->prepare("DELETE FROM teacher_subject_allotment WHERE staff_id = ? AND subject_name = ?");
    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Prepare failed: ' . $conn->error]);
        exit;
    }
    $stmt->bind_param("is", $staff_id, $subject_name);
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Delete failed: ' . $conn->error]);
    }
    $stmt->close();
}

?>