<?php
require('../../../library/tcpdf/tcpdf.php');
require_once "../core/db-connect91.php";

$studentid = $_POST['studentid'];
$class     = $_POST['class'];
$division  = $_POST['division'];
$months    = $_POST['months']; // array from form
$postbatch = $_POST['batch'];

$presentc  = $_POST['presentc']; // green
$absentc   = $_POST['absentc'];  // red
$holidayc  = $_POST['holidayc']; // grey
$halfdayc  = $_POST['halfdayc']; // orange
$colored   = isset($_POST['colored']) ? true : false;

$academicMonths = [
    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
    5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
    9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
];

// 🔹 Fetch student details
$studentInfo = [];
$query = "SELECT * FROM students WHERE student_id = ?";
$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $studentid);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
if ($row = mysqli_fetch_assoc($result)) {
    $studentInfo = $row;
}

// 🔹 Fetch attendance data
$attendanceData = [];
$students = [];

foreach ($months as $month) {
    $query = "SELECT student_id, student_gr_no, day, status
              FROM student_attendance
              WHERE student_id = ? AND class = ? AND division = ? AND month = ? AND batch = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "issii", $studentid, $class, $division, $month, $postbatch);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    while ($row = mysqli_fetch_assoc($result)) {
        $attendanceData[$month][$row['day']][$row['student_id']] = $row['status'];
        if (!isset($students[$row['student_id']])) {
            $students[$row['student_id']] = [
                'id'    => $row['student_id'],
                'gr_no' => $row['student_gr_no']
            ];
        }
    }
}

usort($students, function ($a, $b) {
    return $a['id'] - $b['id'];
});

// 🔹 Initialize PDF
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('School Evolution');
$pdf->SetTitle('Attendance Report');
$pdf->SetHeaderData('', 0, 'Attendance Report', 'Generated by School Evolution');
$pdf->setHeaderFont(['helvetica', '', 10]);
$pdf->setFooterFont(['helvetica', '', 8]);
$pdf->AddPage();

// 🔹 Main title
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'Attendance Report for Class ' . $class . ' - Division ' . $division, 0, 1, 'C');
$pdf->Ln(5);

// 🔹 Student Information
$pdf->SetFont('helvetica', '', 11);
$studentHTML = '<h3>Student Information</h3>
<table border="1" cellpadding="5">
<tr><td><b>Name</b></td><td>' . htmlspecialchars($studentInfo['student_surname'] . ' ' . $studentInfo['student_name'] . ' ' . $studentInfo['student_fathername']) . '</td></tr>
<tr><td><b>GR No</b></td><td>' . htmlspecialchars($studentInfo['student_gr_no']) . '</td></tr>
<tr><td><b>Admission No</b></td><td>' . htmlspecialchars($studentInfo['student_admission_no']) . '</td></tr>
<tr><td><b>Gender</b></td><td>' . htmlspecialchars($studentInfo['student_gender']) . '</td></tr>
<tr><td><b>Birthdate</b></td><td>' . htmlspecialchars($studentInfo['student_birthdate']) . '</td></tr>
<tr><td><b>Phone</b></td><td>' . htmlspecialchars($studentInfo['student_phonenumber']) . '</td></tr>
<tr><td><b>Email</b></td><td>' . htmlspecialchars($studentInfo['student_email']) . '</td></tr>
<tr><td><b>Address</b></td><td>' . htmlspecialchars($studentInfo['student_address']) . '</td></tr>
</table><br>';
$pdf->writeHTML($studentHTML, true, false, true, false, '');

// 🔹 Attendance tables
foreach ($months as $month) {
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, $academicMonths[$month] . ' ' . date('Y'), 0, 1, 'C');
    $pdf->Ln(3);

    $html = '<table border="1" cellspacing="0" cellpadding="5">';
    $html .= '<tr><th>Day</th>';
    foreach ($students as $student) {
        $html .= '<th>ID: ' . htmlspecialchars($student['id']) . '<br>GR: ' . htmlspecialchars($student['gr_no']) . '</th>';
    }
    $html .= '</tr>';

    for ($day = 1; $day <= 31; $day++) {
        $html .= '<tr><td>' . $day . '</td>';
        foreach ($students as $student) {
            $status = $attendanceData[$month][$day][$student['id']] ?? 'holiday';
            if ($status == 'present') {
                $cellContent = 'P'; $color = $presentc;
            } elseif ($status == 'absent') {
                $cellContent = 'F'; $color = $absentc;
            } elseif ($status == 'half_day') {
                $cellContent = 'HD'; $color = $halfdayc;
            } else {
                $cellContent = 'H'; $color = $holidayc;
            }
            if ($colored) {
                $html .= '<td style="background-color:' . $color . '; text-align:center;">' . $cellContent . '</td>';
            } else {
                $html .= '<td style="text-align:center;">' . $cellContent . '</td>';
            }
        }
        $html .= '</tr>';
    }
    $html .= '</table><br>';

    $pdf->SetFont('helvetica', '', 10);
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Ln(5);
}

$pdf->Output('attendance_report.pdf', 'D');
exit();
?>
 