<?php
require('../../../library/tcpdf/tcpdf.php');
require_once "../core/db-connect91.php";

if (isset($_POST['class_id'])) {
    $class_id = intval($_POST['class_id']);

    $sql = "SELECT class_name, division FROM classes WHERE class_id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $class_id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    if ($row = mysqli_fetch_assoc($result)) {
        $class = $row['class_name'];
        $division = $row['division'];
    } else {
        echo "Invalid Class ID";
        exit;
    }
} else {
    echo "Class ID not provided.";
    exit;
}

$months    = $_POST['months'];
$postbatch = $_POST['batch'];

$presentc  = $_POST['presentc'];
$absentc   = $_POST['absentc'];
$holidayc  = $_POST['holidayc'];
$halfdayc  = $_POST['halfdayc'];
$colored   = isset($_POST['colored']) ? true : false;

$academicMonths = [
    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
    5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
    9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
];

$attendanceData = [];
$students = [];

foreach ($months as $month) {
    $query = "SELECT sa.student_id, s.student_gr_no, sa.day, sa.status
              FROM student_attendance sa
              JOIN students s ON sa.student_id = s.student_id
              WHERE sa.class = ? AND sa.division = ? AND sa.month = ? AND sa.batch = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "ssii", $class, $division, $month, $postbatch);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);

    while ($row = mysqli_fetch_assoc($result)) {
        $attendanceData[$month][$row['day']][$row['student_id']] = $row['status'];

        if (!isset($students[$row['student_id']])) {
            // Fetch roll number
            $rollQuery = "SELECT roll_number 
                          FROM student_roll_numbers 
                          WHERE student_id = ? AND batch = ? 
                          LIMIT 1";
            $rollStmt = mysqli_prepare($conn, $rollQuery);
            mysqli_stmt_bind_param($rollStmt, "ii", $row['student_id'], $postbatch);
            mysqli_stmt_execute($rollStmt);
            $rollResult = mysqli_stmt_get_result($rollStmt);

            $rollNumber = "";
            if ($rollRow = mysqli_fetch_assoc($rollResult)) {
                $rollNumber = $rollRow['roll_number'];
            }

            // Fetch student name details
            $nameQuery = "SELECT student_surname, student_name, student_fathername 
                          FROM students 
                          WHERE student_id = ? LIMIT 1";
            $nameStmt = mysqli_prepare($conn, $nameQuery);
            mysqli_stmt_bind_param($nameStmt, "i", $row['student_id']);
            mysqli_stmt_execute($nameStmt);
            $nameResult = mysqli_stmt_get_result($nameStmt);
            $nameData = mysqli_fetch_assoc($nameResult);

            $students[$row['student_id']] = [
                'id'         => $row['student_id'],
                'gr_no'      => $row['student_gr_no'],
                'roll_no'    => $rollNumber,
                'surname'    => $nameData['student_surname'] ?? '',
                'name'       => $nameData['student_name'] ?? '',
                'fathername' => $nameData['student_fathername'] ?? ''
            ];
        }
    }
}

usort($students, function ($a, $b) {
    return $a['roll_no'] - $b['roll_no'];
});

// Initialize TCPDF
$pdf = new TCPDF();
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('School Evolution');
$pdf->SetTitle('Attendance Report');
$pdf->SetHeaderData('', 0, 'Attendance Report', 'Generated by School Evolution');
$pdf->setHeaderFont(['helvetica', '', 10]);
$pdf->setFooterFont(['helvetica', '', 8]);

// ----------------- FIRST PAGE: STUDENT DETAILS -----------------
$pdf->AddPage();
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'Student Details - Class ' . $class . ' - Division ' . $division, 0, 1, 'C');
$pdf->Ln(5);

$html = '<table border="1" cellpadding="5" cellspacing="0">
<tr style="background-color:#f2f2f2; font-weight:bold;">
    <th>GR No</th>
    <th>Roll No</th>
    <th>Surname</th>
    <th>Name</th>
    <th>Father Name</th>
</tr>';

foreach ($students as $student) {
    $html .= '<tr>
        <td>' . htmlspecialchars($student['gr_no']) . '</td>
        <td>' . htmlspecialchars($student['roll_no']) . '</td>
        <td>' . htmlspecialchars($student['surname']) . '</td>
        <td>' . htmlspecialchars($student['name']) . '</td>
        <td>' . htmlspecialchars($student['fathername']) . '</td>
    </tr>';
}

$html .= '</table>';
$pdf->writeHTML($html, true, false, true, false, '');

// ----------------- ATTENDANCE PAGES -----------------
foreach ($months as $month) {
    $year = date('Y'); // Adjust if academic year logic is needed
    $pdf->AddPage();

    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, 'Attendance Report for Class ' . $class . ' - Division ' . $division, 0, 1, 'C');
    $pdf->Ln(5);

    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, $academicMonths[$month] . ' ' . $year, 0, 1, 'C');
    $pdf->Ln(3);

    $html = '<table border="1" cellspacing="0" cellpadding="5">';

    // First header row: GR numbers
    $html .= '<tr><th rowspan="2" style="text-align:center;">Day</th>';
    foreach ($students as $student) {
        $html .= '<th style="font-size:8px; text-align:center;">G:' . htmlspecialchars($student['gr_no']) . '</th>';
    }
    $html .= '</tr>';

    // Second header row: Roll numbers
    $html .= '<tr>';
    foreach ($students as $student) {
        $html .= '<th style="font-size:8px; text-align:center;">R:' . htmlspecialchars($student['roll_no']) . '</th>';
    }
    $html .= '</tr>';

    // Attendance rows
    for ($day = 1; $day <= 31; $day++) {
        $html .= '<tr><td>' . $day . '</td>';
        foreach ($students as $student) {
            $status = $attendanceData[$month][$day][$student['id']] ?? 'holiday';

            if ($status == 'present') {
                $cellContent = 'P';
                $color = $presentc;
            } elseif ($status == 'absent') {
                $cellContent = 'F';
                $color = $absentc;
            } elseif ($status == 'half_day') {
                $cellContent = 'HD';
                $color = $halfdayc;
            } else {
                $cellContent = 'H';
                $color = $holidayc;
            }

            if ($colored) {
                $html .= '<td style="background-color:' . $color . '; text-align:center;">' . $cellContent . '</td>';
            } else {
                $html .= '<td style="text-align:center;">' . $cellContent . '</td>';
            }
        }
        $html .= '</tr>';
    }

    $html .= '</table><br>';

    $pdf->SetFont('helvetica', '', 10);
    $pdf->writeHTML($html, true, false, true, false, '');
    $pdf->Ln(5);
}

$pdf->Output('attendance_report.pdf', 'D');
exit();
?>