<?php

include '../core/db-connect91.php';

$student_id = $_SESSION['student_id'] ?? 0;
$batch = $_SESSION['selected_batch'] ?? '';

if (!$student_id || !$batch) {
    echo json_encode([]);
    exit;
}

$sql = "SELECT id, payment_number, semester, payment_method, payment_amount, 
               due_amount, total_amount, payment_status, payment_received_date
        FROM fee_payment_history
        WHERE student_id = ? AND batch = ?
        ORDER BY payment_received_date DESC";

$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "is", $student_id, $batch);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$history = [];
while ($row = mysqli_fetch_assoc($result)) {
    $history[] = $row;
}

mysqli_stmt_close($stmt);
mysqli_close($conn);

header('Content-Type: application/json');
echo json_encode($history);


?>