
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  



<?php


// Get current staff_id from session
$current_staff_id = $_SESSION['staff_id'] ?? 0;

// --- Fetch leaves joined with staff info ---
$sql = "
  SELECT
    sl.leave_id,
    sl.staff_id,
    sl.leave_date_from,
    sl.leave_date_to,
    sl.leave_type,
    sl.reason,
    sl.status AS leave_status,
    sl.applied_at,
    s.staff_image,
    s.staff_name,
    s.staff_surname,
    s.staff_fathername,
    s.staff_role
  FROM staff_leaves AS sl
  JOIN staff AS s ON sl.staff_id = s.staff_id
  ORDER BY sl.applied_at DESC
";
$result = $conn->query($sql);
?>

<div>
  <div class="flex items-center justify-between">
    <!-- … header/search … -->
  </div>

  <div class="card mt-3">
    <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
      <table class="is-hoverable w-full text-left">
        <thead>
          <tr>
            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase">#</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Avatar</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Father Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Role</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Leave Type</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Leave From</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Leave To</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Applied At</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase">Status</th>
            <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result && $result->num_rows): ?>
            <?php $i = 1; while($row = $result->fetch_assoc()): ?>

<?php
$status = strtolower(trim($row['leave_status']));
$bgStyle = '';
if ($status === 'approved') $bgStyle = 'background-color:#d1fae5;';
elseif ($status === 'rejected') $bgStyle = 'background-color:#fee2e2;';
elseif ($status === 'pending') $bgStyle = 'background-color:#fef9c3;';
?>

<tr style="<?= $bgStyle ?>" class="border-y border-transparent border-b-slate-200">
  <td class="px-4 py-3"><?= $i++ ?></td>
  <td class="px-4 py-3">
    <div class="avatar flex size-10">
      <img class="mask is-squircle"
           src="<?= htmlspecialchars($row['staff_image']) ?>"
           alt="avatar" />
    </div>
  </td>
  <td class="px-3 py-3 font-medium"><?= htmlspecialchars($row['staff_name'] . ' ' . $row['staff_surname']) ?></td>
  <td class="px-4 py-3"><?= htmlspecialchars($row['staff_fathername']) ?></td>
  <td class="px-4 py-3"><?= htmlspecialchars($row['staff_role']) ?></td>
  <td class="px-4 py-3"><?= htmlspecialchars($row['leave_type']) ?></td>
  <td class="px-4 py-3"><?= htmlspecialchars($row['leave_date_from']) ?></td>
  <td class="px-4 py-3"><?= htmlspecialchars($row['leave_date_to']) ?></td>
  <td class="px-4 py-3"><?= date('d M, Y', strtotime($row['applied_at'])) ?></td>
  <td class="px-4 py-3">
    <select
      class="form-select rounded-full border border-slate-300 bg-white px-2 py-1 pr-6"
      onchange="updateStaffLeaveStatus(<?= $row['leave_id'] ?>, this.value)"
    >
      <?php
      $statuses = ['pending','approved','rejected'];
      foreach($statuses as $st):
        $sel = $st === $row['leave_status'] ? 'selected' : '';
      ?>
        <option value="<?= $st ?>" <?= $sel ?>><?= $st ?></option>
      <?php endforeach; ?>
    </select>
  </td>
  <td class="px-4 py-3">
    <!-- Popper / Action buttons -->
    <div x-data="usePopper({placement:'bottom-end',offset:4})" @click.outside="isShowPopper = false" class="inline-flex">
      <button x-ref="popperRef" @click="isShowPopper = !isShowPopper" class="btn size-8 rounded-full p-0">
        <!-- icon -->
        <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01"/>
        </svg>
      </button>
      <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
        <!-- menu -->
      </div>
    </div>
  </td>
</tr>

<?php endwhile; else: ?>
<tr><td colspan="9" class="text-center py-4">No staff leave requests found.</td></tr>
<?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
function updateStaffLeaveStatus(leaveId, newStatus) {
  fetch('supporting/update-staff-leave-status.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({
      leave_id: leaveId,
      status: newStatus
    })
  })
  .then(res => res.text())
  .then(text => {
    try {
      const data = JSON.parse(text);
      window.dispatchEvent(new CustomEvent('open-modal', {
        detail: {
          type: data.success ? 'success' : 'error',
          message: data.success
            ? 'Leave status updated successfully!'
            : (data.message || 'Something went wrong.')
        }
      }));
    } catch (e) {}
  })
  .catch(err => {});
}
</script>
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    
   

<div x-data="{ showModal: false, type: '', message: '' }"
     @open-modal.window="
        showModal = true;
        type = $event.detail.type;
        message = $event.detail.message;
     ">

<template x-teleport="#x-teleport-target">
  <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
       x-show="showModal"
       role="dialog"
       @keydown.window.escape="showModal = false">

    <!-- Overlay -->
    <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
         @click="showModal = false"
         x-show="showModal"
         x-transition:enter="ease-out"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"></div>

    <!-- Modal Content -->
    <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
         x-show="showModal"
         x-transition:enter="ease-out"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

      <!-- Icon based on type -->
      <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
           class="mx-auto inline size-28 shrink-0 text-success"
           fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
              d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
      </svg>

      <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
           class="mx-auto inline size-28 shrink-0 text-red-600"
           fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
              d="M6 18L18 6M6 6l12 12"/>
      </svg>

      <div class="mt-4">
        <h2 class="text-2xl font-bold"
            :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
          <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
        </h2>
        <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

        <button @click="showModal = false"
                class="btn mt-6 font-medium text-white"
                :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
          Close
        </button>
      </div>
    </div>
  </div>
</template>
</div>
  
    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

