
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  




<?php
// Assume $conn is your DB connection and $website is your base URL

// Fetch teachers with role 'teacher'
$teachers = $conn->query("SELECT staff_id, staff_name, staff_surname, staff_role, staff_image FROM staff WHERE staff_role='teacher'");

// Fetch classes
$classes = $conn->query("SELECT class_id, class_name, division FROM classes");

// Fetch allotments: [staff_id][class_id] = true
$allotments = [];
$allotRes = $conn->query("SELECT staff_id, class_id FROM teacher_allotment");
while ($rowA = $allotRes->fetch_assoc()) {
    $allotments[$rowA['staff_id']][$rowA['class_id']] = true;
}
?>

<div id="allotment-list">
<?php if ($teachers->num_rows > 0 && $classes->num_rows > 0): ?>
    <?php while ($row = $teachers->fetch_assoc()): ?>
    

    
    <div class="card mt-6">
        <div class="p-2 text-right"></div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= htmlspecialchars($website . ($row['staff_image'] ?: 'default.png')) ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= htmlspecialchars($row['staff_name'] . " " . $row['staff_surname']) ?>
            </h3>
            <p class="text-xs-plus"><?= ucfirst(htmlspecialchars($row['staff_role'])) ?></p>
            
<div class="inline-space mt-3 flex grow flex-wrap justify-center items-start" 
     style="display: grid; grid-template-columns: repeat(4, minmax(0, 1fr)); gap: 5px; max-width: 100%;"> 
                <?php 
                $classes->data_seek(0); // rewind
                while ($class = $classes->fetch_assoc()):
                    $checked = isset($allotments[$row['staff_id']][$class['class_id']]) ? 'checked' : '';
                ?>
                <label class="inline-flex items-center space-x-2" style="min-width: 120px;">
                    <input
                        class="form-switch h-5 w-10 rounded-full bg-slate-300 before:rounded-full before:bg-slate-50 checked:!bg-success checked:before:bg-white dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:before:bg-white"
                        type="checkbox"
                        data-staff="<?= $row['staff_id'] ?>"
                        data-class="<?= $class['class_id'] ?>"
                        <?= $checked ?>
                    />
                    <span><?= htmlspecialchars($class['class_name'] . " " . $class['division']) ?></span>
                </label>
                <?php endwhile; ?>
            </div>
        </div>
    </div>
    <?php endwhile; ?>
<?php else: ?>
    <p class="text-center col-span-3">No teachers or classes found.</p>
<?php endif; ?>
</div>

<div id="ajax-status" style="color:green; margin-top:10px; text-align:center;"></div>

<script>
document.querySelectorAll('.form-switch').forEach(function(checkbox) {
    checkbox.addEventListener('change', function() {
        const staff_id = this.getAttribute('data-staff');
        const class_id = this.getAttribute('data-class');
        const action = this.checked ? 'add' : 'remove';
        const switchEl = this;
        const statusEl = document.getElementById('ajax-status');

        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'supporting/teacher-allotment-class.php', true);
        xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
        
        xhr.onload = function() {
            if (xhr.status === 200) {
                let resp;
                try {
                    resp = JSON.parse(xhr.responseText);
                } catch(e) {
                    statusEl.textContent = "Invalid server response.";
                    statusEl.style.color = 'red';
                    switchEl.checked = !switchEl.checked; // revert
                    return;
                }
                if (resp.success) {
                    statusEl.textContent = 'Allotment updated.';
                    statusEl.style.color = 'green';
                } else {
                    statusEl.textContent = 'Error: ' + resp.message;
                    statusEl.style.color = 'red';
                    switchEl.checked = !switchEl.checked; // revert
                }
            } else {
                statusEl.textContent = 'Server error.';
                statusEl.style.color = 'red';
                switchEl.checked = !switchEl.checked; // revert
            }
            setTimeout(() => statusEl.textContent = '', 3000);
        };
        
        xhr.onerror = function() {
            statusEl.textContent = 'Request failed.';
            statusEl.style.color = 'red';
            switchEl.checked = !switchEl.checked; // revert
            setTimeout(() => statusEl.textContent = '', 3000);
        };
        
        xhr.send('staff_id=' + encodeURIComponent(staff_id) + '&class_id=' + encodeURIComponent(class_id) + '&action=' + encodeURIComponent(action));
    });
});
</script>












  
  
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>