
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">



<?php
// Database connection

// Fetch total income (student fees paid)
$sql_income = "SELECT COALESCE(SUM(paid_amount),0) AS income FROM student_fees WHERE payment_status IN ('partially_paid','paid')";
$result_income = $conn->query($sql_income);
$income = ($result_income->num_rows > 0) ? $result_income->fetch_assoc()['income'] : 0;

// Fetch total expenditure (staff salary payments made)
$sql_expenditure = "SELECT COALESCE(SUM(paid_amount),0) AS expenditure FROM staff_salary_payments WHERE payment_status IN ('partially_paid','paid')";
$result_expenditure = $conn->query($sql_expenditure);
$expenditure = ($result_expenditure->num_rows > 0) ? $result_expenditure->fetch_assoc()['expenditure'] : 0;

$conn->close();
?>





<div
  class="card col-span-12 sm:col-span-7 lg:col-span-8 xl:col-span-7"
>
  <div class="my-3 flex items-center justify-between px-4">
    <h2
      class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
    >
Income And Expenditure
    </h2>
    <div
      x-data="usePopper({placement:'bottom-end',offset:4})"
      @click.outside="isShowPopper && (isShowPopper = false)"
      class="inline-flex"
    >
      <button
        x-ref="popperRef"
        @click="isShowPopper = !isShowPopper"
        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="size-5"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          stroke-width="2"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"
          />
        </svg>
      </button>

      <div
        x-ref="popperRoot"
        class="popper-root"
        :class="isShowPopper && 'show'"
      >
        <div
          class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
        >
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Another Action</a
              >
            </li>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Something else</a
              >
            </li>
          </ul>
          <div
            class="my-1 h-px bg-slate-150 dark:bg-navy-500"
          ></div>
          <ul>
            <li>
              <a
                href="#"
                class="flex h-8 items-center px-3 pr-8 font-medium tracking-wide outline-hidden transition-all hover:bg-slate-100 hover:text-slate-800 focus:bg-slate-100 focus:text-slate-800 dark:hover:bg-navy-600 dark:hover:text-navy-100 dark:focus:bg-navy-600 dark:focus:text-navy-100"
                >Separated Link</a
              >
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
  <div class="mt-3 px-3">

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<div style="text-align:center;">
  <!-- Custom Legend -->
  <div id="custom-legend" style="margin-bottom:15px; font-weight:bold; color:#374151; cursor:pointer;"></div>

  <!-- Chart -->
  <div id="chart"></div>
</div>


  </div>
  
<div class="grid grid-cols-2 my-3 gap-3 px-4">
  <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
    <div class="flex justify-between space-x-1">
      <p
        class="text-xl font-semibold text-slate-700 dark:text-navy-100"
      >
<?= $income ?>
      </p>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        stroke-width="1.5"
        class="size-5 text-primary dark:text-accent"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"
        />
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"
        />
      </svg>
    </div>
    <p class="mt-1 text-xs-plus">Income</p>
  </div>
  <div class="rounded-lg bg-slate-100 p-3 dark:bg-navy-600">
    <div class="flex justify-between">
      <p
        class="text-xl font-semibold text-slate-700 dark:text-navy-100"
      >
<?= $expenditure ?>
      </p>
      <svg
        xmlns="http://www.w3.org/2000/svg"
        class="size-5 text-success"
        fill="none"
        viewBox="0 0 24 24"
        stroke="currentColor"
      >
        <path
          stroke-linecap="round"
          stroke-linejoin="round"
          d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"
        />
      </svg>
    </div>
    <p class="mt-1 text-xs-plus">Expenditure</p>
  </div>
</div>
</div>



<div
  class="card mt-4 col-span-12 sm:col-span-7 lg:col-span-8 xl:col-span-7"
>
  <div class="my-3 flex items-center justify-between px-4">
    <h2
      class="font-medium tracking-wide text-slate-700 dark:text-navy-100"
    >
Income And Expenditure Monthly
    </h2>
    <div
      x-data="usePopper({placement:'bottom-end',offset:4})"
      @click.outside="isShowPopper && (isShowPopper = false)"
      class="inline-flex"
    >
      <button
        x-ref="popperRef"
        @click="isShowPopper = !isShowPopper"
        class="btn -mr-1.5 size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25"
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          class="size-5"
          fill="none"
          viewBox="0 0 24 24"
          stroke="currentColor"
          stroke-width="2"
        >
          <path
            stroke-linecap="round"
            stroke-linejoin="round"
            d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"
          />
        </svg>
      </button>

      <div
        x-ref="popperRoot"
        class="popper-root"
        :class="isShowPopper && 'show'"
      >
        <div
          class="popper-box rounded-md border border-slate-150 bg-white py-1.5 font-inter dark:border-navy-500 dark:bg-navy-700"
        >
          <ul>
            <li>
<div style="text-align:center; margin-bottom:15px;">
  <label for="year">Select Year: </label>
  <select id="year">
    <?php
    $currentYear = date("Y");
    for ($y = $currentYear; $y >= $currentYear-5; $y--) {
        echo "<option value='$y'>$y</option>";
    }
    ?>
  </select>
</div>

            </li>
          </ul>

        </div>
      </div>
    </div>
  </div>
  <div class="mt-3 px-3">


<div style="text-align:center;">
  <!-- Custom Legend -->
  <div id="custom-legend" style="margin-bottom:15px; font-weight:bold; color:#374151; cursor:pointer;"></div>

  <!-- Chart -->
<div id="chart2"></div>
</div>


  </div>
  
</div>










<script>
// ========================= DONUT CHART =========================
var optionsDonut = {
  series: [<?= $income ?>, <?= $expenditure ?>],
  chart: {
    type: 'donut',
    height: 420
  },
  labels: ['Income (Student Fees)', 'Expenditure (Staff Salary)'],
  colors: ['#f97316', '#2563eb'],
  fill: { type: 'gradient' },
  legend: { show: false },
  dataLabels: {
    style: { fontSize: '14px', fontWeight: 'bold', colors: ['#ffffff'] },
    formatter: (val) => val.toFixed(1) + "%"
  },
  tooltip: {
    y: { formatter: (val) => "₹ " + val.toLocaleString() }
  },
  plotOptions: {
    pie: {
      donut: {
        size: '65%',
        labels: {
          show: true,
          total: {
            show: true,
            label: 'Net Balance',
            fontSize: '18px',
            color: '#111827',
            formatter: function () {
              let income = <?= $income ?>;
              let expenditure = <?= $expenditure ?>;
              return "₹ " + (income - expenditure).toLocaleString();
            }
          },
          value: {
            fontSize: '16px',
            fontWeight: 'bold',
            formatter: (val) => "₹ " + val.toLocaleString()
          }
        }
      }
    }
  }
};

var chartDonut = new ApexCharts(document.querySelector("#chart"), optionsDonut);
chartDonut.render();


// ========================= MONTHLY BAR CHART =========================

function loadChart(year) {
  $.ajax({
    url: "supporting/staff-income-expenditure-chart-data.php",
    type: "POST",
    data: { year: year },
    dataType: "json",
    success: function(response) {
      chartMonthly.updateOptions({
        xaxis: { categories: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'] }
      });
      chartMonthly.updateSeries([
        { name: "Income", data: response.income },
        { name: "Expenditure", data: response.expenditure }
      ]);
    }
  });
}

var optionsMonthly = {
    chart: {
        type: 'bar',
        height: 420,
        toolbar: { show: false }
    },
    series: [
        { name: 'Income', data: [] },
        { name: 'Expenditure', data: [] }
    ],
    xaxis: { 
        categories: ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'] 
    },
    colors: ['#f97316', '#2563eb'], // Orange = Income, Blue = Expenditure
    plotOptions: {
        bar: {
            horizontal: false,
            columnWidth: '45%',
            borderRadius: 10,
            endingShape: 'rounded'
        }
    },
    dataLabels: { enabled: false }, // keep clean look
    grid: { borderColor: '#f1f1f1' },
    stroke: { show: true, width: 2, colors: ['transparent'] },
    legend: { 
        position: 'top',
        horizontalAlign: 'right',
        fontSize: '14px'
    },
    fill: {
        type: 'gradient',
        gradient: { 
            shade: 'light',
            type: "vertical",
            shadeIntensity: 0.4,
            opacityFrom: 1,
            opacityTo: 1,
            stops: [0, 100] 
        }
    },
    tooltip: {
        y: { formatter: (val) => "₹ " + val.toLocaleString() }
    }
};

var chartMonthly = new ApexCharts(document.querySelector("#chart2"), optionsMonthly);
chartMonthly.render();

// Load default year
let defaultYear = document.getElementById("year").value;
loadChart(defaultYear);

// Change year dynamically
$("#year").on("change", function() {
  loadChart(this.value);
});

</script>








  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>