
<?php
require_once "core/db-connect91.php";

$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}

// Fetch classes for dropdown
$classOptions = [];
$result = mysqli_query($conn, "SELECT class_name, division FROM classes ORDER BY class_name ASC");
while ($row = mysqli_fetch_assoc($result)) {
    $classOptions[] = $row['class_name'] . " - " . $row['division'];
}

// Fetch last GR number (numeric part)
$lastGR = 0;
$resultGR = mysqli_query($conn, "SELECT student_id, student_gr_no FROM students ORDER BY student_id DESC LIMIT 1");
if ($rowGR = mysqli_fetch_assoc($resultGR)) {
    // Remove non-numeric characters if GR No has letters
    $lastGR = $rowGR['student_gr_no'];
}
$nextGR = $lastGR + 1;








if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $message = "";
    $messageType = "";

    // Required fields check
    $required = [
        'student_name', 'student_surname', 'student_fathername', 'student_gender',
        'student_caste', 'student_minority', 'student_birthdate',
        'student_gr_no', 'student_phonenumber', 'student_address', 'class_division'
    ];

    foreach ($required as $field) {
        if (empty($_POST[$field])) {
            $message = "Error: Please fill all required fields!";
            $messageType = "error";
            break;
        }
    }

    if ($messageType !== "error") {

        // Create folder if not exists
        $targetDir = "../../studentprofileimage/";
        if (!is_dir($targetDir)) {
            mkdir($targetDir, 0777, true);
        }

        // Handle image
        if (!empty($_FILES['student_image']['name'])) {
            $imageName = time() . "_" . basename($_FILES['student_image']['name']);
            move_uploaded_file($_FILES['student_image']['tmp_name'], $targetDir . $imageName);
        } else {
            $imageName = "default.png";
        }
        $imageNamefile = $website . "studentprofileimage/" . $imageName;

        // Split Class & Division
        list($student_class, $student_division) = array_map('trim', explode('-', $_POST['class_division']));

        // Prepare form data
        $student_name = trim($_POST['student_name']);
        $student_surname = trim($_POST['student_surname']);
        $student_fathername = trim($_POST['student_fathername']);
        $student_gender = trim($_POST['student_gender']);
        $student_caste = trim($_POST['student_caste']);
        $student_subcaste = trim($_POST['student_subcaste'] ?? '');
        $student_minority = trim($_POST['student_minority']);
        $student_birthdate = trim($_POST['student_birthdate']);
        $student_gr_no = trim($_POST['student_gr_no']);
        $student_phonenumber = trim($_POST['student_phonenumber']);
        $student_alternativenumber = trim($_POST['student_alternativenumber'] ?? '');
        $student_email = trim($_POST['student_email'] ?? '');
        $student_address = trim($_POST['student_address']);

        // Auto-generate admission number
        $student_admission_no = "ADM" . time() . rand(1000,9999);

        // Generate username & password
        $birthYear = date('Y', strtotime($student_birthdate));
        $student_username = strtolower($student_name . $student_gr_no);
        $student_password = strtolower($student_name . $birthYear); // plain password

        // Check duplicates (GR number or username)
        $checkSql = "SELECT * FROM students 
                     WHERE student_gr_no = '$student_gr_no' OR student_username = '$student_username' LIMIT 1";
        $checkResult = mysqli_query($conn, $checkSql);

        if (mysqli_num_rows($checkResult) > 0) {
            $message = "Error: Student with same GR Number or Username already exists!";
            $messageType = "error";
        } else {
            // Registration info
            $student_registeredby = $_SESSION['staff_id'] ?? '0';
            $student_registrationdate = date('Y-m-d');

            // Insert student
            $sql = "INSERT INTO students (
                student_username, student_password, student_surname, student_name,
                student_fathername, student_gender, student_caste, student_subcaste,
                student_minority, student_birthdate, student_phonenumber,
                student_alternativenumber, student_email, student_address,
                student_image, student_class, student_division, student_admission_no,
                student_gr_no, student_status, student_registrationdate, student_registeredby
            ) VALUES (
                '$student_username', '$student_password', '$student_surname', '$student_name',
                '$student_fathername', '$student_gender', '$student_caste', '$student_subcaste',
                '$student_minority', '$student_birthdate', '$student_phonenumber',
                '$student_alternativenumber', '$student_email', '$student_address',
                '$imageNamefile', '$student_class', '$student_division', '$student_admission_no',
                '$student_gr_no', 'Active', '$student_registrationdate', '$student_registeredby'
            )";

            if (mysqli_query($conn, $sql)) {
                $message = "Student added successfully!";
                $messageType = "success";
                $nextGR = (int)$student_gr_no + 1;
            } else {
                $message = "Error: " . mysqli_error($conn);
                $messageType = "error";
            }
        }
    }
}




?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




<!-- Student Form (Keep your original styling) -->
<form method="POST" id="studentForm" enctype="multipart/form-data" x-data>
<div class="col-span-12 grid lg:col-span-8">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-layer-group"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">General</h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">

      <!-- Student Name Fields -->
      <label class="block">
        <span>First Name</span>
        <input name="student_name" required
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
          placeholder="Enter student first name" type="text"/>
      </label>

      <label class="block">
        <span>Surname</span>
        <input name="student_surname" required
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
          placeholder="Enter surname" type="text"/>
      </label>

      <label class="block">
        <span>Father Name</span>
        <input name="student_fathername" required
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
          placeholder="Enter father name" type="text"/>
      </label>

      <!-- Gender & Minority -->
      <div class="grid grid-cols-2 gap-4">
        <label class="block">
          <span>Gender</span>
          <select name="student_gender" required
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
            <option value="">Select Gender</option>
            <option value="Male">Male</option>
            <option value="Female">Female</option>
            <option value="Other">Other</option>
          </select>
        </label>

        <label class="block">
          <span>Minority</span>
          <select name="student_minority" required
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
            <option value="">Select</option>
            <option value="Yes">Yes</option>
            <option value="No">No</option>
          </select>
        </label>
      </div>

      <!-- Caste & Subcaste -->
<div class="grid grid-cols-2 gap-4">
  <label class="block">
    <span>Caste</span>
    <select name="student_caste" required
      class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
      <option value="">Select Caste</option>
      <option value="General">General</option>
      <option value="EWS">EWS</option>
      <option value="SC">SC</option>
      <option value="ST">ST</option>
      <option value="SEBC">SEBC / OBC</option>
    </select>
  </label>

  <label class="block">
    <span>Subcaste</span>
    <input name="student_subcaste" type="text"
      class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
      placeholder="Enter Subcaste"/>
  </label>
</div>

      <!-- Class & Division -->
      <label class="block">
        <span>Class & Division</span>
        <select name="class_division" required
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
          <option value="">Select Class & Division</option>
          <?php foreach($classOptions as $option): ?>
            <option value="<?= htmlspecialchars($option) ?>"><?= htmlspecialchars($option) ?></option>
          <?php endforeach; ?>
        </select>
      </label>

      <label class="block">
        <span>Birthdate</span>
        <input name="student_birthdate" required type="date"
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"/>
      </label>
<label class="block">
  <span>GR Number</span>
  <input id="grNumber" name="student_gr_no" required
    value="<?= $nextGR ?>"
    class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"
    placeholder="Enter GR No" type="text"/>
</label>

      <label class="block">
        <span>Email</span>
        <input name="student_email" type="email"
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"/>
      </label>

      <label class="block">
        <span>Phone Number</span>
        <input name="student_phonenumber" type="text"
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"/>
      </label>

      <label class="block">
        <span>Alternative Number</span>
        <input name="student_alternativenumber" type="text"
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"/>
      </label>

      <label class="block">
        <span>Address</span>
        <input name="student_address" type="text"
          class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2"/>
      </label>

      <div>
        <span>Image</span>
        <input type="file" name="student_image" class="mt-1.5 w-full"/>
      </div>

      <div class="flex justify-center space-x-2 pt-4">
        <button type="submit"
          class="btn space-x-2 bg-slate-150 font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
          <span>Submit</span>
        </button>
      </div>

    </div>
  </div>
</div>
</form>
  
  
  
  
  
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }"
     x-init="
        $watch('showModal', value => {
          if (!value && type === 'success') {
            // Reset form and refresh GR
            document.getElementById('studentForm').reset();
            document.getElementById('grNumber').value = '<?= $nextGR ?>';
          }
        });
     ">
  <!-- Modal content same as before (success/error with colors) -->


  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>