<?php
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name

// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support


// ===== Fetch Questions =====
$sql = "SELECT * FROM quiz_questions ORDER BY id ASC";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Math Quiz</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f7f9fc;
            padding: 20px;
        }
        .quiz-container {
            background: #fff;
            padding: 20px;
            max-width: 900px;
            margin: auto;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        }
        .question {
            margin-bottom: 25px;
            padding: 15px;
            border-bottom: 1px solid #ddd;
        }
        .question img {
            max-width: 300px;
            display: block;
            margin-top: 10px;
        }
        .options label {
            display: block;
            padding: 5px;
            cursor: pointer;
        }
        .question-number {
            font-weight: bold;
            margin-bottom: 10px;
        }
    </style>
    <!-- MathJax for LaTeX rendering -->
    <script>
      window.MathJax = {
        tex: { inlineMath: [['\\(','\\)'], ['$', '$']] },
        svg: { fontCache: 'global' }
      };
    </script>
    <script src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js"></script>
</head>
<body>
<div class="quiz-container">
    <h2>Mathematics Quiz</h2>
    <form method="post" action="check_answers.php">
        <?php
        if ($result->num_rows > 0) {
            $qNo = 1;
            while ($row = $result->fetch_assoc()) {

                // Convert \\frac to \frac etc. for MathJax
                $questionText = str_replace("\\\\", "\\", $row['question_text']);
                $optionA = str_replace("\\\\", "\\", $row['option_a']);
                $optionB = str_replace("\\\\", "\\", $row['option_b']);
                $optionC = str_replace("\\\\", "\\", $row['option_c']);
                $optionD = str_replace("\\\\", "\\", $row['option_d']);

                echo "<div class='question'>";
                echo "<div class='question-number'>Q{$qNo}. ({$row['marks']} Marks)</div>";
                echo "<div class='question-text'>{$questionText}</div>";

                if (!empty($row['question_image'])) {
                    echo "<img src='{$row['question_image']}' alt='Question Image'>";
                }

                echo "<div class='options'>";
                echo "<label><input type='radio' name='answer[{$row['id']}]' value='A'> {$optionA}</label>";
                echo "<label><input type='radio' name='answer[{$row['id']}]' value='B'> {$optionB}</label>";
                echo "<label><input type='radio' name='answer[{$row['id']}]' value='C'> {$optionC}</label>";
                echo "<label><input type='radio' name='answer[{$row['id']}]' value='D'> {$optionD}</label>";
                echo "</div>";
                echo "</div>";
                $qNo++;
            }
        } else {
            echo "<p>No questions available.</p>";
        }
        ?>
        <input type="submit" value="Submit Quiz">
    </form>
</div>
</body>
</html>
<?php $conn->close(); ?>