<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
    <script src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Modern Quiz App - Animated UI</title>
<style>
:root{
  --bg:#f3f6fb; --card:#ffffff; --muted:#6b7280; --primary:#2563eb; --success:#16a34a; --danger:#ef4444;
  --shadow: 0 8px 20px rgba(16,24,40,0.06);
}
body{
  font-family: 'Poppins', sans-serif;
  margin:0;
  background: linear-gradient(to bottom right, #fef6ff, #e0f7ff);
  color:#0f172a;
 /* min-height:100vh; */
  display:flex;
  align-items:center;
  justify-content:center;
 /* padding:24px */
}
.container{width:100%;max-width:980px}
.card{background:var(--card);border-radius:12px;padding:20px;box-shadow:var(--shadow);}
h1{margin:0;font-size:20px}
.steps {
  display: flex;
  gap: 12px;
  margin-top: 16px;
  justify-content: center;
  flex-wrap: wrap;
}

.step {
  flex: 1;
  min-width: 140px;
  padding: 12px 18px;
  border-radius: 50px;
  text-align: center;
  font-size: 14px;
  font-weight: 500;
  color: #6b7280;
  background: linear-gradient(180deg, #f9fafb, #f1f5f9);
  border: 1px solid #e2e8f0;
  box-shadow: 0 2px 6px rgba(0,0,0,0.06);
  cursor: pointer;
  transition: all 0.3s ease;
  position: relative;
}

/* Active step */
.step.active {
  background: linear-gradient(90deg, #2563eb, #3b82f6);
  color: white;
  font-weight: 600;
  box-shadow: 0 4px 12px rgba(37,99,235,0.3);
  transform: translateY(-2px);
}

/* Completed step */
.step.completed {
  background: linear-gradient(90deg, #16a34a, #22c55e);
  color: white;
  font-weight: 600;
  box-shadow: 0 4px 12px rgba(22,163,74,0.3);
}

/* Hover effect for inactive */
.step:hover:not(.active):not(.completed) {
  background: #f3f4f6;
  transform: translateY(-2px);
}

.layout{display:grid;grid-template-columns:1fr 350px;gap:16px;margin-top:16px}
.settings .field{margin-bottom:12px}
label{display:block;font-size:13px;color:var(--muted);margin-bottom:6px}
input[type=number], select, input[type=text]{width:100%;padding:10px;border-radius:8px;border:1px solid #e6edf3;background:transparent}
.muted{font-size:13px;color:var(--muted)}
.small{font-size:12px;color:var(--muted)}
.btn{padding:10px 14px;border-radius:10px;border:none;cursor:pointer;font-weight:600}
.btn.primary{background:var(--primary);color:white}
.btn.ghost{background:transparent;border:1px solid rgba(15,23,42,0.06);color:var(--muted)}
.right-col{display:flex;flex-direction:column;gap:12px}
.card-sm{background:linear-gradient(180deg,#fff,#fbfdff);padding:12px;border-radius:10px;border:1px solid #f1f5f9}

/* --- Glass UI for Settings & Results --- */
.card-sm {
  background: rgba(255, 255, 255, 0.7);
  backdrop-filter: blur(10px);
  padding: 20px;
  border-radius: 16px;
  box-shadow: 0 8px 24px rgba(0,0,0,0.08);
  transition: all 0.3s ease;
}
.card-sm:hover {
  transform: translateY(-3px);
}

/* Settings Layout */
#screen-settings label {
  font-weight: 500;
  color: #374151;
}
#screen-settings input,
#screen-settings select {
  border: 1px solid rgba(0,0,0,0.08);
  background: rgba(255, 255, 255, 0.6);
  box-shadow: inset 0 1px 3px rgba(0,0,0,0.05);
  font-weight: 500;
}
#screen-settings .btn.primary {
  background: linear-gradient(135deg, #4f46e5, #2563eb);
}
#screen-settings .btn.ghost {
  color: #4b5563;
  border-color: #cbd5e1;
}

/* Results Page */
#screen-results {
  animation: fadeIn 0.6s ease-in-out;
}
#screen-results h2 {
  font-size: 24px;
  background: linear-gradient(90deg, #2563eb, #3b82f6);
  -webkit-background-clip: text;
  color: transparent;
}
#final-score {
  font-size: 34px;
  font-weight: 800;
  color: #2563eb;
  text-shadow: 0 0 6px rgba(37,99,235,0.15);
}
.result-item {
  border: 1px solid rgba(0,0,0,0.05);
  background: linear-gradient(180deg,#ffffff,#f9fafb);
  padding: 14px 18px;
  border-radius: 12px;
  box-shadow: 0 3px 10px rgba(0,0,0,0.05);
}
.tag.correct {
  background: linear-gradient(135deg, #22c55e, #16a34a);
  color: #fff;
  font-weight: 600;
}
.tag.wrong {
  background: linear-gradient(135deg, #ef4444, #dc2626);
  color: #fff;
  font-weight: 600;
}
.tag {
  padding: 6px 12px;
  border-radius: 20px;
}



/* --- New Question Card Design --- */
.quiz-card {
  padding: 0;
}
.question-card {
  background: white;
  border-radius: 15px;
  padding: 20px;
  margin: 10px auto;
  box-shadow: 0 4px 15px rgba(0,0,0,0.1);
  animation: fadeIn 0.4s ease-in-out;
  transition: transform 0.2s;
}
.question-card:hover {
  transform: scale(1.01);
}
.question-number {
  background: linear-gradient(90deg, #ff6f91, #ff9671);
  color: white;
  font-size: 1.2em;
  padding: 10px 15px;
  border-radius: 10px;
  display: inline-block;
  margin-bottom: 15px;
  box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}
.question-text {
  font-size: 1.1em;
  margin-bottom: 15px;
}
.question-image {
  max-width: 100%;
  border-radius: 10px;
  margin-bottom: 15px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.options {
  display: flex;
  flex-direction: column;
}
.option {
  background: #f9f9f9;
  padding: 12px;
  margin: 8px 0;
  border-radius: 8px;
  cursor: pointer;
  transition: 0.3s;
  border: 2px solid transparent;
}
.option:hover {
  background: #e3f2fd;
  border-color: #2196f3;
  transform: translateX(5px);
}
.option.correct {
  background: rgba(22, 163, 74, 0.08);
  border-color: rgba(16, 185, 129, 0.7);
  color: var(--success);
}
.option.wrong {
  background: rgba(239, 68, 68, 0.08);
  border-color: rgba(239, 68, 68, 0.7);
  color: var(--danger);
}
.option.disabled {
  opacity: 0.7;
  cursor: not-allowed;
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(10px); }
  to { opacity: 1; transform: translateY(0); }
}

/* Result list */
.result-list{display:grid;gap:12px;margin-top:12px}
.result-item{padding:12px;border-radius:10px;border:1px solid #eef2f7;background:#fff}
.tag{display:inline-block;padding:6px 8px;border-radius:8px;font-size:12px}
.tag.correct{background:rgba(16,185,129,0.12);color:var(--success)}
.tag.wrong{background:rgba(239,68,68,0.08);color:var(--danger)}

@media (max-width:900px){
  .layout{grid-template-columns:1fr}
  .steps{flex-direction:column}
}


</style>


<div class="container">
  <div class="card">
    <div style="display:flex;justify-content:space-between;align-items:center">
      <div>
        <h1>Modern Quiz App</h1>
        <div class="small muted">Three-step flow: 1) Settings → 2) Take Exam → 3) Review Results</div>
      </div>
      <div class="small muted">Marks: <strong>+4</strong> for right, <strong>-1</strong> for wrong</div>
    </div>
    <div class="steps">
      <div id="step-1" class="step active">1. Settings</div>
      <div id="step-2" class="step">2. Exam</div>
      <div id="step-3" class="step">3. Results</div>
    </div>

    <div class="layout">
      <div>
        <!-- Settings Screen -->
        <div id="screen-settings" class="card-sm">
          <div class="settings">
            <div class="field">
              <label>Per-question timer</label>
              <div style="display:flex;gap:8px;align-items:center">
                <input type="checkbox" id="pq-enable"> <label for="pq-enable" class="muted">Enable per-question timer</label>
              </div>
            </div>
            <div class="field">
              <label>Seconds per question</label>
              <input id="pq-seconds" type="number" min="5" value="60">
            </div>
            <div class="field">
              <label>Overall quiz time (minutes)</label>
              <input id="overall-minutes" type="number" min="1" value="15">
            </div>
            <div class="field">
              <label>Number of questions</label>
              <input id="total-questions" type="number" min="1" value="5">
            </div>
            <div class="field">
              <label>Randomize questions?</label>
              <div style="display:flex;gap:8px;align-items:center"><input type="checkbox" id="randomize" checked> <span class="muted">Shuffle question order</span></div>
            </div>
            <div style="display:flex;gap:10px;margin-top:10px">
              <button id="start-btn" class="btn primary">Start Exam</button>
              <button id="preview-questions" class="btn ghost">Preview Questions</button>
            </div>
            <div class="small muted" style="margin-top:10px">Settings are locked after starting the exam. Refresh to fully reset.</div>
          </div>
        </div>

        <!-- Exam Screen -->
        <div id="screen-exam" style="display:none">
          <div class="quiz-card">
            <div class="meta" style="display:flex;justify-content:space-between;align-items:center;margin-bottom:10px">
              <div>
                <div id="q-count" style="font-weight:700">Question 0 / 0</div>
                <div class="muted" id="score">Score: 0</div>
              </div>
              <div style="width:55%">
                <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:6px">
                  <div class="small muted">Overall: <span id="overall-timer">00:00</span></div>
                  <div class="small muted">Q-time: <span id="pq-timer">-</span></div>
                </div>
              </div>
            </div>
            <div id="options"></div>
            <div class="footer" style="display:flex;justify-content:space-between;align-items:center;margin-top:14px">
              <div style="display:flex;gap:8px">
                <button id="prev-btn" class="btn ghost">Prev</button>
                <button id="next-btn" class="btn ghost">Next</button>
              </div>
              <button id="submit-btn" class="btn ghost">Submit</button>
            </div>
          </div>
        </div>

        <!-- Results Screen -->
        <div id="screen-results" style="display:none">
          <div style="display:flex;justify-content:space-between;align-items:center">
            <div>
              <h2 style="margin:0">Your Result</h2>
              <div class="muted small" id="res-summary">Score breakdown</div>
            </div>
            <div style="text-align:right">
              <div style="font-size:20px;font-weight:700" id="final-score">0</div>
              <div class="small muted">Total Marks</div>
            </div>
          </div>
          <div class="result-list" id="result-list"></div>
          <div style="display:flex;gap:8px;margin-top:12px">
            <button id="retake-btn" class="btn primary">Retake (same settings)</button>
            <button id="back-settings" class="btn ghost">Back to Settings</button>
          </div>
        </div>

      </div>

      <div class="right-col">
        <div id="quick-info" class="card-sm">
          <div class="muted">Quick Info</div>
          <div class="small muted">Marks per correct: +4</div>
          <div class="small muted">Penalty per wrong: -1</div>
          <div class="small muted" style="margin-top:6px">Timeout on question is counted as wrong automatically.</div>
        </div>
        <div id="preview-card" class="card-sm">
          <div class="muted">Question Preview</div>
          <div id="preview-area" style="margin-top:8px;font-size:14px;color:var(--muted)">Click "Preview Questions" to see sample questions.</div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- MathJax config + loader -->




<!-- MathJax config (put this in <head> or before your quiz script) -->
<script src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>

<!-- Your existing script with PHP echo for ALL_QUESTIONS and JS logic -->
<script>
/*<?php
// db connection
// Database credentials
$host = "localhost";       // Database host
$user = "samruddh_sch";            // Database username
$pass = "Patel@2002";                // Database password
$dbname = "samruddh_sch";     // Your database name
date_default_timezone_set("Asia/Kolkata");
// Create MySQLi connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Optional: Set character set to utf8mb4 for full Unicode support
$conn->set_charset("utf8mb4");

// fetch questions
$sql = "SELECT id, question_text, option_a, option_b, option_c, option_d, correct_option 
        FROM quiz_questions";
$result = mysqli_query($conn, $sql);

$questions = [];

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {
        // map correct_option (A,B,C,D) to 0-3 index
        $answerIndex = null;
        switch ($row['correct_option']) {
            case 'A': $answerIndex = 0; break;
            case 'B': $answerIndex = 1; break;
            case 'C': $answerIndex = 2; break;
            case 'D': $answerIndex = 3; break;
        }

        // Wrap question and options with math delimiters for MathJax
        // Adjust depending if you want to treat all as math or selectively
        $wrappedQuestion = $row['question_text'];
        $wrappedOptions = [
            $row['option_a'],
            $row['option_b'],
            $row['option_c'],
            $row['option_d']
        ];

        $questions[] = [
            "q" => $wrappedQuestion,
            "options" => $wrappedOptions,
            "answer" => $answerIndex
        ];
    }
}

// close connection
mysqli_close($conn);

// output in JS format
echo "const ALL_QUESTIONS = " . json_encode($questions, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) . ";";
?>*/
const ALL_QUESTIONS = [
  {
    q: "A = \\{ x \\in \\mathbb{N} : x \\text{ is even and } 1 \\le x \\le 10 \\}. \\text{ What is the set } A?",
    options: [
      "\\{ 2,4,6,8,10 \\}",
      "\\{ 1,3,5,7,9 \\}",
      "\\{ 0,2,4,6,8,10 \\}",
      "\\{ 1,2,3,4,5 \\}"
    ],
    answer: 0
  },
  {
    q: "If U = \\{1,2,3,4,5,6,7,8,9,10\\}, A = \\{2,4,6,8,10\\}, B = \\{1,2,3,4,5\\}, \\text{ find } A \\cap B.",
    options: [
      "\\{1,3,5\\}",
      "\\{2,4\\}",
      "\\{6,8,10\\}",
      "\\{\\}"
    ],
    answer: 1
  },
  {
    q: "If A = \\{a,e,i,o,u\\} \\text{ and } B = \\{a,b,c,d,e\\}, \\text{ then } A \\cup B \\text{ is:}",
    options: [
      "\\{a,e,i,o,u\\}",
      "\\{a,b,c,d,e,i,o,u\\}",
      "\\{b,c,d\\}",
      "\\{a,e\\}"
    ],
    answer: 1
  },
  {
    q: "Which of the following represents the complement of set A = \\{2,4,6\\} in U = \\{1,2,3,4,5,6\\}?",
    options: [
      "\\{1,3,5\\}",
      "\\{2,4,6\\}",
      "\\{1,2,3,4,5,6\\}",
      "\\{3,5\\}"
    ],
    answer: 0
  },

  // ✅ 3×3 Sets Questions
  {
    q: "If A = \\{1,2,3,4\\}, B = \\{3,4,5,6\\}, C = \\{4,5,6,7\\}, \\text{ find } A \\cap B \\cap C.",
    options: [
      "\\{4\\}",
      "\\{3,4,5,6\\}",
      "\\{1,2,3\\}",
      "\\{\\}"
    ],
    answer: 0
  },
  {
    q: "For A = \\{1,2,3,4\\}, B = \\{3,4,5,6\\}, C = \\{5,6,7,8\\}, \\text{ what is } (A \\cup B) \\cup C?",
    options: [
      "\\{1,2,3,4,5,6,7,8\\}",
      "\\{3,4,5,6\\}",
      "\\{1,2,7,8\\}",
      "\\{1,2,3,4\\}"
    ],
    answer: 0
  },
  {
    q: "If A = \\{1,2,3,4\\}, B = \\{2,4,6,8\\}, C = \\{1,2,5,6\\}, \\text{ find } (A \\cap B) \\cup C.",
    options: [
      "\\{1,2,4,5,6\\}",
      "\\{2,4\\}",
      "\\{1,2,3,4,5,6,8\\}",
      "\\{1,2,5,6\\}"
    ],
    answer: 0
  },

  // ✅ 3×3 Matrix Questions
  {
    q: "If A = \\begin{bmatrix}1 & 2 & 3\\\\4 & 5 & 6\\\\7 & 8 & 9\\end{bmatrix}, \\text{ what is the element at position } (2,3)?",
    options: ["4", "6", "9", "8"],
    answer: 1
  },
  {
    q: "Find the determinant of A = \\begin{bmatrix}1 & 0 & 2\\\\-1 & 3 & 1\\\\3 & 2 & 0\\end{bmatrix}.",
    options: ["17", "-17", "15", "-15"],
    answer: 0
  },
  {
    q: "For A = \\begin{bmatrix}1 & 2 & 3\\\\0 & 1 & 4\\\\5 & 6 & 0\\end{bmatrix}, \\text{ find the transpose } A^T.",
    options: [
      "\\begin{bmatrix}1 & 0 & 5\\\\2 & 1 & 6\\\\3 & 4 & 0\\end{bmatrix}",
      "\\begin{bmatrix}1 & 2 & 5\\\\0 & 1 & 6\\\\3 & 4 & 0\\end{bmatrix}",
      "\\begin{bmatrix}1 & 0 & 3\\\\2 & 1 & 4\\\\5 & 6 & 0\\end{bmatrix}",
      "\\begin{bmatrix}1 & 0 & 5\\\\2 & 1 & 4\\\\3 & 6 & 0\\end{bmatrix}"
    ],
    answer: 0
  },
  {
    q: "If A = \\begin{bmatrix}2 & 0 & 1\\\\-1 & 3 & 2\\\\0 & 4 & -1\\end{bmatrix}, B = \\begin{bmatrix}1 & 2 & 3\\\\0 & -1 & 4\\\\5 & 1 & 0\\end{bmatrix}, \\text{ then the element at } (1,1) \\text{ of } A+B \\text{ is:}",
    options: ["3", "2", "1", "4"],
    answer: 0
  }
];
// --- DOM references (assumes script placed after DOM elements) ---
const startBtn=document.getElementById('start-btn'),
      previewBtn=document.getElementById('preview-questions'),
      pqEnable=document.getElementById('pq-enable'),
      pqSecondsInput=document.getElementById('pq-seconds'),
      overallMinutesInput=document.getElementById('overall-minutes'),
      totalQuestionsInput=document.getElementById('total-questions'),
      randomizeCheck=document.getElementById('randomize'),
      steps={s1:document.getElementById('step-1'),s2:document.getElementById('step-2'),s3:document.getElementById('step-3')},
      screenSettings=document.getElementById('screen-settings'),
      screenExam=document.getElementById('screen-exam'),
      screenResults=document.getElementById('screen-results'),
      qCount=document.getElementById('q-count'),
      scoreEl=document.getElementById('score'),
      overallTimerEl=document.getElementById('overall-timer'),
      pqTimerEl=document.getElementById('pq-timer'),
      optionsEl=document.getElementById('options'),
      prevBtn=document.getElementById('prev-btn'),
      nextBtn=document.getElementById('next-btn'),
      submitBtn=document.getElementById('submit-btn'),
      previewArea=document.getElementById('preview-area'),
      resultList=document.getElementById('result-list'),
      finalScoreEl=document.getElementById('final-score'),
      resSummary=document.getElementById('res-summary'),
      retakeBtn=document.getElementById('retake-btn'),
      backSettingsBtn=document.getElementById('back-settings'),
      quickInfo=document.getElementById('quick-info'),
      previewCard=document.getElementById('preview-card');

let questions=[],current=0,started=false,answers=[],chosenIndex=[],score=0,overallTimerId=null,overallRemaining=0,pqTimerId=null,pqTotal=0;

// ---------------- MathJax helper ----------------
function typesetMath(el = null){
  if (window.MathJax && typeof MathJax.typesetPromise === 'function') {
    try {
      if (el) {
        return MathJax.typesetPromise([el]).catch(function (err) {
          console.error('MathJax typesetPromise error (element):', err);
        });
      } else {
        return MathJax.typesetPromise().catch(function (err) {
          console.error('MathJax typesetPromise error (document):', err);
        });
      }
    } catch (e) {
      console.error('MathJax typeset call failed:', e);
    }
  }
  return Promise.resolve();
}
// ------------------------------------------------

function formatTime(s){const mm=Math.floor(s/60).toString().padStart(2,'0');const ss=(s%60).toString().padStart(2,'0');return mm+':'+ss;}
function shuffle(arr){for(let i=arr.length-1;i>0;i--){const j=Math.floor(Math.random()*(i+1));[arr[i],arr[j]]=[arr[j],arr[i]];}}
function lockSettings(){pqEnable.disabled=true;pqSecondsInput.disabled=true;overallMinutesInput.disabled=true;totalQuestionsInput.disabled=true;randomizeCheck.disabled=true;startBtn.disabled=true;previewBtn.disabled=true;}
function unlockSettings(){pqEnable.disabled=false;pqSecondsInput.disabled=false;overallMinutesInput.disabled=false;totalQuestionsInput.disabled=false;randomizeCheck.disabled=false;startBtn.disabled=false;previewBtn.disabled=false;}
function gotoStep(n){steps.s1.classList.remove('active');steps.s2.classList.remove('active');steps.s3.classList.remove('active');if(n===1)steps.s1.classList.add('active');if(n===2)steps.s2.classList.add('active');if(n===3)steps.s3.classList.add('active');}
function pickQuestions(count){const pool=ALL_QUESTIONS.map(x=>({...x}));if(randomizeCheck.checked)shuffle(pool);return pool.slice(0,count);}

function hideSideCards(hide){
  if(hide){
    quickInfo.style.display = 'none';
    previewCard.style.display = 'none';
  } else {
    quickInfo.style.display = '';
    previewCard.style.display = '';
  }
}

function setNavButtonsPrimary(on){
  prevBtn.className = on ? 'btn primary' : 'btn ghost';
  nextBtn.className = on ? 'btn primary' : 'btn ghost';
  submitBtn.className = on ? 'btn primary' : 'btn ghost';
}

function startExam(){
  if(started)return;
  started=true;
  lockSettings();
  gotoStep(2);
  screenSettings.style.display='none';
  screenExam.style.display='block';
  screenResults.style.display='none';
  hideSideCards(true);
  setNavButtonsPrimary(true);

  const tq=Math.max(1,parseInt(totalQuestionsInput.value||5));
  questions=pickQuestions(tq);
  answers=Array(tq).fill(undefined);
  chosenIndex=Array(tq).fill(null);
  current=0;score=0;
  qCount.textContent=`Question 1 / ${questions.length}`;
  scoreEl.textContent=`Score: ${score}`;
  overallRemaining=Math.max(1,parseInt(overallMinutesInput.value||15))*60;
  overallTimerEl.textContent=formatTime(overallRemaining);
  overallTimerId=setInterval(()=>{
    overallRemaining--;
    overallTimerEl.textContent=formatTime(overallRemaining);
    if(overallRemaining<=0){
      clearInterval(overallTimerId);
      submitQuiz();
    }
  },1000);
  renderQuestion(0);
}

function renderQuestion(idx){
  current=idx;
  const q=questions[idx];
  optionsEl.innerHTML='';
  const card=document.createElement('div');
  card.className='question-card';
  const num=document.createElement('div');
  num.className='question-number';
  num.textContent=`Question ${idx+1}`;
  card.appendChild(num);
  const qText=document.createElement('div');
  qText.className='question-text';
  // Wrap with inline math delimiters for MathJax but don't include with string itself
  qText.innerHTML = `\\(${q.q}\\)`; 
  card.appendChild(qText);
  const optsWrap=document.createElement('div');
  optsWrap.className='options';
  q.options.forEach((opt,i)=>{
    const d=document.createElement('div');
    d.className='option';
    d.innerHTML = `\\(${opt}\\)`; // wrap each option for MathJax typesetting
    d.addEventListener('click',()=>selectOption(i));
    optsWrap.appendChild(d);
  });
  card.appendChild(optsWrap);
  optionsEl.appendChild(card);
  qCount.textContent=`Question ${idx+1} / ${questions.length}`;

  // Call MathJax typeset on current question card only
  typesetMath(card);

  if(typeof answers[idx]!=='undefined'){
    const corr=q.answer;
    Array.from(optsWrap.children).forEach((el,i)=>{
      el.classList.add('disabled');
      if(i===corr)el.classList.add('correct');
      if(chosenIndex[idx]===i && i!==corr)el.classList.add('wrong');
    });
  }
  prevBtn.disabled=(idx===0);
  nextBtn.disabled=(idx===questions.length-1);
  startPQTimer();
}

previewBtn.addEventListener('click',()=>{
  previewArea.innerHTML=ALL_QUESTIONS.map((q,idx)=>
    `<div><strong>Q${idx+1}.</strong> \\(${q.q}\\)</div>`
  ).join('');
  typesetMath(previewArea);
});


function startPQTimer(){
  clearPQTimer();
  if(!pqEnable.checked){
    pqTimerEl.textContent='-';
    return;
  }
  pqTotal=Math.max(5,parseInt(pqSecondsInput.value||60));
  pqTimerEl.textContent=pqTotal+'s';
  pqTimerId=setInterval(()=>{
    pqTotal--;
    pqTimerEl.textContent=pqTotal+'s';
    if(pqTotal<=0){
      clearPQTimer();
      handleTimeout();
    }
  },1000);
}
function clearPQTimer(){if(pqTimerId){clearInterval(pqTimerId);pqTimerId=null;}}
function handleTimeout(){
  if(typeof answers[current]==='undefined'){
    answers[current]=false;
    score-=1;
    scoreEl.textContent=`Score: ${score}`;
  }
  if(current<questions.length-1)renderQuestion(current+1);
  else submitQuiz();
}
function selectOption(idx){
  if(!started)return;
  const opts=document.querySelectorAll('.option');
  if(opts[idx].classList.contains('disabled'))return;
  clearPQTimer();
  const q=questions[current];
  const correct=(idx===q.answer);
  chosenIndex[current]=idx;
  if(correct){
    opts[idx].classList.add('correct');
    answers[current]=true;
    score+=4;
  } else {
    opts[idx].classList.add('wrong');
    opts[q.answer].classList.add('correct');
    answers[current]=false;
    score-=1;
  }
  opts.forEach(o=>o.classList.add('disabled'));
  scoreEl.textContent=`Score: ${score}`;
  setTimeout(()=>{
    if(current<questions.length-1)renderQuestion(current+1);
    else submitQuiz();
  },800);
}
function nextQuestion(){clearPQTimer();if(current<questions.length-1)renderQuestion(current+1);else submitQuiz();}
function prevQuestion(){clearPQTimer();if(current>0)renderQuestion(current-1);}

function submitQuiz(){
  if(!started)return;
  started=false;
  clearInterval(overallTimerId);
  clearPQTimer();
  for(let i=0;i<answers.length;i++){if(typeof answers[i]==='undefined')answers[i]=null;}
  gotoStep(3);
  screenSettings.style.display='none';
  screenExam.style.display='none';
  screenResults.style.display='block';
  hideSideCards(false);
  setNavButtonsPrimary(false);

  const correctCount=answers.filter(a=>a===true).length;
  const wrongCount=answers.filter(a=>a===false).length;
  const unCount=answers.filter(a=>a===null).length;
  finalScoreEl.textContent=score;
  resSummary.textContent=`Correct: ${correctCount} | Wrong: ${wrongCount} | Unanswered: ${unCount}`;
  resultList.innerHTML='';

  questions.forEach((q,i)=>{
    const item=document.createElement('div');
    item.className='result-item';
    const head=document.createElement('div');
    head.style.display='flex';
    head.style.justifyContent='space-between';
    const left=document.createElement('div');
    left.innerHTML = `<div style="font-weight:700">Q${i+1}. ${q.q}</div>`;
    const tag=document.createElement('div');
    if(answers[i]===true){tag.className='tag correct';tag.textContent='Correct';}
    else if(answers[i]===false){tag.className='tag wrong';tag.textContent='Wrong';}
    else{tag.className='tag';tag.textContent='Unanswered';}
    head.appendChild(left);head.appendChild(tag);item.appendChild(head);
    const list=document.createElement('div');
    list.style.marginTop='8px';
    q.options.forEach((opt,oi)=>{
      const row=document.createElement('div');
      row.style.display='flex';
      row.style.justifyContent='space-between';
      row.style.alignItems='center';
      row.style.padding='6px 0';
      const label=document.createElement('div');
      label.innerHTML = opt;
      label.style.flex='1';
      label.style.marginRight='12px';
      const mark=document.createElement('div');
      mark.style.minWidth='120px';
      mark.style.textAlign='right';
      mark.className='small muted';

      if(oi===q.answer){
        label.style.color = 'var(--success)';
        mark.textContent = 'Correct Answer';
        mark.style.color = 'var(--success)';
      }
      if(chosenIndex[i]===oi){
        if(oi===q.answer){
          label.style.fontWeight = '700';
          label.style.color = 'var(--success)';
          mark.textContent = 'You selected (Correct)';
          mark.style.color = 'var(--success)';
        } else {
          label.style.color = 'var(--danger)';
          label.style.textDecoration = 'none';
          mark.textContent = 'You selected (Wrong)';
          mark.style.color = 'var(--danger)';
        }
      }
      row.appendChild(label);
      row.appendChild(mark);
      list.appendChild(row);
    });
    item.appendChild(list);
    resultList.appendChild(item);
  });

  // typeset math inside the results container
  typesetMath(resultList);
}

previewBtn.addEventListener('click',()=>{
  previewArea.innerHTML=ALL_QUESTIONS.map((q,idx)=>
    `<div><strong>Q${idx+1}.</strong> ${q.q}</div>`
  ).join('');
  // typeset math in preview area specifically
  typesetMath(previewArea);
});
startBtn.addEventListener('click',startExam);
prevBtn.addEventListener('click',prevQuestion);
nextBtn.addEventListener('click',nextQuestion);
submitBtn.addEventListener('click',()=>{if(confirm('Submit exam now?'))submitQuiz();});
retakeBtn.addEventListener('click',()=>{
  started=false;
  clearInterval(overallTimerId);
  clearPQTimer();
  unlockSettings();
  startBtn.disabled=false;
  previewBtn.disabled=false;
  startExam();
});
backSettingsBtn.addEventListener('click',()=>{
  gotoStep(1);
  screenSettings.style.display='block';
  screenExam.style.display='none';
  screenResults.style.display='none';
  hideSideCards(false);
  setNavButtonsPrimary(false);
  unlockSettings();
});
</script>

</body>
</html>