
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">







<div class="col-span-12 lg:col-span-13">
  <form method="POST" class="card space-y-5 p-4 sm:p-5">



<label class="block">
  <span class="font-medium text-slate-600 dark:text-navy-100">Select Semester</span>
  <select name="semester"
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Semester</option>
    <option value="1">Semester 1</option>
    <option value="2">Semester 2</option>
  </select>
</label>
    

<label class="block mt-3">
  <span class="font-medium text-slate-600 dark:text-navy-100">Batch</span>
  <select name="batch" required
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Batch</option>
    <?php
    $bres = mysqli_query($conn, "SELECT batch_name FROM batch WHERE status='Active' ORDER BY batch_id DESC");
    while ($b = mysqli_fetch_assoc($bres)) : ?>
      <option value="<?= htmlspecialchars($b['batch_name']) ?>" <?= $selected_batch == $b['batch_name'] ? 'selected' : '' ?>>
        <?= htmlspecialchars($b['batch_name']) ?>
      </option>
    <?php endwhile; ?>
  </select>
</label>
    <button
    type="submit"
    class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
        Submit
    </button>
  </form>
</div>

<?php
// payment-history.php


// 2. Only allow POST (from your new form)
if ($_SERVER['REQUEST_METHOD'] == 'POST') {


// 3. Get POST data securely
$student_id = intval($_SESSION['student_id']);
$semester   = $conn->real_escape_string($_POST['semester']);
$batch      = $conn->real_escape_string($_POST['batch']);

// 4. Fetch payment history
$sql = "SELECT * FROM fee_payment_history 
        WHERE student_id = ? AND semester = ? AND batch = ?
        ORDER BY payment_received_date DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iss", $student_id, $semester, $batch);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="is-scrollbar-hidden min-w-full overflow-x-auto">
<table class="w-full text-left">
    <thead>
        <tr class="bg-gray-200">
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">#</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Payment Date</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Payment Number</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Method</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Amount</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Due</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Total</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Status</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Received By</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Invoice</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Payment Details</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if ($result->num_rows > 0) {
            $sr = 1;
            $totalPaid = 0;
            while ($row = $result->fetch_assoc()) {

                // Background color
                $status = strtolower(trim($row['payment_status']));
                $rowColor = '';
                if ($status === 'paid') {
                    $rowColor = "background-color:#d1fae5;"; // light green
                } elseif ($status === 'unpaid') {
                    $rowColor = "background-color:#fee2e2;"; // light red
                } elseif ($status === 'partially paid') {
                    $rowColor = "background-color:#fef9c3;"; // light yellow
                }

                // Build payment details
                $details = "";
                switch (strtolower($row['payment_method'])) {
                    case 'cash':
                        $notes = [];
                        foreach ([10,20,50,100,200,500,2000] as $note) {
                            $field = "cash_{$note}";
                            if (!empty($row[$field]) && $row[$field] > 0) {
                                $notes[] = "₹{$note} x {$row[$field]}";
                            }
                        }
                        if (!empty($row['cash_other'])) {
                            $notes[] = "Other: ₹{$row['cash_other']}";
                        }
                        $details = implode("<br>", $notes);
                        break;

                    case 'upi':
                        $details = "UPI ID: {$row['upi_id']}<br>Txn ID: {$row['transaction_id']}";
                        break;

                    case 'cheque':
                        $details = "Cheque No: {$row['cheque_number']}<br>Bank: {$row['bank_name']}<br>IFSC: {$row['ifsc_code']}";
                        break;

                    case 'dd':
                        $details = "DD No: {$row['dd_number']}<br>Bank: {$row['bank_name']}<br>IFSC: {$row['ifsc_code']}";
                        break;

                    case 'card':
                        $details = "Card Last 4: {$row['card_last4']}<br>Txn ID: {$row['transaction_id']}";
                        break;

                    case 'wallet':
                        $details = "Wallet: {$row['wallet_name']}<br>Txn ID: {$row['transaction_id']}";
                        break;

                    default:
                        if (!empty($row['other_description'])) {
                            $details = $row['other_description'];
                        }
                        break;
                }

                // Increment total paid
                $totalPaid += floatval($row['payment_amount']);

                echo "<tr style='{$rowColor}'>
                        <td class='whitespace-nowrap px-4 py-3'>{$sr}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_received_date']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_number']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_method']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_amount']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['due_amount']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['total_amount']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_status']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>{$row['payment_received_by']}</td>
                        <td class='whitespace-nowrap px-4 py-3'>
                            " . (!empty($row['invoice_file']) ? "<a href='{$website}{$row['invoice_file']}' target='_blank' class='text-blue-500 underline'>View</a>" : "—") . "
                        </td>
                        <td class='whitespace-nowrap px-4 py-3'>" . (!empty($details) ? $details : "—") . "</td>
                      </tr>";
                $sr++;
            }

            // Add total row
            echo "<tr class='bg-gray-100 font-semibold'>
                    <td colspan='4' class='whitespace-nowrap px-4 py-3 text-right'>Total Paid:</td>
                    <td class='whitespace-nowrap px-4 py-3'>₹" . number_format($totalPaid, 2) . "</td>
                    <td colspan='6'></td>
                  </tr>";

        } else {
            echo "<tr><td colspan='11' class='border px-4 py-2 text-center text-gray-500'>No payment history found</td></tr>";
        }
        ?>
    </tbody>
</table>
</div>

<?php

}
?>



  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>