
<?php
require_once "core/db-connect91.php";
$page8 = basename($_SERVER['PHP_SELF']); // current file name

$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  


  
  

<?php


// Initialize variables
$role = $name = "";
$where = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $role = trim($_POST['role'] ?? '');
    $name = trim($_POST['name'] ?? '');

    // Filter by role
    if ($role !== '') {
        $where[] = "staff_role = '" . $conn->real_escape_string($role) . "'";
    }

    // Filter by name (first, surname, or father name)
    if ($name !== '') {
        $safeName = $conn->real_escape_string($name);
        $where[] = "(staff_name LIKE '%$safeName%' 
                     OR staff_surname LIKE '%$safeName%' 
                     OR staff_fathername LIKE '%$safeName%')";
    }

    // Build SQL
    $sql = "SELECT * FROM staff";
    if (!empty($where)) {
        $sql .= " WHERE " . implode(" AND ", $where);
    }

    $result = $conn->query($sql);
}
?>

<!-- Search Form -->
<div class="col-span-12 lg:col-span-13">
  <form method="POST" class="card space-y-5 p-4 sm:p-5">

    <!-- Role Select -->
    <label class="block">
      <span class="font-medium text-slate-600 dark:text-navy-100">Select Role</span>
      <select name="role"
        class="mt-1.5 w-full"
        x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
      >
        <option value="">All Roles</option>
        <option value="admin" <?= $role=='admin'?'selected':'' ?>>Admin</option>    
        <option value="teacher" <?= $role=='teacher'?'selected':'' ?>>Teacher</option>
        <option value="accountant" <?= $role=='accountant'?'selected':'' ?>>Accountant</option>
        <option value="driver" <?= $role=='driver'?'selected':'' ?>>Driver</option>
      </select>
    </label>

    <!-- Name Input -->
    <label class="relative flex">
      <input name="name"
        class="form-input peer w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
        placeholder="Search By Name"
        type="text"
        value="<?= htmlspecialchars($name) ?>"
      />
      <span
        class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent"
      >
        <svg xmlns="http://www.w3.org/2000/svg" class="size-4.5" fill="currentColor" viewBox="0 0 24 24"><path d="M3.316 13.781l.73-.171-.73.171zm0-5.457l.73.171-.73-.171zm15.473 0l.73-.171-.73.171zm0 5.457l.73.171-.73-.171zm-5.008 5.008l-.171-.73.171.73zm-5.457 0l-.171.73.171-.73zm0-15.473l-.171-.73.171.73zm5.457 0l.171-.73-.171.73zM20.47 21.53a.75.75 0 101.06-1.06l-1.06 1.06zM4.046 13.61a11.198 11.198 0 010-5.115l-1.46-.342a12.698 12.698 0 000 5.8l1.46-.343zm14.013-5.115a11.196 11.196 0 010 5.115l1.46.342a12.698 12.698 0 000-5.8l-1.46.343zm-4.45 9.564a11.196 11.196 0 01-5.114 0l-.342 1.46c1.907.448 3.892.448 5.8 0l-.343-1.46zM8.496 4.046a11.198 11.198 0 015.115 0l.342-1.46a12.698 12.698 0 00-5.8 0l.343 1.46zm0 14.013a5.97 5.97 0 01-4.45-4.45l-1.46.343a7.47 7.47 0 005.568 5.568l.342-1.46zm5.457 1.46a7.47 7.47 0 005.568-5.567l-1.46-.342a5.97 5.97 0 01-4.45 4.45l.342 1.46zM13.61 4.046a5.97 5.97 0 014.45 4.45l1.46-.343a7.47 7.47 0 00-5.568-5.567l-.342 1.46zm-5.457-1.46a7.47 7.47 0 00-5.567 5.567l1.46.342a5.97 5.97 0 014.45-4.45l-.343-1.46zm8.652 15.28l3.665 3.664 1.06-1.06-3.665-3.665-1.06 1.06z"/></svg>
      </span>
    </label>

    <!-- Submit Button -->
    <button
      class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
        Submit
    </button>
  </form>
</div>

<!-- Results -->
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">
<?php
if (isset($result) && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
?>
    <div class="card">
        <div class="p-2 text-right"></div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= $website . $row['staff_image'] ?: 'default.png' ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= $row['staff_name']." ".$row['staff_surname'] ?>
            </h3>
            <p class="text-xs-plus"><?= ucfirst($row['staff_role']) ?></p>
            
<div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
    <span class="tag rounded-full bg-success/10 text-success m-1">
        Phone: <?= $row['staff_phonenumber'] ?>
    </span>
</div>
<div class="inline-space mt-3 flex grow flex-wrap justify-center items-start">
<span class="tag rounded-full bg-success/10 text-success m-1">
    Email: <?= $row['staff_email'] ?>
</span>
</div>



            <!-- Hidden Form -->
            <form action="set-staff-id.php" method="POST" id="staffForm<?= $row['staff_id'] ?>" style="display:none;">
                <input type="hidden" name="staff_id" value="<?= $row['staff_id'] ?>">
                <input type="hidden" name="target_page" id="targetPage<?= $row['staff_id'] ?>" value="">
            </form>

            <!-- Buttons -->
            <div class="mt-6 grid w-full grid-cols-2 gap-2">                
                <button type="button" 
                    class="btn space-x-2 bg-primary px-0 font-medium text-white hover:bg-primary-focus"
                    onclick="
                  document.getElementById('targetPage<?= $row['staff_id'] ?>').value='staff-view-staff-attendance-main.php';
                        document.getElementById('staffForm<?= $row['staff_id'] ?>').submit();
                    ">
                    View Attendance
                </button>           
                <button type="button" 
                    class="btn space-x-2 bg-slate-150 px-0 font-medium text-slate-800 hover:bg-slate-200"
                    onclick="
                        document.getElementById('targetPage<?= $row['staff_id'] ?>').value='staff-view-staff-attendance-main.php';
                        document.getElementById('staffForm<?= $row['staff_id'] ?>').submit();
                    ">
                    Edit Profile
                </button>
            </div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No staff found.</p>";
}
?>
</div>

  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>