
<?php
require_once "core/db-connect91.php";




$selected_staff_id = (int)($_SESSION['staff_id'] ?? $selected_staff_id ?? 0);
$staff_id = (int)($_SESSION['staff_id'] ?? 0);
?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




<?php
// Example: $staff_id comes from session or request


$sql = "
    SELECT 
        p.month,
        p.year,
        p.batch,
        p.salary_to_pay,
        p.paid_amount,
        p.due_amount,
        p.payment_status,
        p.payment_date,
        p.remarks
    FROM staff_salary_payments p
    LEFT JOIN staff s ON p.staff_id = s.staff_id
    WHERE p.staff_id = ?
    ORDER BY p.payment_date DESC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $staff_id);
$stmt->execute();
$result = $stmt->get_result();

?>
<div class="mt-5">
  <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
    <table class="is-zebra w-full text-left">
      <thead>
        <tr>
          <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">#</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Month</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Year</th>

          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Salary To Pay</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Paid</th>
          <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Due</th>
          <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Status</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result && $result->num_rows > 0): 
          $i = 1;
          while ($row = $result->fetch_assoc()): ?>
            <tr>
              <td class="whitespace-nowrap rounded-l-lg px-4 py-3 sm:px-5"><?= $i++; ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= htmlspecialchars($row['month']); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= htmlspecialchars($row['year']); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['salary_to_pay'], 2); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['paid_amount'], 2); ?></td>
              <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= number_format($row['due_amount'], 2); ?></td>
              <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">
                <?php if ($row['payment_status'] === 'paid'): ?>
                  <span class="text-green-600 font-semibold">Paid</span>
                <?php elseif ($row['payment_status'] === 'partial'): ?>
                  <span class="text-yellow-600 font-semibold">Partial</span>
                <?php else: ?>
                  <span class="text-red-600 font-semibold">Unpaid</span>
                <?php endif; ?>
              </td>
            </tr>
        <?php endwhile; else: ?>
            <tr>
              <td colspan="8" class="text-center py-4 text-slate-500">No salary payments found.</td>
            </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>


  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>