
<?php
require_once "core/db-connect91.php";

if (!isset($_SESSION['student_id'])) {
    die("Error: Student not logged in.");
}
$page8 = basename($_SERVER['PHP_SELF']); // current file name
$sql = "SELECT * FROM role_access WHERE role = '$role' AND access_page = '$page8' AND access_status = 1";
$result = mysqli_query($conn, $sql);

if (mysqli_num_rows($result) == 0) {
    echo "Unauthorized Access!";
    exit;
}


?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




<!-- Student Form (Keep your original styling) -->


  
<?php


$student_id = $_SESSION['student_id'];

// Fetch current student data
$sql = "SELECT * FROM students WHERE student_id = '$student_id' LIMIT 1";
$result = mysqli_query($conn, $sql);
if (!$result || mysqli_num_rows($result) == 0) {
    die("Error: Student data not found.");
}
$student = mysqli_fetch_assoc($result);

// Handle form submission
$message = "";
$messageType = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $student_username = $_POST['student_username'];
    $student_password = $_POST['student_password'];
    $student_name = $_POST['student_name'];
    $student_surname = $_POST['student_surname'];
    $student_fathername = $_POST['student_fathername'];
    $student_gender = $_POST['student_gender'];
    $student_minority = $_POST['student_minority'];
    $student_caste = $_POST['student_caste'];
    $student_subcaste = $_POST['student_subcaste'];
    $student_class = $_POST['student_class'];
    $student_division = $_POST['student_division'];
    $student_birthdate = $_POST['student_birthdate'];
    $student_gr_no = $_POST['student_gr_no'];
    $student_admission_no = $_POST['student_admission_no'];
    $student_email = $_POST['student_email'];
    $student_phonenumber = $_POST['student_phonenumber'];
    $student_alternativenumber = $_POST['student_alternativenumber'];
    $student_address = $_POST['student_address'];

    // Handle image upload
    $imagePath = $student['student_image']; // keep old image if not replaced
    $targetDir = "../../studentprofileimage/";
    if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);

    if (!empty($_FILES['student_image']['name'])) {
        $imageName = time() . "_" . basename($_FILES['student_image']['name']);
        $imagePath = $targetDir . $imageName;
        move_uploaded_file($_FILES['student_image']['tmp_name'], $imagePath);
        $imagePath = $imagePath; 
    }
$updated_at = date('Y-m-d H:i:s'); // current date & time in MySQL format
$updated_by = $_SESSION['staff_id'];
    // Update query
// Make sure this exists and is an integer


$sqlUpdate = "UPDATE students SET 
    student_username='$student_username',
    student_password='$student_password',
    student_name='$student_name',
    student_surname='$student_surname',
    student_fathername='$student_fathername',
    student_gender='$student_gender',
    student_minority='$student_minority',
    student_caste='$student_caste',
    student_subcaste='$student_subcaste',
    student_class='$student_class',
    student_division='$student_division',
    student_birthdate='$student_birthdate',
    student_gr_no='$student_gr_no',
    student_admission_no='$student_admission_no',
    student_email='$student_email',
    student_phonenumber='$student_phonenumber',
    student_alternativenumber='$student_alternativenumber',
    student_address='$student_address',
    student_image='$imagePath',
    updated_at = NOW(),
    updated_by = $updated_by
WHERE student_id = $student_id";

    if (mysqli_query($conn, $sqlUpdate)) {
        $message = "Profile updated successfully!";
        $messageType = "success";
        // Refresh data
        $student = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM students WHERE student_id = '$student_id' LIMIT 1"));
    } else {
        $message = "Error updating profile: " . mysqli_error($conn);
        $messageType = "error";
    }
}
?>



<div class="col-span-12 grid lg:col-span-8 mx-auto max-w-3xl">
  <div class="card">
    <div class="border-b border-slate-200 p-4 dark:border-navy-500 sm:px-5">
      <div class="flex items-center space-x-2">
        <div class="flex h-7 w-7 items-center justify-center rounded-lg bg-primary/10 p-1 text-primary dark:bg-accent-light/10 dark:text-accent-light">
          <i class="fa-solid fa-user-pen"></i>
        </div>
        <h4 class="text-lg font-medium text-slate-700 dark:text-navy-100">
          Edit Student Profile
        </h4>
      </div>
    </div>

    <div class="space-y-4 p-4 sm:p-5">
      <?php if ($message): ?>
        <div class="p-3 rounded-lg <?= $messageType=='success'?'bg-green-100 text-green-700':'bg-red-100 text-red-700' ?>">
          <?= htmlspecialchars($message) ?>
        </div>
      <?php endif; ?>

      <form method="POST" enctype="multipart/form-data">
        
        <!-- Profile Image -->
        <div class="flex justify-center pt-4">
          <img src="<?= htmlspecialchars($student['student_image']) ?>" 
               alt="Student Image" 
               class="h-32 w-32 rounded-lg border border-slate-300 object-cover mb-2">
        </div>
        <input type="file" name="student_image" class="mt-1.5 w-full"/>

        <!-- Editable Fields -->
        <label class="block"><span>Username</span>
          <input name="student_username" value="<?= htmlspecialchars($student['student_username']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Password</span>
          <input name="student_password" value="<?= htmlspecialchars($student['student_password']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>First Name</span>
          <input name="student_name" value="<?= htmlspecialchars($student['student_name']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Surname</span>
          <input name="student_surname" value="<?= htmlspecialchars($student['student_surname']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Father Name</span>
          <input name="student_fathername" value="<?= htmlspecialchars($student['student_fathername']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Gender</span>
          <select name="student_gender" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2">
            <option value="Male" <?= $student['student_gender']=="Male"?"selected":"" ?>>Male</option>
            <option value="Female" <?= $student['student_gender']=="Female"?"selected":"" ?>>Female</option>
            <option value="Other" <?= $student['student_gender']=="Other"?"selected":"" ?>>Other</option>
          </select>
        </label>

        <label class="block"><span>Minority</span>
          <select name="student_minority" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2">
            <option value="Yes" <?= $student['student_minority']=="Yes"?"selected":"" ?>>Yes</option>
            <option value="No" <?= $student['student_minority']=="No"?"selected":"" ?>>No</option>
          </select>
        </label>

        <label class="block"><span>Caste</span>
          <select name="student_caste" class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2">
            <option value="General" <?= $student['student_caste']=="General"?"selected":"" ?>>General</option>
            <option value="EWS" <?= $student['student_caste']=="EWS"?"selected":"" ?>>EWS</option>
            <option value="SC" <?= $student['student_caste']=="SC"?"selected":"" ?>>SC</option>
            <option value="ST" <?= $student['student_caste']=="ST"?"selected":"" ?>>ST</option>
            <option value="SEBC" <?= $student['student_caste']=="SEBC"?"selected":"" ?>>SEBC</option>
          </select>
        </label>

        <label class="block"><span>Subcaste</span>
          <input name="student_subcaste" value="<?= htmlspecialchars($student['student_subcaste']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Class</span>
          <input name="student_class" value="<?= htmlspecialchars($student['student_class']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Division</span>
          <input name="student_division" value="<?= htmlspecialchars($student['student_division']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Birthdate</span>
          <input name="student_birthdate" type="date" value="<?= htmlspecialchars($student['student_birthdate']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>GR Number</span>
          <input name="student_gr_no" value="<?= htmlspecialchars($student['student_gr_no']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Admission Number</span>
          <input name="student_admission_no" value="<?= htmlspecialchars($student['student_admission_no']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Email</span>
          <input name="student_email" value="<?= htmlspecialchars($student['student_email']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Phone Number</span>
          <input name="student_phonenumber" value="<?= htmlspecialchars($student['student_phonenumber']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Alternative Number</span>
          <input name="student_alternativenumber" value="<?= htmlspecialchars($student['student_alternativenumber']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <label class="block"><span>Address</span>
          <input name="student_address" value="<?= htmlspecialchars($student['student_address']) ?>" 
            class="form-input mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2"/>
        </label>

        <div class="flex justify-center space-x-2 pt-4">
          <button type="submit"
            class="btn space-x-2 bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary/90">
            <span>Update Profile</span>
          </button>
        </div>

      </form>
    </div>
  </div>
</div>

  
  

<div x-data="{ 
      showModal: <?= $message ? 'true' : 'false' ?>, 
      message: '<?= addslashes($message) ?>', 
      type: '<?= $messageType ?>' 
   }"
   x-init="
      $watch('showModal', value => {
        if (!value && type === 'success') {
          // Reset form and refresh GR
          document.getElementById('studentForm').reset();
          document.getElementById('grNumber').value = '<?= $nextGR ?>';
        }
      });
   ">
<!-- Modal content same as before (success/error with colors) -->


<template x-teleport="#x-teleport-target">
  <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
       x-show="showModal"
       role="dialog"
       @keydown.window.escape="showModal = false">

    <!-- Overlay -->
    <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
         @click="showModal = false"
         x-show="showModal"
         x-transition:enter="ease-out"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"></div>

    <!-- Modal Content -->
    <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
         x-show="showModal"
         x-transition:enter="ease-out"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="ease-in"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

      <!-- Icon based on type -->
      <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
           class="mx-auto inline size-28 shrink-0 text-success"
           fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
              d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
      </svg>

      <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
           class="mx-auto inline size-28 shrink-0 text-red-600"
           fill="none" viewBox="0 0 24 24" stroke="currentColor">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
              d="M6 18L18 6M6 6l12 12"/>
      </svg>

      <div class="mt-4">
        <h2 class="text-2xl font-bold"
            :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
          <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
        </h2>
        <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

        <button @click="showModal = false"
                class="btn mt-6 font-medium text-white"
                :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
          Close
        </button>
      </div>
    </div>
  </div>
</template>
</div>
  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>