<?php
session_start();
require_once "../core/db-connect91.php";

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$leave_id = intval($data['leave_id'] ?? 0);
$status = trim($data['status'] ?? '');
$approved_by = $_SESSION['staff_id'] ?? null;

if (!$leave_id || !in_array($status, ['pending','approved','rejected'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

// --- 1) Update staff_leaves ---
$sql = "UPDATE staff_leaves
        SET status = ?, approved_by = ?
        WHERE leave_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sii", $status, $approved_by, $leave_id);

if ($stmt->execute()) {
    // --- 2) If approved, insert/update staff_attendance ---
    if ($status === "approved") {
        // Fetch leave details
        $q = $conn->prepare("SELECT staff_id, leave_date_from, leave_date_to, leave_type 
                             FROM staff_leaves WHERE leave_id = ?");
        $q->bind_param("i", $leave_id);
        $q->execute();
        $result = $q->get_result();
        if ($row = $result->fetch_assoc()) {
            $staff_id = $row['staff_id'];
            $leave_type = $row['leave_type'];
            $from = new DateTime($row['leave_date_from']);
            $to = new DateTime($row['leave_date_to']);
            $to->modify('+1 day'); // include last date

            // Get staff username (if needed in attendance)
            $staffQ = $conn->prepare("SELECT staff_username FROM staff WHERE staff_id = ?");
            $staffQ->bind_param("i", $staff_id);
            $staffQ->execute();
            $staffRes = $staffQ->get_result();
            $staffRow = $staffRes->fetch_assoc();
            $staff_username = $staffRow['staff_username'] ?? null;

            $recorded_by = $approved_by;
     
            $remarks = "Leave approved";

            // Loop each date in range
            $period = new DatePeriod($from, new DateInterval('P1D'), $to);
            foreach ($period as $date) {
                $day = $date->format("d");
                $month = $date->format("m");
                $year = $date->format("Y");

                // Check if attendance already exists
                $check = $conn->prepare("SELECT attendance_id FROM staff_attendance 
                                         WHERE staff_id = ? AND day = ? AND month = ? AND year = ?");
                $check->bind_param("iiii", $staff_id, $day, $month, $year);
                $check->execute();
                $checkRes = $check->get_result();

                if ($checkRes->num_rows > 0) {
                    // Update existing record
                    $update = $conn->prepare("UPDATE staff_attendance 
                        SET status = 'leave', leave_type = ?, remarks = ?, recorded_by = ?
                        WHERE staff_id = ? AND day = ? AND month = ? AND year = ?");
                    $update->bind_param("ssiIIII", $leave_type, $remarks, $recorded_by,
                                        $staff_id, $day, $month, $year);
                    $update->execute();
                } else {
                    // Insert new record
                    $insert = $conn->prepare("INSERT INTO staff_attendance 
                        (staff_id, staff_username, day, month, year, status, leave_type, batch, remarks, recorded_by, timestamp) 
                        VALUES (?, ?, ?, ?, ?, 'leave', ?, ?, ?, ?, NOW())");
                    $insert->bind_param("issiisssi", $staff_id, $staff_username, $day, $month, $year,
                                        $leave_type, $batch, $remarks, $recorded_by);
                    $insert->execute();
                }
            }
        }
        $q->close();
    }

    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => $stmt->error]);
}
$stmt->close();
?>