<?php
require_once "../core/db-connect91.php";

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $staff_id = isset($_POST['staff_id']) ? intval($_POST['staff_id']) : 0;
    $class_id = isset($_POST['class_id']) ? intval($_POST['class_id']) : 0;
    $action = $_POST['action'] ?? '';

    if (!$staff_id || !$class_id || !in_array($action, ['add','remove'])) {
        echo json_encode(['success' => false, 'message' => 'Invalid parameters']);
        exit;
    }

    $alloted_by = $_SESSION['staff_id'] ?? '1';

    if ($action === 'add') {
        // Insert allotment if not exists
        $stmt_check = $conn->prepare("SELECT COUNT(*) FROM teacher_allotment WHERE staff_id=? AND class_id=?");
        $stmt_check->bind_param("ii", $staff_id, $class_id);
        $stmt_check->execute();
        $stmt_check->bind_result($count);
        $stmt_check->fetch();
        $stmt_check->close();

        if ($count == 0) {
            $stmt = $conn->prepare("INSERT INTO teacher_allotment (staff_id, class_id, alloted_by, alloted_date) VALUES (?, ?, ?, NOW())");
            $stmt->bind_param("iis", $staff_id, $class_id, $alloted_by);
            $success = $stmt->execute();
            $stmt->close();
            if ($success) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Failed to insert allotment']);
            }
        } else {
            // already exists, no action needed
            echo json_encode(['success' => true]);
        }
    } else if ($action === 'remove') {
        // Delete allotment
        $stmt = $conn->prepare("DELETE FROM teacher_allotment WHERE staff_id=? AND class_id=?");
        $stmt->bind_param("ii", $staff_id, $class_id);
        $success = $stmt->execute();
        $stmt->close();

        if ($success) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to remove allotment']);
        }
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
}
?>