<?php
require_once "../core/db-connect91.php";

$class_id = isset($_POST['class_id']) ? intval($_POST['class_id']) : 0;
$subject  = isset($_POST['subject']) ? mysqli_real_escape_string($conn, $_POST['subject']) : '';
$semester = isset($_POST['semester']) ? intval($_POST['semester']) : 0;

if ($class_id && $subject && $semester) {
    $sql = "SELECT syllabus_id, chapter, status 
            FROM syllabus 
            WHERE class_id=$class_id AND subject='$subject' AND semester=$semester
            ORDER BY syllabus_id ASC";
    $result = mysqli_query($conn, $sql);

    if (!$result) {
        die("Query failed: " . mysqli_error($conn));
    }

    $rows = "";
    $count = 1;
while ($row = mysqli_fetch_assoc($result)) {
    $ch = htmlspecialchars($row['chapter']);
    $sid = (int)$row['syllabus_id'];
    $checked = $row['status'] == 1 ? "checked" : "";

    $rows .= "<tr>
        <td class='border px-2 py-1'>$count</td>
        <td class='border px-2 py-1'>$ch</td>
        <td class='border px-2 py-1 text-center'>
            <label class='inline-flex items-center space-x-2'>
                <input 
                    type='checkbox' 
                    class='form-switch h-5 w-10 rounded-full bg-slate-300 
                           before:rounded-full before:bg-slate-50 
                           checked:!bg-success checked:before:bg-white 
                           dark:bg-navy-900 dark:before:bg-navy-300 dark:checked:before:bg-white 
                           toggle-status' 
                    data-id='$sid' $checked>
                <span>".($row['status'] == 1 ? "Complete" : "Incomplete")."</span>
            </label>
        </td>
    </tr>";
    $count++;
}

    if (empty($rows)) {
        $rows = "<tr><td colspan='3' class='text-center border py-2'>No chapters found</td></tr>";
    }

    echo $rows;
}
?>