
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

  
  

<?php

//$student_id = $_SESSION['student_id'];
$student_id = 1;
// Prepare SQL
$sql = "SELECT student_id, student_class, student_division FROM students WHERE student_id = ?";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, "i", $student_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

// Fetch data
if ($row = mysqli_fetch_assoc($result)) {
    $studentid = $row['student_id'];    
    $class = $row['student_class'];
    $division = $row['student_division'];
} else {
    die("No student found for the given ID.");
}

// Example usage
// echo "Class: $class, Division: $division";
?>
  
<form method="POST" action="supporting/print-attendance-pdf-student.php" id="attendanceForm">

  <!-- Hidden Class & Division from Students -->
  <input type="hidden" name="class" value="<?= htmlspecialchars($class) ?>">
  <input type="hidden" name="division" value="<?= htmlspecialchars($division) ?>">
  <input type="hidden" name="studentid" value="<?= htmlspecialchars($studentid) ?>">
  <!-- Months Multiple Select -->
  <label class="block">
    <span>Months</span>
    <select name="months[]" multiple required
      class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
      <option value="1">January</option>
      <option value="2">February</option>
      <option value="3">March</option>
      <option value="4">April</option>
      <option value="5">May</option>
      <option value="6">June</option>
      <option value="7">July</option>
      <option value="8">August</option>
      <option value="9">September</option>
      <option value="10">October</option>
      <option value="11">November</option>
      <option value="12">December</option>
    </select>
  </label>

  <!-- Year -->
  <label class="block">
    <span>Year</span>
    <input name="year" type="number" required value="<?= date('Y') ?>"
      class="form-input mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2">
  </label>

  <!-- Colored Checkbox -->
  <label class="flex items-center space-x-2 mt-4">
    <input type="checkbox" name="colored" id="coloredCheck"
      class="form-checkbox border-slate-300 rounded text-primary">
    <span>Enable Custom Colors</span>
  </label>

  <!-- Color Pickers (hidden by default) -->
  <div id="colorInputs" style="display:none;" class="mt-4 space-y-3">
    <label class="block">
      <span>Present Color</span>
      <input type="color" name="presentc" value="#28a745"
        class="form-input mt-1.5 w-16 h-10 border border-slate-300 rounded">
    </label>

    <label class="block">
      <span>Absent Color</span>
      <input type="color" name="absentc" value="#dc3545"
        class="form-input mt-1.5 w-16 h-10 border border-slate-300 rounded">
    </label>

    <label class="block">
      <span>Holiday Color</span>
      <input type="color" name="holidayc" value="#6c757d"
        class="form-input mt-1.5 w-16 h-10 border border-slate-300 rounded">
    </label>

    <label class="block">
      <span>Half Day Color</span>
      <input type="color" name="halfdayc" value="#fd7e14"
        class="form-input mt-1.5 w-16 h-10 border border-slate-300 rounded">
    </label>
  </div>

  <!-- Submit -->
  <div class="flex justify-center space-x-2 pt-4">
    <button type="submit"
      class="btn space-x-2 bg-slate-150 font-medium text-slate-800 hover:bg-slate-200 focus:bg-slate-200 active:bg-slate-200/80 dark:bg-navy-500 dark:text-navy-50 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
      <span>Submit</span>
    </button>
  </div>
</form>

<script>
  document.getElementById('coloredCheck').addEventListener('change', function() {
    document.getElementById('colorInputs').style.display = this.checked ? 'block' : 'none';
  });
</script>
  
  
  

  
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>