<?php

session_start();
require_once "../core/db-connect91.php";

header('Content-Type: application/json');

if (!isset($_SESSION['staff_id'])) {
    echo json_encode(["status" => "error", "message" => "Not logged in"]);
    exit;
}

$staff_id  = $_SESSION['staff_id'];
$todo_date = $_POST['todo_date'] ?? null;
$todo_texts = $_POST['todo_text'] ?? null; // Expecting an array

if (!$todo_date || !$todo_texts || !is_array($todo_texts)) {
    echo json_encode(["status" => "error", "message" => "Missing fields or invalid todo_text"]);
    exit;
}

// Prepare statement once
$stmt = $conn->prepare("INSERT INTO staff_todo (staff_id, todo_date, todo_text) VALUES (?, ?, ?)");
if (!$stmt) {
    echo json_encode(["status"=>"error","message"=>"Prepare failed: ".$conn->error]);
    exit;
}

$stmt->bind_param("iss", $staff_id, $todo_date, $todo_text_item);

// Use while loop to insert each todo_text
$index = 0;
while ($index < count($todo_texts)) {
    $todo_text_item = $todo_texts[$index];
    if (!$stmt->execute()) {
        echo json_encode(["status" => "error", "message" => "Failed to insert: ".$stmt->error]);
        $stmt->close();
        $conn->close();
        exit;
    }
    $index++;
}

$stmt->close();
$conn->close();

echo json_encode(["status" => "success"]);
?>