<?php
// ajax.php
require_once "../core/db-connect91.php";

header('Content-Type: application/json; charset=utf-8');

$action = $_GET['action'] ?? '';

if ($action === 'get_subjects') {
    $class_id = (int)($_GET['class_id'] ?? 0);
    if ($class_id <= 0) { echo json_encode([]); exit; }
    $sql = "SELECT DISTINCT cs.id, cs.subject_name 
            FROM class_subjects cs
            WHERE cs.class_id = ?";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $class_id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $out = [];
    while ($r = mysqli_fetch_assoc($res)) $out[] = $r;
    echo json_encode($out);
    exit;
}

if ($action === 'get_syllabus') {
    $class_id = (int)($_GET['class_id'] ?? 0);
    $subject_id = (int)($_GET['subject_id'] ?? 0);
    // In your schema syllabus doesn't map subject id directly; the user asked "load syllabus of that class_id and subject"
    // We'll assume subject matches syllabus.subject text OR you may adapt schema.
    // Here we'll fetch syllabus rows by class_id only (since we don't have subject id mapping). If you map subject->syllabus in your db, change query.
    if ($class_id <= 0) { echo json_encode([]); exit; }
    $sql = "SELECT syllabus_id, subject, chapter FROM syllabus WHERE class_id = ? ORDER BY chapter ASC";
    $stmt = mysqli_prepare($conn, $sql);
    mysqli_stmt_bind_param($stmt, "i", $class_id);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    $out = [];
    while ($r = mysqli_fetch_assoc($res)) $out[] = $r;
    echo json_encode($out);
    exit;
}

echo json_encode([]);
exit;
?>