<?php
session_start();
header('Content-Type: application/json');
require_once "../core/db-connect91.php";

if (!isset($_SESSION['staff_id'])) {
    echo json_encode([]);
    exit;
}

$staff_id = $_SESSION['staff_id'];

if (isset($_POST['todo_date'])) {
    $date = $_POST['todo_date'];
    $stmt = $conn->prepare("SELECT todo_id, todo_text FROM staff_todo WHERE staff_id = ? AND todo_date = ?");
    $stmt->bind_param("is", $staff_id, $date);
    $stmt->execute();
    $result = $stmt->get_result();
    $todos = $result->fetch_all(MYSQLI_ASSOC);
    echo json_encode($todos);
    exit;
}

if (isset($_POST['month'])) {
    $month = $_POST['month']; // e.g. 2025-09
    $stmt = $conn->prepare("SELECT todo_date, COUNT(*) as cnt FROM staff_todo WHERE staff_id = ? AND DATE_FORMAT(todo_date,'%Y-%m') = ? GROUP BY todo_date");
    $stmt->bind_param("is", $staff_id, $month);
    $stmt->execute();
    $result = $stmt->get_result();

    $counts = [];
    while ($row = $result->fetch_assoc()) {
        $counts[$row['todo_date']] = $row['cnt'];
    }
    echo json_encode($counts);
    exit;
}

echo json_encode([]);
?>