<?php
include '../core/db-connect91.php'; // Your DB connection

$semester = isset($_GET['semester']) ? $_GET['semester'] : '1';

$sql = "
    SELECT 
        c.class_name,
        SUM(CASE WHEN sf.payment_status='paid' THEN 1 ELSE 0 END) AS paid_count,
        SUM(CASE WHEN sf.payment_status IN ('unpaid','partially_paid') THEN 1 ELSE 0 END) AS unpaid_count
    FROM classes c
    LEFT JOIN student_fees sf 
        ON c.class_id = sf.class_id AND sf.semester = '$semester'
    GROUP BY c.class_name
    ORDER BY CAST(SUBSTRING_INDEX(c.class_name, ' ', -1) AS UNSIGNED)
";

$result = $conn->query($sql);

$classes = [];
$paid = [];
$unpaid = [];

while ($row = $result->fetch_assoc()) {
    $classes[] = $row['class_name'];
    $paid[] = (int)$row['paid_count'];
    $unpaid[] = (int)$row['unpaid_count'];
}

$conn->close();

echo json_encode([
    'classes' => $classes,
    'paid' => $paid,
    'unpaid' => $unpaid
]);
?>