<?php    
require_once "../core/db-connect91.php";    

// Pagination
$limit = 20;    
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;    
$offset = ($page - 1) * $limit;    

// Search    
$search = isset($_GET['search']) ? trim($_GET['search']) : "";    

// Sorting    
$sort_column = isset($_GET['sort']) ? $_GET['sort'] : "f.id";    
$sort_order = isset($_GET['order']) && strtolower($_GET['order']) === "asc" ? "ASC" : "DESC";    

// Allowed columns    
$allowed_columns = [    
    "id" => "f.id",    
    "batch" => "f.batch",    
    "name" => "s.student_name",    
    "class" => "s.student_class",    
    "gr_no" => "s.student_gr_no",    
    "payment_status" => "f.payment_status",    
    "total_amount" => "f.total_amount",    
    "payment_amount" => "f.payment_amount",    
    "due_amount" => "f.due_amount",    
    "payment_received_date" => "f.payment_received_date",    
    "payment_method" => "f.payment_method",    
    "received_by" => "st.staff_name"    
];
if (!array_key_exists($sort_column, $allowed_columns)) {    
    $sort_column = "id";    
}    
$order_by = $allowed_columns[$sort_column] . " " . $sort_order;    

// WHERE clause for search    
$where = "";    
if ($search !== "") {    
    $search_esc = $conn->real_escape_string($search);    
    $where = "WHERE     
        f.id LIKE '%$search_esc%' OR    
        s.student_name LIKE '%$search_esc%' OR    
        s.student_surname LIKE '%$search_esc%' OR    
        s.student_fathername LIKE '%$search_esc%' OR    
        f.payment_amount LIKE '%$search_esc%' OR    
        f.payment_status LIKE '%$search_esc%' OR    
        f.payment_received_date LIKE '%$search_esc%'";    
}    

// Count total
$count_sql = "SELECT COUNT(*) AS total     
              FROM fee_payment_history f    
              JOIN students s ON f.student_id = s.student_id    
              $where";    
$count_res = $conn->query($count_sql);    
$total_records = $count_res->fetch_assoc()['total'];    
$total_pages = ceil($total_records / $limit);    

// Fetch data with staff join
$sql = "SELECT 
            f.*, 
            s.student_name, s.student_surname, s.student_fathername,
            s.student_class, s.student_division, s.student_gr_no,
            st.staff_name AS received_name, st.staff_surname AS received_surname, st.staff_fathername AS received_fathername
        FROM fee_payment_history f    
        JOIN students s ON f.student_id = s.student_id    
        LEFT JOIN staff st ON f.payment_received_by = st.staff_id
        $where    
        ORDER BY $order_by    
        LIMIT $limit OFFSET $offset";    

$res = $conn->query($sql);    

// Build table    
echo '<div class="is-scrollbar-hidden min-w-full overflow-x-auto">';    
echo '<table class="w-full text-left">    
        <thead>    
            <tr>    

        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'id\')">#</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'batch\')">Batch / Sem</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'name\')">Student Name</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'class\')">Class / Div</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'gr_no\')">GR No</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'payment_status\')">Status</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'total_amount\')">Total</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'payment_amount\')">Paid</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'due_amount\')">Due</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'payment_received_date\')">Date</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'payment_method\')">Payment Method</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Payment Details</th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">
            <a href="#" onclick="sortTable(\'received_by\')">Received By</a>
        </th>    
        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800">Payment No / Invoice</th>    

            </tr>    
        </thead>    
        <tbody>';
if ($res->num_rows > 0) {    
    $sr_no = $offset + 1;    

    
    while ($row = $res->fetch_assoc()) {    

        // Payment details logic
        $payment_details = "";
        switch (strtolower($row['payment_method'])) {
            case 'cash':
                $payment_details = 
                    "₹10: {$row['cash_10']}, ₹20: {$row['cash_20']}, ₹50: {$row['cash_50']}, ₹100: {$row['cash_100']}<br>" .
                    "₹200: {$row['cash_200']}, ₹500: {$row['cash_500']}, ₹2000: {$row['cash_2000']}, Other: {$row['cash_other']}";
                break;
            case 'cheque':
                $payment_details = "Cheque #: {$row['cheque_number']}<br>Bank: {$row['bank_name']}<br>IFSC: {$row['ifsc_code']}";
                break;
            case 'dd':
                $payment_details = "DD #: {$row['dd_number']}<br>Bank: {$row['bank_name']}<br>IFSC: {$row['ifsc_code']}";
                break;
            case 'card':
                $payment_details = "Card Last 4: {$row['card_last4']}";
                break;
            case 'upi':
                $payment_details = "UPI ID: {$row['upi_id']}";
                break;
            case 'wallet':
                $payment_details = "Wallet: {$row['wallet_name']}";
                break;
            default:
                $payment_details = $row['other_description'];
        }

        // Staff received by full name
        $received_by = trim("{$row['received_surname']} {$row['received_name']} {$row['received_fathername']}");

        echo "<tr>    
                <td class='whitespace-nowrap px-4 py-3'>{$sr_no}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['batch']} / {$row['semester']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['student_surname']} {$row['student_name']} {$row['student_fathername']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['student_class']} / {$row['student_division']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['student_gr_no']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['payment_status']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['total_amount']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['payment_amount']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['due_amount']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['payment_received_date']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$row['payment_method']}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$payment_details}</td>    
                <td class='whitespace-nowrap px-4 py-3'>{$received_by}</td>    
                <td class='whitespace-nowrap px-4 py-3'><a href='{$website}{$row['invoice_file']}' target='_blank'>{$row['payment_number']}</a></td>    
              </tr>";    
        $sr_no++;
    }    
} else {    
    echo "<tr><td colspan='14'>No records found</td></tr>";    
}    

echo '</tbody></table></div>';    

// Pagination
echo '<div class="mt-5" style="overflow:auto;">
        <ol class="pagination space-x-1.5">';

// Previous button
$prev_page = max(1, $page - 1);
echo '<li>
        <a href="#" onclick="loadPayments('.$prev_page.')"
          class="flex size-8 items-center justify-center rounded-lg bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7" />
          </svg>
        </a>
      </li>';

// Page numbers
for ($i = 1; $i <= $total_pages; $i++) {
    if ($i == $page) {
        // Active page
        echo '<li>
                <a href="#" onclick="loadPayments('.$i.')"
                  class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg bg-primary px-3 leading-tight text-white transition-colors hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                  '.$i.'
                </a>
              </li>';
    } else {
        // Inactive page
        echo '<li>
                <a href="#" onclick="loadPayments('.$i.')"
                  class="flex h-8 min-w-[2rem] items-center justify-center rounded-lg bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
                  '.$i.'
                </a>
              </li>';
    }
}

// Next button
$next_page = min($total_pages, $page + 1);
echo '<li>
        <a href="#" onclick="loadPayments('.$next_page.')"
          class="flex size-8 items-center justify-center rounded-lg bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90">
          <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7" />
          </svg>
        </a>
      </li>';

echo '</ol>
      </div>';
?>
