
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>
<script src="https://unpkg.com/maplibre-gl/dist/maplibre-gl.js"></script>
<link href="https://unpkg.com/maplibre-gl/dist/maplibre-gl.css" rel="stylesheet" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">




  <style>
    #map { height: 500px; width: 100%; }
  </style>


  
  
<div class="card space-y-5 p-4 sm:p-5">
  
  
<label class="block">
  <span class="font-medium text-slate-600 dark:text-navy-100">Select Bus</span>
  <select onchange="loadRoute(this.value)" name="bus_id"
    class="mt-1.5 w-full"
    x-init="$el._x_tom = new Tom($el,{create: false,sortField: {field: 'text',direction: 'asc'}})"
  >
    <option value="">Select Bus</option>
    <?php 
    // Fetch buses
    $busQuery = "SELECT bus_id, bus_number, vehicle_reg_number FROM buses WHERE status='active'";
    $busResult = $conn->query($busQuery);

    while($busRow = $busResult->fetch_assoc()) {
        $busDisplay = $busRow['bus_number']." (".$busRow['vehicle_reg_number'].")"; 
        $busValue = $busRow['bus_id']; // store bus_id
        $selected = ($bus_id == $busValue) ? "selected" : "";
        echo "<option value='$busValue' $selected>$busDisplay</option>";
    }
    ?>
  </select>
</label>
  
 </div> 

<div class="mt-6" id="map" style="width:100%; height:500px;"></div>







  <script>
    var map = new maplibregl.Map({
      container: 'map',
      style: 'https://api.maptiler.com/maps/streets/style.json?key=kJuFa7uSH230qvFgSicv', // replace with your free key
      center: [72.8311, 21.1702], // Surat
      zoom: 12
    });

    async function loadRoute(bus_id) {
      const res = await fetch("supporting/get-bus-route.php?bus_id=" + bus_id);
      const data = await res.json();
      if (data.length === 0) return;

      let geojson = {
        "type": "FeatureCollection",
        "features": [{
          "type": "Feature",
          "geometry": {
            "type": "LineString",
            "coordinates": data.map(p => [parseFloat(p.lon), parseFloat(p.lat)])
          }
        }]
      };

      if (map.getSource("route")) {
        map.removeLayer("routeLine");
        map.removeSource("route");
      }

      map.addSource("route", { type: "geojson", data: geojson });
      map.addLayer({
        "id": "routeLine",
        "type": "line",
        "source": "route",
        "paint": { "line-color": "#FF0000", "line-width": 4 }
      });

      new maplibregl.Marker({ color: "green" })
        .setLngLat([data[0].lon, data[0].lat])
        .setPopup(new maplibregl.Popup().setText("Start"))
        .addTo(map);

      new maplibregl.Marker({ color: "red" })
        .setLngLat([data[data.length-1].lon, data[data.length-1].lat])
        .setPopup(new maplibregl.Popup().setText("Current"))
        .addTo(map);

      let bounds = new maplibregl.LngLatBounds();
      data.forEach(p => bounds.extend([parseFloat(p.lon), parseFloat(p.lat)]));
      map.fitBounds(bounds, { padding: 50 });
    }
  </script>












  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

  </body>
</html>