
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">

<!-- export-form.php -->

  


<?php


// --- 2) Fetch leaves joined with student info ---
$sql = "
  SELECT
    sl.leave_id,
    sl.student_id,
    sl.leave_date,
    sl.leave_type,
    sl.reason,
    sl.status        AS leave_status,
    sl.applied_at,
    s.student_image,
    s.student_name,
    s.student_surname,
    s.student_fathername,
    s.student_class,
    s.student_division
  FROM student_leaves AS sl
  JOIN students      AS s ON sl.student_id = s.student_id
  ORDER BY sl.applied_at DESC
";
$result = $conn->query($sql);
?>

<div>
  <div class="flex items-center justify-between">
    <!-- … your header/search/popover markup … -->
  </div>
  <div class="card mt-3">
    <div class="is-scrollbar-hidden min-w-full overflow-x-auto">
      <table class="is-hoverable w-full text-left">
        <thead>
          <tr>
            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">#</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Avatar</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Father Name</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Class / Div</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Leave Type</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Applied At</th>
            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Status</th>
            <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result && $result->num_rows): ?>
            <?php $i = 1; ?>
            <?php while($row = $result->fetch_assoc()): ?>

<?php
$status = strtolower(trim($row['leave_status'])); // normalize

$bgStyle = '';

if ($status === 'approved') {
    $bgStyle = 'background-color:#d1fae5;'; // light green
} elseif ($status === 'rejected') {
    $bgStyle = 'background-color:#fee2e2;'; // light red
} elseif ($status === 'pending') {
    $bgStyle = 'background-color:#fef9c3;'; // light yellow
}
?>

    <!-- table data here -->

<tr style="<?= $bgStyle ?>" class="border-y border-transparent border-b-slate-200 dark:border-b-navy-500">
                <td class="whitespace-nowrap px-4 py-3 sm:px-5"><?= $i++ ?></td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <div class="avatar flex size-10">
                    <img class="mask is-squircle"
                         src="<?= htmlspecialchars($row['student_image']) ?>"
                         alt="avatar" />
                  </div>
                </td>
                <td class="whitespace-nowrap px-3 py-3 font-medium text-slate-700 dark:text-navy-100 lg:px-5">
                  <?= htmlspecialchars($row['student_name'] . ' ' . $row['student_surname']) ?>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <?= htmlspecialchars($row['student_fathername']) ?>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <?= htmlspecialchars($row['student_class'] . ' / ' . $row['student_division']) ?>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <?= htmlspecialchars($row['leave_type']) ?>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <?= date('d M, Y', strtotime($row['applied_at'])) ?>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <!--  Select box to change status  -->
                  <select
                    class="form-select rounded-full border border-slate-300 bg-white px-2 py-1 pr-6 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:hover:border-navy-400 dark:focus:border-accent"
                    onchange="updateLeaveStatus(<?= $row['leave_id'] ?>, this.value)"
                  >
                    <?php
                      $statuses = ['pending','approved','rejected'];
                      foreach($statuses as $st):
                        $sel = $st === $row['leave_status'] ? 'selected' : '';
                    ?>
                      <option value="<?= $st ?>" <?= $sel ?>><?= $st ?></option>
                    <?php endforeach; ?>
                  </select>
                </td>
                <td class="whitespace-nowrap px-4 py-3 sm:px-5">
                  <!-- your existing Action popper/button -->
                  <div x-data="usePopper({placement:'bottom-end',offset:4})" @click.outside="isShowPopper && (isShowPopper = false)" class="inline-flex">
                    <button x-ref="popperRef" @click="isShowPopper = !isShowPopper" class="btn size-8 rounded-full p-0 hover:bg-slate-300/20 focus:bg-slate-300/20 active:bg-slate-300/25 dark:hover:bg-navy-300/20 dark:focus:bg-navy-300/20 dark:active:bg-navy-300/25">
                      <svg xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h.01M12 12h.01M19 12h.01M6 12a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0zm7 0a1 1 0 11-2 0 1 1 0 012 0z"/>
                      </svg>
                    </button>
                    <div x-ref="popperRoot" class="popper-root" :class="isShowPopper && 'show'">
                      <!-- … popper menu … -->
                    </div>
                  </div>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr>
              <td colspan="9" class="text-center py-4">No leave requests found.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <!-- … your pagination footer … -->

  </div>
</div>

<script>
function updateLeaveStatus(leaveId, newStatus) {

  fetch('supporting/update-leave-status.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({ leave_id: leaveId, status: newStatus })
  })
  .then(res => res.text()) // catch raw text
  .then(text => {

    try {
      const data = JSON.parse(text);
if (data.success) {
    // Show success modal
    window.dispatchEvent(new CustomEvent('open-modal', {
        detail: {
            type: 'success',
            message: 'Your request was completed successfully!'
        }
    }));
} else {
    // Show error modal
    window.dispatchEvent(new CustomEvent('open-modal', {
        detail: {
            type: 'error',
            message: data.message || 'Something went wrong. Please try again.'
        }
    }));
}
    } catch (e) {

    }
  })
  .catch(error => {

  });
}
</script>

<div x-data="{ showModal: false, type: '', message: '' }"
     @open-modal.window="
        showModal = true;
        type = $event.detail.type;
        message = $event.detail.message;
     ">

<style>
  .modal-overlay {
    background: rgba(15, 23, 42, 0.7);
    backdrop-filter: blur(4px);
  }
  .modal-card {
    width: 100%;
    max-width: 28rem;
    border-radius: 1rem;
    background: #fff;
    box-shadow: 0 25px 50px -12px rgba(0,0,0,0.25);
    transition: all 0.3s ease;
  }
  .modal-header {
    display: flex;
    flex-direction: column;
    align-items: center;
    padding: 2rem 1.5rem;
  }
  .icon-circle {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 5rem;
    width: 5rem;
    border-radius: 50%;
  }
  .success-bg { background: #dcfce7; color: #16a34a; }
  .error-bg { background: #fee2e2; color: #dc2626; }
  .modal-title {
    margin-top: 1rem;
    font-size: 1.5rem;
    font-weight: 700;
    letter-spacing: 0.5px;
  }
  .success-text { color: #16a34a; }
  .error-text { color: #dc2626; }
  .modal-message {
    margin-top: 0.5rem;
    text-align: center;
    color: #475569;
    line-height: 1.6;
  }
  .modal-footer {
    display: flex;
    justify-content: center;
    gap: 0.75rem;
    padding: 1rem 1.5rem;
    border-top: 1px solid #e2e8f0;
  }
  .btmnsu {
    padding: 0.5rem 1.25rem;
    border-radius: 0.5rem;
    font-weight: 500;
    cursor: pointer;
    transition: all 0.2s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.15);
    color: #fff;
  }
  .btmnsu-success { background: #16a34a; }
  .btmnsu-success:hover { background: #15803d; }
  .btmnsu-error { background: #dc2626; }
  .btmnsu-error:hover { background: #b91c1c; }
</style>

<template x-teleport="body">
  <div class="fixed inset-0 z-[200] flex items-center justify-center px-4 py-6 sm:px-5"
       x-show="showModal"
       role="dialog"
       @keydown.window.escape="showModal = false">

    <!-- Overlay -->
    <div class="absolute inset-0 modal-overlay"
         @click="showModal = false"
         x-show="showModal"
         x-transition.opacity></div>

    <!-- Modal -->
    <div class="relative modal-card"
         x-show="showModal"
         x-transition.scale.opacity>

      <!-- Header -->
      <div class="modal-header">
        <div class="icon-circle"
             :class="type === 'success' ? 'success-bg' : 'error-bg'">
          <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg" 
               class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg" 
               class="h-12 w-12" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                  d="M6 18L18 6M6 6l12 12"/>
          </svg>
        </div>

        <h2 class="modal-title"
            :class="type === 'success' ? 'success-text' : 'error-text'">
          <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
        </h2>

        <p class="modal-message" x-text="message"></p>
      </div>

      <!-- Footer -->
      <div class="modal-footer">
        <button @click="showModal = false"
                class="btmnsu"
                :class="type === 'success' ? 'btmnsu-success' : 'btmnsu-error'">
          Close
        </button>
      </div>
    </div>
  </div>
</template>
</div>
  
  
  
  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>
er("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>irectives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>