

<?php
// Turn on error logging
ini_set("log_errors", 1);

// Set custom error log file
ini_set("error_log", __DIR__ . "/error_log1.txt");

// Hide errors from user
ini_set("display_errors", 0);
error_reporting(E_ALL);

// Example: force an error for testing
// echo $undefinedVar;
?>
<?php
require_once "core/db-connect91.php";

?>



<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">






<style>
/* simple clean form styles */
body { font-family: Arial, Helvetica, sans-serif; background:#f7f7f7; padding:20px; }
.container { max-width:900px; margin:0 auto; background:#fff; padding:20px; border-radius:8px; box-shadow:0 4px 12px rgba(0,0,0,.06); }
h1 { margin-top:0; }
.form-row { display:flex; gap:12px; margin-bottom:12px; align-items:center; }
.form-row label { width:160px; font-weight:600; }
select, input[type="number"], input[type="text"] { padding:8px; width:100%; border:1px solid #ccc; border-radius:4px; }
.checkbox-inline { display:inline-flex; align-items:center; gap:8px; }
.syllabus-list { border:1px solid #ddd; padding:8px; max-height:150px; overflow:auto; background:#fafafa; }
.btn { padding:10px 16px; border:none; border-radius:6px; cursor:pointer; }
.btn-primary { background:#2b6cb0; color:#fff; }
.small { font-size:13px; color:#666; }
.note { background:#fff8c4; padding:8px; border-radius:4px; margin-bottom:12px; }
.logo-preview { height:60px; }
</style>

<div class="container">
  <h1>Question Paper Generator (Test)</h1>
  <p class="small">Using your test data in <code>questions_answers</code>. Select class → subject → syllabus and then choose counts per marks.</p>

  <form id="qpForm" method="post" action="generate_pdf.php" target="_blank">
    <div class="form-row">
      <label for="class_id">Class</label>
      <select id="class_id" name="class_id" required>
        <option value="">-- Select class --</option>
        <?php
        // load classes from DB
        $q = "SELECT DISTINCT class_id, class_name, division FROM classes ORDER BY class_name, division";
        $res = mysqli_query($conn, $q);
        while ($r = mysqli_fetch_assoc($res)) {
            $val = (int)$r['class_id'];
            $label = htmlspecialchars($r['class_name'] . ' - ' . $r['division']);
            echo "<option value=\"{$val}\">{$label}</option>";
        }
        ?>
      </select>
    </div>

    <div class="form-row">
      <label for="subject_id">Subject</label>
      <select id="subject_id" name="subject_id" required>
        <option value="">-- Select subject --</option>
      </select>
    </div>

    <div class="form-row">
      <label>Syllabus (select one or more)</label>
      <div class="syllabus-list" id="syllabus_box">
        <div class="small">Select class & subject first.</div>
      </div>
    </div>

    <div class="form-row">
      <label for="language_code">Language</label>
      <select id="language_code" name="language_code" required>
        <option value="gu">Gujarati</option>
        <option value="en">English</option>
        <option value="mr">Marathi</option>
      </select>
    </div>

    <div class="form-row">
      <label>Questions required</label>
      <div style="flex:1; display:grid; grid-template-columns: repeat(3,1fr); gap:8px;">
        <div>
          <label class="small">2 marks</label>
          <input type="number" name="marks_count[2]" min="0" value="20" />
        </div>
        <div>
          <label class="small">3 marks</label>
          <input type="number" name="marks_count[3]" min="0" value="10" />
        </div>
        <div>
          <label class="small">5 marks</label>
          <input type="number" name="marks_count[5]" min="0" value="6" />
        </div>
      </div>
    </div>

    <div class="form-row">
      <label>Include Answers?</label>
      <div>
        <label class="checkbox-inline"><input type="checkbox" name="include_answers" value="1" /> Generate Answers</label>
      </div>
    </div>

    <div class="form-row">
      <label>School Header</label>
      <div>
        <input type="text" name="school_name" placeholder="School name (will appear on header)" />
        <input type="text" name="school_address" placeholder="School address / details" style="margin-top:6px;" />
        <input type="text" name="instructions" placeholder="Instructions (first page header area)" style="margin-top:6px;" />
      </div>
    </div>

    <div style="margin-top:16px;">
      <button type="submit" class="btn btn-primary">Generate PDF</button>
      <span class="small" style="margin-left:12px;">PDF will open in a new tab/window</span>
    </div>
  </form>
</div>

<script>
document.getElementById('class_id').addEventListener('change', function(){
  var classId = this.value;
  var subjectSelect = document.getElementById('subject_id');
  subjectSelect.innerHTML = '<option>Loading...</option>';
  fetch('supporting/question-paper-ajax.php?action=get_subjects&class_id=' + encodeURIComponent(classId))
    .then(r => r.json())
    .then(data => {
      subjectSelect.innerHTML = '<option value="">-- Select subject --</option>';
      data.forEach(function(s){
        var opt = document.createElement('option');
        opt.value = s.id;
        opt.textContent = s.subject_name;
        subjectSelect.appendChild(opt);
      });
      document.getElementById('syllabus_box').innerHTML = '<div class="small">Select subject to load syllabus.</div>';
    })
    .catch(err => {
      subjectSelect.innerHTML = '<option value="">-- Error --</option>';
      console.error(err);
    });
});

document.getElementById('subject_id').addEventListener('change', function(){
  var classId = document.getElementById('class_id').value;
  var subjectId = this.value;
  var box = document.getElementById('syllabus_box');
  box.innerHTML = 'Loading...';
  fetch('supportinf/question-paper-ajax.php?action=get_syllabus&class_id=' + encodeURIComponent(classId) + '&subject_id=' + encodeURIComponent(subjectId))
    .then(r => r.json())
    .then(data => {
      if (!data.length) {
        box.innerHTML = '<div class="small">No syllabus entries found for this class & subject.</div>';
        return;
      }
      var html = '<div>';
      data.forEach(function(s){
        html += '<label style="display:block;margin-bottom:6px;"><input type="checkbox" name="syllabus_ids[]" value="'+s.syllabus_id+'" checked /> ' + s.chapter + '</label>';
      });
      html += '</div>';
      box.innerHTML = html;
    })
    .catch(err => {
      box.innerHTML = '<div class="small">Error loading syllabus.</div>';
      console.error(err);
    });
});
</script>



  </div>
</div>
      </main>
    </div>
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>

