<?php
// Show all PHP errors
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Start session

?>
<?php
require_once "core/db-connect91.php";
require_once '../library/dompdf/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;


mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
?>

<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Make sure $conn is your active mysqli connection here

    // Collect inputs safely
    $student_id          = $_SESSION["student_id"] ?? 0;
    $batch               = $_SESSION["selected_batch"] ?? '';
    $semester            = $_POST["semester"] ?? 0;
    $payment_method      = $_POST["payment_method"] ?? '';
    $payment_amount      = $_POST["payable_amount"] ?? 0;
    $total_amount        = $_SESSION["total_amount"] ?? 0;
    $payment_received_by = $_SESSION["staff_id"] ?? '';

    // Sanitize numeric inputs
    $payment_amount = is_numeric($payment_amount) ? (float)$payment_amount : 0.00;
    $total_amount   = is_numeric($total_amount) ? (float)$total_amount : 0.00;

    // ====== VALIDATION SECTION ======
    $errors = [];

    if (empty($student_id) || $student_id <= 0) {
        $errors[] = "Invalid or missing student ID.";
    }
    if (empty($payment_received_by) || $payment_received_by <= 0) {
        $errors[] = "Invalid or missing staff ID.";
    }
    if (empty($payment_method)) {
        $errors[] = "Payment method is required.";
    }
    if ($total_amount <= 0) {
        $errors[] = "Total amount must be greater than 0.";
    }
    if ($payment_amount <= 0) {
        $errors[] = "Payable amount must be greater than 0.";
    }
    if ($payment_amount > $total_amount) {
        $errors[] = "Payable amount cannot be greater than the total amount.";
    }

    // If there are any validation errors, stop execution
if (!empty($errors)) {
    $message = "Error: " . implode(", ", $errors);
    $messageType = "error";

} else {






    // ====== END VALIDATION ======

$sumQuery = "
    SELECT SUM(payment_amount) AS totalPaid
    FROM fee_payment_history
    WHERE student_id = $student_id
      AND semester = $semester
      AND batch = '$batch'
";
$sumResult = $conn->query($sumQuery);
$totalPaidAmount = 0;
if ($sumResult && $sumResult->num_rows > 0) {
    $sumData = $sumResult->fetch_assoc();
    $totalPaidAmount = (float)$sumData['totalPaid'];
}
$due_amount = $total_amount - $totalPaidAmount - $payment_amount;
$due_amount = is_numeric($due_amount) ? (float)$due_amount : 0.00;

if ($due_amount <= 0) {
    $payment_status = 'paid';
    $due_amount = 0;
} elseif ($payment_amount > 0 && $due_amount > 0) {
    $payment_status = 'partial';
} else {
    $payment_status = 'unpaid';
}

    $payment_number = 'PAY' . date('Ymd') . strtoupper(substr(uniqid(), -6));

    // Cast cash inputs to int or 0
    $cash_10 = isset($_POST["cash_10"]) && is_numeric($_POST["cash_10"]) ? (int)$_POST["cash_10"] : 0;
    $cash_20 = isset($_POST["cash_20"]) && is_numeric($_POST["cash_20"]) ? (int)$_POST["cash_20"] : 0;
    $cash_50 = isset($_POST["cash_50"]) && is_numeric($_POST["cash_50"]) ? (int)$_POST["cash_50"] : 0;
    $cash_100 = isset($_POST["cash_100"]) && is_numeric($_POST["cash_100"]) ? (int)$_POST["cash_100"] : 0;
    $cash_200 = isset($_POST["cash_200"]) && is_numeric($_POST["cash_200"]) ? (int)$_POST["cash_200"] : 0;
    $cash_500 = isset($_POST["cash_500"]) && is_numeric($_POST["cash_500"]) ? (int)$_POST["cash_500"] : 0;
    $cash_2000 = isset($_POST["cash_2000"]) && is_numeric($_POST["cash_2000"]) ? (int)$_POST["cash_2000"] : 0;
    $cash_other = isset($_POST["cash_other"]) && is_numeric($_POST["cash_other"]) ? (float)$_POST["cash_other"] : 0.00;

    // Other inputs (strings or null)
    $cheque_number     = $_POST["cheque_number"] ?? '';
    $dd_number         = $_POST["dd_number"] ?? '';
    $bank_name         = $_POST["bank_name"] ?? '';
    $ifsc_code         = $_POST["ifsc_code"] ?? '';
    $card_last4        = $_POST["card_last4"] ?? '';
    $upi_id            = $_POST["upi_id"] ?? '';
    $wallet_name       = $_POST["wallet_name"] ?? '';
    $transaction_id    = $_POST["transaction_id"] ?? '';
    $receipt_number    = $_POST["receipt_number"] ?? '';
    $external_reference= $_POST["external_reference"] ?? '';
    $other_description = $_POST["other_description"] ?? '';
    $logs              = $_POST["logs"] ?? '';
    $created_by        = $_SESSION["staff_id"] ?? '';

    // Escape strings for SQL
    $payment_number      = $conn->real_escape_string($payment_number);
    $batch               = $conn->real_escape_string($batch);
    $payment_method      = $conn->real_escape_string($payment_method);
    $payment_status      = $conn->real_escape_string($payment_status);
    $payment_received_by = $conn->real_escape_string($payment_received_by);
    $cheque_number       = $conn->real_escape_string($cheque_number);
    $dd_number           = $conn->real_escape_string($dd_number);
    $bank_name           = $conn->real_escape_string($bank_name);
    $ifsc_code           = $conn->real_escape_string($ifsc_code);
    $card_last4          = $conn->real_escape_string($card_last4);
    $upi_id              = $conn->real_escape_string($upi_id);
    $wallet_name         = $conn->real_escape_string($wallet_name);
    $transaction_id      = $conn->real_escape_string($transaction_id);
    $receipt_number      = $conn->real_escape_string($receipt_number);
    $external_reference  = $conn->real_escape_string($external_reference);
    $other_description   = $conn->real_escape_string($other_description);
    $logs                = $conn->real_escape_string($logs);
    $created_by          = $conn->real_escape_string($created_by);


// 1️⃣ Calculate total paid amount so far


    $sql = "INSERT INTO fee_payment_history (
        payment_number, student_id, batch, semester, payment_method,
        payment_amount, due_amount, total_amount, payment_status, payment_received_by,
        cash_10, cash_20, cash_50, cash_100, cash_200, cash_500, cash_2000, cash_other,
        cheque_number, dd_number, bank_name, ifsc_code, card_last4,
        upi_id, wallet_name, transaction_id, receipt_number, external_reference,
        other_description, logs, created_by
    ) VALUES (
        '$payment_number', $student_id, '$batch', $semester, '$payment_method',
        $payment_amount, $due_amount, $total_amount, '$payment_status', '$payment_received_by',
        $cash_10, $cash_20, $cash_50, $cash_100, $cash_200, $cash_500, $cash_2000, $cash_other,
        '$cheque_number', '$dd_number', '$bank_name', '$ifsc_code', '$card_last4',
        '$upi_id', '$wallet_name', '$transaction_id', '$receipt_number', '$external_reference',
        '$other_description', '$logs', '$created_by'
    )";

    if ($conn->query($sql) === TRUE) {

// Assuming payment is already inserted into fee_payment_history
// and we have these variables from payment form:



$student_id = (int)$student_id; // already known from payment

// 1️⃣ Get student GR number, class, division
$sql_student = "
    SELECT student_gr_no, student_class, student_division
    FROM students
    WHERE student_id = $student_id
    LIMIT 1
";
$res_student = $conn->query($sql_student);

if ($res_student && $res_student->num_rows > 0) {
    $stu = $res_student->fetch_assoc();
    $student_gr_no   = $stu['student_gr_no'];
    $student_class   = $stu['student_class'];
    $student_division = $stu['student_division'];

    // 2️⃣ Get class_id from classes table
    $sql_class = "
        SELECT class_id
        FROM classes
        WHERE class_name = '".$conn->real_escape_string($student_class)."'
          AND division = '".$conn->real_escape_string($student_division)."'
        LIMIT 1
    ";
    $res_class = $conn->query($sql_class);

    if ($res_class && $res_class->num_rows > 0) {
        $class_id = (int)$res_class->fetch_assoc()['class_id'];
    } else {
        $class_id = 0; // fallback if not found
    }
} else {
    // Student not found
    $student_gr_no = '';
    $class_id = 0;
}



$total_fee      = $total_amount; // If not available, fetch from fee_structure
$month          = 0; // As you said
$payment_type   = $payment_method;

$payment_id     = $payment_number;
$receiver_id    = $_SESSION['staff_id'];
$payment_date   = date("Y-m-d");
$remarks        = $remarks ?? "";

// 1️⃣ Calculate total paid amount so far
$sum_sql = "
    SELECT SUM(payment_amount) AS total_paid
    FROM fee_payment_history
    WHERE student_id = $student_id
      AND semester = $semester
      AND batch = '$batch'
";
$sum_res = $conn->query($sum_sql);
$total_paid = 0;
if ($sum_res && $sum_res->num_rows > 0) {
    $sum_row = $sum_res->fetch_assoc();
    $total_paid = (float)$sum_row['total_paid'];
}

// 2️⃣ Calculate balance
$balance_amount = $total_fee - $total_paid;

// 3️⃣ Determine payment status
if ($total_paid >= $total_fee) {
    $payment_status = 'paid';
    $balance_amount = 0;
} elseif ($total_paid > 0) {
    $payment_status = 'partially_paid';
} else {
    $payment_status = 'unpaid';
}

// 4️⃣ Check if record exists
$check_sql = "
    SELECT fee_payment_id FROM student_fees
    WHERE student_id = $student_id
      AND semester = $semester
      AND batch = '$batch'
    LIMIT 1
";
$check_res = $conn->query($check_sql);

if ($check_res && $check_res->num_rows > 0) {
    // UPDATE
    $update_sql = "
        UPDATE student_fees
        SET total_fee = $total_fee,
            paid_amount = $total_paid,
            payment_status = '$payment_status',
            month = $month,
            payment_type = '$payment_type',
            transaction_id = '$transaction_id',
            payment_id = '$payment_id',
            payment_receiver_id = '$receiver_id',
            payment_date = '$payment_date',
            remarks = '$remarks',
            timestamp = NOW()
        WHERE student_id = $student_id
          AND semester = $semester
          AND batch = '$batch'
    ";
   $rowm = $conn->query($update_sql);

} else {
    // INSERT
    $insert_sql = "
        INSERT INTO student_fees (
            student_id, student_gr_no, class_id, semester, month, batch,
            total_fee, paid_amount, payment_status,
            payment_type, transaction_id, payment_id, payment_receiver_id,
            payment_date, remarks, timestamp
        ) VALUES (
            $student_id, '$student_gr_no', $class_id, $semester, $month, '$batch',
            $total_fee, $total_paid, '$payment_status',
            '$payment_type', '$transaction_id', '$payment_id', '$receiver_id',
            '$payment_date', '$remarks', NOW()
        )
    ";
  $rowm = $conn->query($insert_sql);
}


    


    
    if ($rowm) {
    $_SESSION['invoice_data'] = [
    'student_id'          => $student_id,
    'semester'            => $semester,
    'batch'               => $batch,
    'payment_id'          => $payment_number
    ];
    
    
    
    
    



// Initialize Dompdf with options
$options = new Options();
$options->set('isRemoteEnabled', true); // Enable external images if needed
$options->set('isHtml5ParserEnabled', true);

$dompdf = new Dompdf($options);

// Capture the HTML output
ob_start();
include 'print-fee-invoice-duplicate.php'; // Or the HTML code itself
$html = ob_get_clean();

// Load HTML
$dompdf->loadHtml($html);

// (Optional) Set paper size and orientation
$dompdf->setPaper('A4', 'portrait');

// Render PDF
$dompdf->render();

// Create a file path to save PDF
$invoice_folder = "../invoices/";
if (!file_exists($invoice_folder)) {
    mkdir($invoice_folder, 0777, true);
}
$invoice_folder2 = "invoices/";
$pdf_file_name = "invoice_{$payment_id}.pdf";
$pdf_file_path = $invoice_folder . $pdf_file_name;
$pdf_file_path2 = $invoice_folder2 . $pdf_file_name;
// Save PDF to server
file_put_contents($pdf_file_path, $dompdf->output());

// Update database with file path
$update_sql = "UPDATE fee_payment_history SET invoice_file = ? WHERE payment_number = ?";
$stmt = $conn->prepare($update_sql);
$stmt->bind_param("ss", $pdf_file_path2, $payment_id);
$stmt->execute();


    $_SESSION['invoice_data'] = [
    'student_id'          => $student_id,
    'semester'            => $semester,
    'batch'               => $batch,
    'payment_id'          => $payment_number
    ];

    
    
    
    
    // Redirect to print page
    header("Location: supporting/print-fee-invoice.php");
    exit;
    }
    
    
    } else {
        echo "Error: " . $conn->error;
    }
    
    $message = 'Payment Added Successfully';
    $messageType = 'success';
    
    
    }

}else {
    // Defaults when page loads first time
    $message = '';
    $messageType = '';
}

?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <!-- Meta tags  -->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta
      name="viewport"
      content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"
    />

    <title><?php echo $school_name; ?></title>
<?php include "layout/favicon.php"; ?>

    <!-- CSS Assets -->
    <link rel="stylesheet" href="../css/app.css" />

    <!-- Javascript Assets -->
    <script src="../js/app.js" defer></script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Poppins:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
      rel="stylesheet"
    />
    <script>
      /**
       * THIS SCRIPT REQUIRED FOR PREVENT FLICKERING IN SOME BROWSERS
       */
      localStorage.getItem("_x_darkMode_on") === "true" &&
        document.documentElement.classList.add("dark");
    </script>
<!-- Include ApexCharts -->

  <script src="http://ajax.googleapis.com/ajax/libs/angularjs/1.4.8/angular.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  </head>

  <body x-data class="is-header-blur" x-bind="$store.global.documentBody">
    <!-- App preloader-->


    <!-- Page Wrapper -->
    <div
      id="root"
      class="min-h-100vh flex grow bg-slate-50 dark:bg-navy-900"
      x-cloak
    >
      <!-- Sidebar -->
<?php include 'layout/sidebar.php'; ?>

      <!-- App Header Wrapper-->
<?php include 'layout/navbar.php'; ?>

      <!-- Mobile Searchbar -->

<?php include 'layout/searchbar.php'; ?>
      <!-- Right Sidebar -->
<?php include 'layout/rightbar.php'; ?>

      <!-- Main Content Wrapper -->
      <main class="main-content w-full pb-8">
      
      
      
      
      
      
      
      
<div
  class="mt-4 grid grid-cols-12 gap-4 px-[var(--margin-x)] transition-all duration-[.25s] sm:mt-5 sm:gap-5 lg:mt-6 lg:gap-6"
>

  <div class="col-span-12 lg:col-span-12">
<?php 
$batch = 2025;

$student_id = $conn->real_escape_string($_SESSION['student_id'] ?? '');
$batch      = $conn->real_escape_string($batch);

$sql = "SELECT * FROM students 
        WHERE student_id = '$student_id'";

$result = $conn->query($sql); // ✅ Run the query
?>
<div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5 lg:grid-cols-3 lg:gap-6 xl:grid-cols-4 mt-6">
<?php
if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {

        // Fetch fee status for this student for current batch
        $sid = (int)$row['student_id'];
        $fee_sql = "
            SELECT semester, total_fee, paid_amount, balance_amount, payment_status
            FROM student_fees
            WHERE student_id = $sid
              AND batch = '$batch'
              AND semester IN (1,2)
            ORDER BY semester ASC
        ";
        $fee_res = $conn->query($fee_sql);

        $fees = [];
        if ($fee_res && $fee_res->num_rows > 0) {
            while ($fee = $fee_res->fetch_assoc()) {
                $fees[(int)$fee['semester']] = $fee;
            }
        }
?>
    <div class="card">
        <div class="p-2 text-right">
            <!-- dropdown actions (static for now) -->
        </div>
        <div class="flex grow flex-col items-center px-4 pb-5 sm:px-5">
            <div class="avatar size-20">
                <img class="rounded-full" src="<?= $row['student_image'] ?: 'images/200x200.png' ?>" alt="avatar"/>
            </div>
            <h3 class="pt-3 text-lg font-medium text-slate-700 dark:text-navy-100">
                <?= $row['student_name']." ".$row['student_surname'] ?>
            </h3>
            <p class="text-xs-plus"><?= $row['student_class']." - ".$row['student_division'] ?></p>
            
            <div class="inline-space mt-3 flex grow flex-wrap items-start">
                <span class="tag rounded-full bg-success/10 text-success">GR: <?= $row['student_gr_no'] ?></span>
                <span class="tag rounded-full bg-success/10 text-success">Mobile: <?= $row['student_phonenumber'] ?></span>
            </div>
            <center>
            <!-- Fee Status -->
            <div class="mt-3 w-full text-xs-plus">
                <?php for ($sem = 1; $sem <= 2; $sem++): ?>
                    <?php if (isset($fees[$sem])): 
                        $f = $fees[$sem];
                        if ($f['payment_status'] === 'paid') {
                            $statusText = "Paid: ₹" . number_format($f['paid_amount'], 2);
                            $statusClass = "bg-success/10 text-success";
                        } elseif ($f['payment_status'] === 'partially_paid') {
                            $statusText = "Partial: ₹" . number_format($f['paid_amount'], 2) . 
                                          " / Due: ₹" . number_format($f['balance_amount'], 2);
                            $statusClass = "bg-warning/10 text-warning";
                        } else {
                            $statusText = "Unpaid";
                            $statusClass = "bg-error/10 text-error";
                        }
                    ?>
                        <div class="mt-1">
                            <span class="tag rounded-full <?= $statusClass ?>">
                                Semester <?= $sem ?> - <?= $statusText ?>
                            </span>
                        </div>
                    <?php else: ?>
                        <div class="mt-1">
                            <span class="tag rounded-full bg-slate-200 text-slate-600">
                                Semester <?= $sem ?> - No record
                            </span>
                        </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
            </center>



<!-- Payment Record Button -->
<div class="mt-5" x-data>
    <button
        @click="$dispatch('open-payment-modal')"
        class="btn bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
    >
        Payment Record
    </button>
</div>
        </div>
    </div>
<?php
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    echo "<p class='text-center col-span-3'>No students found.</p>";
}
?>
</div>



<form method="POST">

<?php
// Get student details from session or DB
$student_id = $_SESSION['student_id'] ?? 0;
$student_sql = "SELECT student_class, student_division, student_gender FROM students WHERE student_id = '$student_id'";
$student_res = $conn->query($student_sql);
$student = $student_res->fetch_assoc();

$class_name   = $student['student_class'];
$division     = $student['student_division'];
$gender       = strtolower($student['student_gender']);


// Get class_id from classes table
$class_sql = "SELECT class_id FROM classes WHERE class_name = '$class_name' AND division = '$division' LIMIT 1";
$class_res = $conn->query($class_sql);
$class_row = $class_res->fetch_assoc();
$class_id  = $class_row['class_id'] ?? 0;
?>
<div class="card mt-4">
    <div class="p-2 text-right"></div>
    <div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
        <label class="block w-full">
            <span>Semester</span>
            <select id="semesterSelect" name="semester" required 
                class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2 
                       hover:border-slate-400 focus:border-primary 
                       dark:border-navy-450 dark:bg-navy-700 
                       dark:hover:border-navy-400 dark:focus:border-accent">
                <option value="0">All</option>
                <option value="1">Semester 1</option>
                <option value="2">Semester 2</option>
            </select>
        </label>
    </div>
</div>

<!-- Container where fee structure will be shown -->
<div id="feeStructureContainer" class="mt-4"></div>

<script>
document.getElementById('semesterSelect').addEventListener('change', function() {
    let sem = this.value;

    fetch('supporting/get-fee-structure.php?class_id=<?= $class_id ?>&batch=<?= $batch ?>&gender=<?= $gender ?>&semester=' + sem)
        .then(res => res.text())
        .then(html => {
            document.getElementById('feeStructureContainer').innerHTML = html;
        });
});
</script>


<!-- Payment Method Select -->
<div class="card mt-4">
    <div class="p-2 text-right"></div>
    <div class="flex grow flex-col items-center px-4 pb-5 sm:px-1 w-full">
        <label class="block w-full">
            <span>Payment Method</span>
            <select id="paymentMethod" name="payment_method" required
                class="mt-1.5 w-full rounded-lg border border-slate-300 bg-transparent px-3 py-2
                       hover:border-slate-400 focus:border-primary
                       dark:border-navy-450 dark:bg-navy-700
                       dark:hover:border-navy-400 dark:focus:border-accent">
                <option value="">Select Payment Method</option>
                <option value="cash">Cash</option>
                <option value="cheque">Cheque</option>
                <option value="upi">UPI</option>
                <option value="debit_card">Debit Card</option>
                <option value="credit_card">Credit Card</option>
                <option value="net_banking">Net Banking</option>
                <option value="neft">NEFT</option>
                <option value="rtgs">RTGS</option>
                <option value="imps">IMPS</option>
                <option value="demand_draft">Demand Draft</option>
                <option value="wallet">Mobile Wallet</option>
                <option value="others">Others</option>
            </select>
        </label>
    </div>
</div>




<script>
// Pass PHP switch value to JS
const allowAdditionalPaymentBox = <?php echo ($switchstatus['fee_payment_additional_data'] == 1 ? 'true' : 'false'); ?>;
</script>
<!-- Payment Details Card -->
<div id="paymentDetailsContainer" class="card mt-4 hidden">
    <div class="p-4 space-y-4" id="paymentDetails"></div>
</div>
<div class="mt-6 grid w-full grid-cols-1 gap-2">                
    <button type="submit" 
        class="btn space-x-2 bg-primary px-0 font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
      >
Submit
    </button>
</div>


</form>
<script>
const methodSelect = document.getElementById("paymentMethod");
const detailsContainer = document.getElementById("paymentDetailsContainer");
const detailsBox = document.getElementById("paymentDetails");

methodSelect.addEventListener("change", function() {
    const method = this.value;
    detailsBox.innerHTML = ""; // Clear old fields
    detailsContainer.classList.add("hidden");
if (!allowAdditionalPaymentBox) {
    return; // Stop here if the feature is OFF
}
    if (!method) return;

    let fields = "";

    switch (method) {
case "cash":
    fields = `
        <h3 class="font-bold">Cash Payment Details</h3>
        ${[10,20,50,100,200,500,2000,'Other'].map(v => `
            <label class="block">
                <span>₹${v} Notes</span>
                <input type="number" data-note-value="${v}" name="cash_${v}" min="0" value="0"
                    class="note-count mt-1.5 w-full rounded-lg border border-slate-300 px-3 py-2" />
            </label>
        `).join("")}
        <div class="mt-4 p-3 bg-gray-100 rounded-lg border border-slate-300">
            <strong>Total Cash Amount: ₹</strong>
            <span id="cashTotal">0</span>
        </div>
    `;
    break;

        case "cheque":
            fields = `
                <h3 class="font-bold">Cheque Payment Details</h3>
                <label class="block">
                    <span>Cheque Number</span>
                    <input type="text" name="cheque_number" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>IFSC Code</span>
                    <input type="text" name="ifsc_code" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "upi":
            fields = `
                <h3 class="font-bold">UPI Payment Details</h3>
                <label class="block">
                    <span>UPI ID</span>
                    <input type="text" name="upi_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Transaction ID</span>
                    <input type="text" name="transaction_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "debit_card":
        case "credit_card":
            fields = `
                <h3 class="font-bold">${method === "debit_card" ? "Debit" : "Credit"} Card Payment Details</h3>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Last 4 Digits of Card</span>
                    <input type="text" name="card_last4" maxlength="4" pattern="[0-9]{4}" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "net_banking":
        case "neft":
        case "rtgs":
        case "imps":
            fields = `
                <h3 class="font-bold">${method.replace("_", " ").toUpperCase()} Payment Details</h3>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>IFSC Code</span>
                    <input type="text" name="ifsc_code" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Transaction ID</span>
                    <input type="text" name="transaction_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "demand_draft":
            fields = `
                <h3 class="font-bold">Demand Draft Payment Details</h3>
                <label class="block">
                    <span>DD Number</span>
                    <input type="text" name="dd_number" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Bank Name</span>
                    <input type="text" name="bank_name" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "wallet":
            fields = `
                <h3 class="font-bold">Mobile Wallet Payment Details</h3>
                <label class="block">
                    <span>Wallet Name</span>
                    <input type="text" name="wallet_name" placeholder="Paytm / Amazon Pay / PhonePe" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
                <label class="block">
                    <span>Transaction ID</span>
                    <input type="text" name="transaction_id" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;

        case "others":
            fields = `
                <h3 class="font-bold">Other Payment Method</h3>
                <label class="block">
                    <span>Description</span>
                    <input type="text" name="other_description" class="mt-1.5 w-full rounded-lg border px-3 py-2" required />
                </label>
            `;
            break;
    }

    detailsBox.innerHTML = fields;
    detailsContainer.classList.remove("hidden");
});


// Event listener for cash calculation
detailsBox.addEventListener("input", function(e) {
    if (methodSelect.value === "cash") {
        let total = 0;
        document.querySelectorAll(".note-count").forEach(input => {
            let count = parseInt(input.value) || 0;
            let value = parseInt(input.dataset.noteValue) || 0;
            if (value === 0 && input.dataset.noteValue === "Other") {
                // Other amount = treat input as value, not count
                total += count;
            } else {
                total += count * value;
            }
        });
        document.getElementById("cashTotal").textContent = total;
    }
});
</script>
  </div>
</div>
      </main>
    </div>
    



<!-- Alpine Modal -->
<div x-data="{ 
        showModal: <?= $message ? 'true' : 'false' ?>, 
        message: '<?= addslashes($message) ?>', 
        type: '<?= $messageType ?>' 
     }">
  <!-- Modal content same as before (success/error with colors) -->
  <template x-teleport="#x-teleport-target">
    <div class="fixed inset-0 z-[100] flex items-center justify-center px-4 py-6 sm:px-5"
         x-show="showModal"
         role="dialog"
         @keydown.window.escape="showModal = false">

      <!-- Overlay -->
      <div class="absolute inset-0 bg-slate-900/60 transition-opacity duration-300"
           @click="showModal = false"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"></div>

      <!-- Modal Content -->
      <div class="scrollbar-sm relative flex max-w-lg flex-col overflow-y-auto rounded-lg px-4 py-10 text-center transition-opacity duration-300 sm:px-5"
           x-show="showModal"
           x-transition:enter="ease-out"
           x-transition:enter-start="opacity-0"
           x-transition:enter-end="opacity-100"
           x-transition:leave="ease-in"
           x-transition:leave-start="opacity-100"
           x-transition:leave-end="opacity-0"
           :class="type === 'success' ? 'bg-white dark:bg-navy-700' : 'bg-white border border-red-500 dark:bg-navy-700'">

        <!-- Icon based on type -->
        <svg x-show="type === 'success'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-success"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
        </svg>

        <svg x-show="type === 'error'" xmlns="http://www.w3.org/2000/svg"
             class="mx-auto inline size-28 shrink-0 text-red-600"
             fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M6 18L18 6M6 6l12 12"/>
        </svg>

        <div class="mt-4">
          <h2 class="text-2xl font-bold"
              :class="type === 'success' ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400'">
            <span x-text="type === 'success' ? 'Success!' : 'Error!'"></span>
          </h2>
          <p class="mt-2 text-slate-600 dark:text-slate-200" x-text="message"></p>

          <button @click="showModal = false"
                  class="btn mt-6 font-medium text-white"
                  :class="type === 'success' ? 'bg-success hover:bg-success-focus' : 'bg-red-600 hover:bg-red-700'">
            Close
          </button>
        </div>
      </div>
    </div>
  </template>
</div>



<!-- Payment History Modal -->
<div x-data="{ showModal: false, paymentHistory: [] }" 
     @open-payment-modal.window="
         showModal = true; 
         fetch('supporting/fetch-fee-payment-history.php')
            .then(res => res.json())
            .then(data => paymentHistory = data)
            .catch(() => paymentHistory = [])
     "
     x-cloak>
    
    <template x-teleport="#x-teleport-target">
        <div
            class="fixed inset-0 z-[100] flex flex-col items-center justify-center overflow-hidden px-4 py-6 sm:px-5"
            x-show="showModal"
            role="dialog"
            @keydown.window.escape="showModal = false"
        >
            <!-- Overlay -->
            <div
                class="absolute inset-0 bg-slate-900/60 backdrop-blur-sm transition-opacity duration-300"
                @click="showModal = false"
                x-show="showModal"
                x-transition:enter="ease-out"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
            ></div>

            <!-- Modal Content -->
            <div
                class="scrollbar-sm relative flex w-full max-w-4xl flex-col overflow-hidden rounded-lg bg-white px-4 py-6 transition-opacity duration-300 dark:bg-navy-700 sm:px-5"
                x-show="showModal"
                x-transition:enter="ease-out"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="ease-in"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
            >
                <!-- Header -->
                <div class="flex justify-between items-center border-b pb-3">
                    <h2 class="text-lg font-bold text-gray-900 dark:text-gray-100">Payment History</h2>
                    <button @click="showModal = false" class="text-gray-500 hover:text-gray-700">&times;</button>
                </div>

                <!-- Table Wrapper (overflow auto) -->
                <div class="mt-4 overflow-auto max-h-[400px]">
                    <table class="w-full border-collapse border border-gray-300 text-sm">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th class="border p-2">#</th>
                                <th class="border p-2">Payment Number</th>
                                <th class="border p-2">Semester</th>
                                <th class="border p-2">Method</th>
                                <th class="border p-2">Amount Paid</th>
                                <th class="border p-2">Due</th>
                                <th class="border p-2">Total</th>
                                <th class="border p-2">Status</th>
                                <th class="border p-2">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <template x-if="paymentHistory.length > 0">
                                <template x-for="(row, index) in paymentHistory" :key="row.id">
                                    <tr>
                                        <td class="border p-2" x-text="index + 1"></td>
                                        <td class="border p-2" x-text="row.payment_number"></td>
                                        <td class="border p-2" x-text="row.semester"></td>
                                        <td class="border p-2" x-text="row.payment_method"></td>
                                        <td class="border p-2" x-text="row.payment_amount"></td>
                                        <td class="border p-2" x-text="row.due_amount"></td>
                                        <td class="border p-2" x-text="row.total_amount"></td>
                                        <td class="border p-2" x-text="row.payment_status"></td>
                                        <td class="border p-2" x-text="row.payment_received_date"></td>
                                    </tr>
                                </template>
                            </template>
                            <template x-if="paymentHistory.length === 0">
                                <tr>
                                    <td colspan="9" class="border p-3 text-center text-gray-500">No payment history found</td>
                                </tr>
                            </template>
                        </tbody>
                    </table>
                </div>

                <!-- Footer -->
                <div class="flex justify-end mt-4">
                    <button @click="showModal = false"
                        class="px-4 py-2 bg-gray-300 hover:bg-gray-400 rounded">Close</button>
                </div>
            </div>
        </div>
    </template>
</div>





    
    <!-- 
        This is a place for Alpine.js Teleport feature 
        @see https://alpinejs.dev/directives/teleport
      -->
    <div id="x-teleport-target"></div>
    <script>
      window.addEventListener("DOMContentLoaded", () => Alpine.start());
    </script>
  </body>
</html>